/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.mcap;

import com.martiansoftware.jsap.JSAPException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarStyle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.session.mcap.MCAPLogRepacker;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXApplicationCreator;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;

public class MCAPRepackApplication {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws JSAPException {
        boolean isOverride;
        String outputFileName;
        String inputFileName;
        int maxDuration;
        int minDuration;
        Options options = new Options();
        options.addOption("l", "chunkMin", true, "[Optional] Minimum duration of a chunk in milliseconds.");
        options.addOption("m", "chunkMax", true, "[Optional] Maximum duration of a chunk in milliseconds.");
        options.addOption("i", "input", true, "[Optional] Input file to repack. If not provided a file chooser will be opened.");
        options.addOption("o", "output", true, "[Optional] Output file repacked. If not provided a file chooser will be opened.");
        options.addOption("f", "force", false, "If present, the output file will be overwritten if it already exists.");
        options.addOption("h", "help", false, "Print this message.");
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                String header = "MCAP Repack Application: This application repacks an MCAP file. It rebuilds some of the MCAP records only reusing the minimum data from the original file. This can be useful to recover a MCAP file with corrupted timestamps or index references.";
                String footer = "Please report issues at https://github.com/ihmcrobotics/simulation-construction-set-2/issues.";
                formatter.printHelp("MCAPRepackApplication", header, options, footer, true);
                System.exit(0);
                return;
            }
            minDuration = Integer.parseInt(line.getOptionValue("chunkMin", "50"));
            maxDuration = Integer.parseInt(line.getOptionValue("chunkMax", "500"));
            inputFileName = line.getOptionValue("input");
            outputFileName = line.getOptionValue("output");
            isOverride = line.hasOption("force");
        }
        catch (Exception e) {
            System.err.println("Parsing failed, use option -h to see usage. Reason: " + e.getMessage());
            System.exit(0);
            return;
        }
        File inputFile = null;
        if (inputFileName != null && !(inputFile = new File(inputFileName)).exists()) {
            System.err.println("Cannot find input file: " + inputFile.getAbsolutePath());
            System.exit(0);
            return;
        }
        boolean javaFXStarted = false;
        if (inputFile == null) {
            JavaFXApplicationCreator.spawnJavaFXMainApplication();
            Platform.setImplicitExit((boolean)false);
            javaFXStarted = true;
            LogTools.info((String)"No input file provided, opening file chooser.");
            inputFile = JavaFXMissingTools.runAndWait(MCAPRepackApplication.class, () -> SessionVisualizerIOTools.showOpenDialog(null, "Select input file", new FileChooser.ExtensionFilter("MCAP files", new String[]{"*.mcap"}), "MCAPLogFilePath"));
        }
        if (inputFile == null) {
            System.err.println("No input file selected.");
            System.exit(0);
            return;
        }
        File outputFile = null;
        if (outputFileName != null) {
            outputFile = new File(outputFileName);
            if (outputFile.exists()) {
                if (!isOverride) {
                    LogTools.error((String)("Output file already exists: " + outputFile.getAbsolutePath() + ". Use the -f option to override it."));
                    System.exit(0);
                    return;
                }
                outputFile.delete();
            }
        } else {
            if (!javaFXStarted) {
                JavaFXApplicationCreator.spawnJavaFXMainApplication();
                Platform.setImplicitExit((boolean)false);
                javaFXStarted = true;
            }
            LogTools.info((String)"No output file provided, opening file chooser.");
            outputFile = JavaFXMissingTools.runAndWait(MCAPRepackApplication.class, () -> SessionVisualizerIOTools.showSaveDialog(null, "Select output file", new FileChooser.ExtensionFilter("MCAP files", new String[]{"*.mcap"}), "MCAPLogFilePath"));
        }
        if (outputFile == null) {
            System.err.println("No output file selected.");
            System.exit(0);
            return;
        }
        MCAPLogRepacker repacker = new MCAPLogRepacker();
        LogTools.info((String)("Repacking MCAP file: " + inputFile.getAbsolutePath() + " to " + outputFile.getAbsolutePath()));
        try (FileInputStream fileInputStream = new FileInputStream(inputFile);
             FileOutputStream outputStream = new FileOutputStream(outputFile);){
            ProgressConsumer progressConsumer = MCAPRepackApplication.newSimpleProgressConsumer();
            repacker.repack(new MCAP(fileInputStream.getChannel()), (long)minDuration, (long)maxDuration, outputStream, progressConsumer);
            return;
        }
        catch (Exception e) {
            LogTools.error((String)("Failed to repack MCAP file: " + e.getMessage()));
            e.printStackTrace();
            return;
        }
        finally {
            System.exit(0);
        }
    }

    @NotNull
    private static ProgressConsumer newSimpleProgressConsumer() {
        final ProgressBar progressBar = new ProgressBar("Repacking", 100L, 10, false, true, System.out, ProgressBarStyle.COLORFUL_UNICODE_BLOCK, "", 1L, false, null, ChronoUnit.SECONDS, 0L, Duration.ZERO);
        return new ProgressConsumer(){

            public void started(String task) {
            }

            public void info(String info) {
            }

            public void error(String error) {
            }

            public void progress(double progressPercentage) {
                progressBar.stepTo(Math.round(progressPercentage * 100.0));
            }

            public void done() {
                progressBar.stepTo(100L);
                ThreadTools.sleep((long)200L);
                LogTools.info((String)"Repacking done.");
            }
        };
    }
}

