/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.io.IOException;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.PickResult;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Sphere;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.camera.YoLevelOrbitalCoordinateDefinition;
import us.ihmc.scs2.definition.camera.YoOrbitalCoordinateDefinition;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple3DDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionPropertiesHelper;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.Camera3DOptionsPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.CameraControlMode;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.CameraFocalPointHandler;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.CameraOrbitHandler;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.LevelOrbitalCoordinateProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.OrbitalCoordinateProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.PerspectiveCameraController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SingleViewport3DManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.CompositePropertyTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.MenuTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;

public class MainViewport3DManager
implements SingleViewport3DManager {
    public static final String VIEWPORT_BACKGROUND_COLOR = SessionPropertiesHelper.loadStringPropertyOrEnvironment((String)"scs2.session.gui.viewport.background", (String)"SCS2_GUI_VIEWPORT_BACKGROUND", (String)"gray");
    private final Pane container;
    private final SubScene subScene;
    private final Group rootNode3D;
    private final YoManager yoManager;
    private final ReferenceFrameManager referenceFrameManager;
    private final PerspectiveCamera camera;
    private final PerspectiveCameraController cameraController;

    public MainViewport3DManager(Group mainView3DRoot, YoManager yoManager, YoCompositeSearchManager yoCompositeSearchManager, ReferenceFrameManager referenceFrameManager) {
        this.rootNode3D = mainView3DRoot;
        this.yoManager = yoManager;
        this.referenceFrameManager = referenceFrameManager;
        this.subScene = new SubScene((Parent)this.rootNode3D, -1.0, -1.0, true, SceneAntialiasing.BALANCED);
        this.subScene.setFill((Paint)Color.web((String)VIEWPORT_BACKGROUND_COLOR));
        this.subScene.setOnMousePressed(event -> this.subScene.requestFocus());
        this.container = new Pane(new Node[]{this.subScene});
        this.subScene.heightProperty().bind((ObservableValue)this.heightProperty());
        this.subScene.widthProperty().bind((ObservableValue)this.widthProperty());
        this.camera = new PerspectiveCamera(true);
        this.camera.setNearClip(0.05);
        this.camera.setFarClip(200000.0);
        this.subScene.setCamera((Camera)this.camera);
        this.cameraController = new PerspectiveCameraController(this.widthProperty(), this.heightProperty(), this.camera, (Vector3DReadOnly)Axis3D.Z, (Vector3DReadOnly)Axis3D.X);
        this.cameraController.enableShiftClickFocusTranslation();
        this.cameraController.start();
        this.subScene.addEventHandler(Event.ANY, (EventHandler)this.cameraController);
        Sphere focusPointViz = this.cameraController.getFocalPointViz();
        if (focusPointViz != null) {
            this.rootNode3D.getChildren().add((Object)focusPointViz);
            focusPointViz.visibleProperty().bind((ObservableValue)this.subScene.focusedProperty());
        }
        MainViewport3DManager.setupContextMenu(this.cameraController, yoCompositeSearchManager, yoManager, referenceFrameManager, (Node)this.subScene);
    }

    @Override
    public void startSession(Session session) {
    }

    @Override
    public void stopSession() {
        this.cameraController.cameraPositionCoordinatesToTrackProperty().setValue(null);
        this.cameraController.cameraOrbitalCoordinatesToTrackProperty().setValue(null);
        this.cameraController.cameraLevelOrbitalCoordinatesToTrackProperty().setValue(null);
        this.cameraController.getFocalPointHandler().coordinatesToTrackProperty().set(null);
        this.cameraController.getFocalPointHandler().nodeToTrackProperty().set(null);
    }

    @Override
    public boolean isSessionLoaded() {
        return true;
    }

    @Override
    public Pane getPane() {
        return this.container;
    }

    public ReadOnlyDoubleProperty widthProperty() {
        return this.container.widthProperty();
    }

    public ReadOnlyDoubleProperty heightProperty() {
        return this.container.heightProperty();
    }

    public SubScene getSubScene() {
        return this.subScene;
    }

    @Override
    public PerspectiveCamera getCamera() {
        return this.camera;
    }

    @Override
    public PerspectiveCameraController getCameraController() {
        return this.cameraController;
    }

    @Override
    public void dispose() {
        this.cameraController.stop();
    }

    public void setCameraFocalTargetTypeToTrack(CameraFocalPointHandler.TrackingTargetType targetType) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.cameraController.getFocalPointHandler().targetTypeProperty().set((Object)targetType));
    }

    public void setCameraFocalNodeToTrack(Node nodeToTrack) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.cameraController.getFocalPointHandler().nodeToTrackProperty().set((Object)nodeToTrack));
    }

    public void setCameraFocalPositionToTrack(YoTuple3DDefinition coordinatesToTrack) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            Tuple3DProperty coordinatesProperty;
            try {
                coordinatesProperty = CompositePropertyTools.toTuple3DProperty(this.yoManager.getRootRegistryDatabase(), this.referenceFrameManager, (YoCompositeDefinition)coordinatesToTrack);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.cameraController.getFocalPointHandler().coordinatesToTrackProperty().setValue((Object)coordinatesProperty);
        });
    }

    public void setCameraPositionToTrack(YoTuple3DDefinition coordinatesToTrack) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            Tuple3DProperty coordinatesProperty;
            try {
                coordinatesProperty = CompositePropertyTools.toTuple3DProperty(this.yoManager.getRootRegistryDatabase(), this.referenceFrameManager, (YoCompositeDefinition)coordinatesToTrack);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.cameraController.cameraPositionCoordinatesToTrackProperty().setValue((Object)coordinatesProperty);
        });
    }

    public void setCameraOrbitToTrack(YoOrbitalCoordinateDefinition coordinatesToTrack) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            OrbitalCoordinateProperty coordinatesProperty;
            try {
                coordinatesProperty = new OrbitalCoordinateProperty(CompositePropertyTools.toCompositeProperty(this.yoManager.getRootRegistryDatabase(), this.referenceFrameManager, (YoCompositeDefinition)coordinatesToTrack));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.cameraController.cameraOrbitalCoordinatesToTrackProperty().setValue((Object)coordinatesProperty);
        });
    }

    public void setCameraLevelOrbitToTrack(YoLevelOrbitalCoordinateDefinition coordinatesToTrack) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            LevelOrbitalCoordinateProperty coordinatesProperty;
            try {
                coordinatesProperty = new LevelOrbitalCoordinateProperty(CompositePropertyTools.toCompositeProperty(this.yoManager.getRootRegistryDatabase(), this.referenceFrameManager, (YoCompositeDefinition)coordinatesToTrack));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.cameraController.cameraLevelOrbitalCoordinatesToTrackProperty().setValue((Object)coordinatesProperty);
        });
    }

    public void setCameraPosition(double x, double y, double z) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.cameraController.setCameraPosition(x, y, z));
    }

    public void setCameraOrientation(double latitude, double longitude, double roll) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.cameraController.getOrbitHandler().setRotation(longitude, latitude, roll));
    }

    public void setCameraFocalPosition(double x, double y, double z) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.cameraController.setFocalPoint(x, y, z, false));
    }

    public void setCameraControlMode(CameraControlMode cameraControlMode) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.cameraController.cameraControlMode().setValue((Object)cameraControlMode));
    }

    public void setCameraZoom(double distanceFromFocus) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            CameraOrbitHandler orbitHandler = this.cameraController.getOrbitHandler();
            orbitHandler.distanceProperty().set(distanceFromFocus);
        });
    }

    static void setupContextMenu(PerspectiveCameraController cameraController, YoCompositeSearchManager searchManager, YoManager yoManager, ReferenceFrameManager referenceFrameManager, Node viewport) {
        MainViewport3DManager.setupContextMenu(cameraController, searchManager, yoManager, referenceFrameManager, viewport, node -> true);
    }

    static void setupContextMenu(PerspectiveCameraController cameraController, YoCompositeSearchManager searchManager, YoManager yoManager, ReferenceFrameManager referenceFrameManager, Node viewport, Predicate<Node> filter) {
        CameraFocalPointHandler focalPointHandler = cameraController.getFocalPointHandler();
        ObjectProperty<Node> nodeToTrackProperty = focalPointHandler.nodeToTrackProperty();
        MenuTools.setupContextMenu(viewport, (owner, event) -> {
            PickResult pickResult = event.getPickResult();
            Node intersectedNode = pickResult.getIntersectedNode();
            if (intersectedNode == null || intersectedNode instanceof SubScene || intersectedNode == viewport || intersectedNode == nodeToTrackProperty.get() || !filter.test(intersectedNode)) {
                return null;
            }
            MenuItem menuItem = new MenuItem("Start tracking node: " + intersectedNode.getId());
            menuItem.setOnAction(e -> nodeToTrackProperty.set((Object)intersectedNode));
            return menuItem;
        }, (owner, event) -> {
            if (nodeToTrackProperty.get() == null || focalPointHandler.isTrackingDisabled()) {
                return null;
            }
            MenuItem menuItem = new MenuItem("Stop tracking node: " + ((Node)nodeToTrackProperty.get()).getId());
            menuItem.setOnAction(e -> nodeToTrackProperty.set(null));
            return menuItem;
        }, (owner, event) -> {
            MenuItem menuItem = new MenuItem("Camera properties...");
            menuItem.setOnAction(e -> MainViewport3DManager.openCameraPropertiesDialog(cameraController, searchManager, yoManager.getLinkedRootRegistry(), referenceFrameManager, viewport));
            return menuItem;
        });
    }

    static void openCameraPropertiesDialog(PerspectiveCameraController cameraController, YoCompositeSearchManager searchManager, LinkedYoRegistry linkedRootRegistry, ReferenceFrameManager referenceFrameManager, Node viewport) {
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.CAMERA3D_OPTIONS_PANE_URL);
            Pane rootPane = (Pane)loader.load();
            Camera3DOptionsPaneController controller = (Camera3DOptionsPaneController)loader.getController();
            controller.initialize(cameraController, searchManager, linkedRootRegistry, referenceFrameManager);
            Stage window = new Stage(StageStyle.UTILITY);
            window.setScene(new Scene((Parent)rootPane));
            window.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
                if (e.getCode() == KeyCode.ESCAPE) {
                    window.close();
                }
            });
            Window owner = viewport.getScene().getWindow();
            owner.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
                if (!e.isConsumed()) {
                    window.close();
                    controller.closeAndDispose();
                }
            });
            window.initOwner(owner);
            window.setTitle("Camera 3D options");
            window.setOpacity(0.0);
            window.toFront();
            window.show();
            Timeline timeline = new Timeline();
            KeyFrame key = new KeyFrame(Duration.seconds((double)0.125), new KeyValue[]{new KeyValue((WritableValue)window.opacityProperty(), (Object)1.0)});
            timeline.getKeyFrames().add((Object)key);
            timeline.play();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

