/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameWrapper;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.CompositePropertyTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple2DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXItem;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGroupFX;

public class YoGraphicFXControllerTools {
    public static List<Class<? extends YoGraphicFXItem>> yoGraphicFXTypes;
    public static List<Class<? extends YoGraphicFX2D>> yoGraphicFX2DTypes;
    public static List<Class<? extends YoGraphicFX3D>> yoGraphicFX3DTypes;

    public static void loadResources() {
    }

    public static YoGraphicFXItem duplicateYoGraphicFXItemAndRegister(YoGraphicFXItem itemToDuplicate) {
        String cloneName = YoGraphicFXControllerTools.createAvailableYoGraphicFXItemName(itemToDuplicate.getRootGroup(), itemToDuplicate.getNamespace(), itemToDuplicate.getName(), itemToDuplicate.getClass());
        YoGraphicFXItem clone = itemToDuplicate.clone();
        clone.setName(cloneName);
        itemToDuplicate.getParentGroup().addYoGraphicFXItem(clone);
        return clone;
    }

    public static YoGraphicFXItem createYoGraphicFXItemAndRegister(ReferenceFrameWrapper worldFrame, YoGroupFX parentGroup, String itemName, Class<? extends YoGraphicFXItem> itemTypeToInstantiate) {
        if (itemTypeToInstantiate == YoGroupFX.class) {
            YoGroupFX item = new YoGroupFX(itemName);
            boolean success = parentGroup.addChild(item);
            return success ? item : null;
        }
        if (YoGraphicFX.class.isAssignableFrom(itemTypeToInstantiate)) {
            YoGraphicFX item = YoGraphicFXControllerTools.newInstance(worldFrame, itemTypeToInstantiate);
            item.setName(itemName);
            boolean success = parentGroup.addYoGraphicFXItem(item);
            return success ? item : null;
        }
        throw new RuntimeException("Unexpected item type: " + itemTypeToInstantiate.getSimpleName());
    }

    private static YoGraphicFX newInstance(ReferenceFrameWrapper worldFrame, Class<? extends YoGraphicFX> itemTypeToInstantiate) {
        try {
            Constructor<? extends YoGraphicFX> constructor = itemTypeToInstantiate.getConstructor(ReferenceFrameWrapper.class);
            return constructor.newInstance(worldFrame);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Something went wrong when instantiating a YoGraphicFX attempting to invoke its constructor with ReferenceFrame argument: ", e);
        }
    }

    public static <G extends YoGraphicFXItem> String createAvailableYoGraphicFXItemName(YoGroupFX root, String namespace, String initialName, Class<G> itemType) {
        if (YoGraphicFX2D.class.isAssignableFrom(itemType)) {
            return YoGraphicFXControllerTools.createAvailableYoGraphicFX2DName(root, namespace, initialName);
        }
        if (YoGraphicFX3D.class.isAssignableFrom(itemType)) {
            return YoGraphicFXControllerTools.createAvailableYoGraphicFX3DName(root, namespace, initialName);
        }
        if (YoGroupFX.class.isAssignableFrom(itemType)) {
            return YoGraphicFXControllerTools.createAvailableYoGraphicFXGroupName(root, namespace, initialName);
        }
        throw new RuntimeException("Unexpected item type: " + itemType.getSimpleName());
    }

    public static String createAvailableYoGraphicFX2DName(YoGroupFX root, String namespace, String initialName) {
        return YoGraphicFXControllerTools.createAvailableYoGraphicFXItemName(root, namespace, initialName, YoGroupFX::containsYoGraphicFX2D);
    }

    public static String createAvailableYoGraphicFX3DName(YoGroupFX root, String namespace, String initialName) {
        return YoGraphicFXControllerTools.createAvailableYoGraphicFXItemName(root, namespace, initialName, YoGroupFX::containsYoGraphicFX3D);
    }

    public static String createAvailableYoGraphicFXGroupName(YoGroupFX root, String namespace, String initialName) {
        return YoGraphicFXControllerTools.createAvailableYoGraphicFXItemName(root, namespace, initialName, YoGroupFX::containsChild);
    }

    private static String createAvailableYoGraphicFXItemName(YoGroupFX root, String namespace, String initialName, BiPredicate<YoGroupFX, String> doesNameExistFunction) {
        String lastNumber;
        YoGroupFX group = YoGraphicTools.findYoGraphicFXGroup(root, namespace);
        if (group == null) {
            return initialName;
        }
        Object guessName = initialName;
        int startIndex = 0;
        String[] numbers = initialName.split("[^0-9]+");
        if (numbers.length > 0 && initialName.endsWith(lastNumber = numbers[numbers.length - 1])) {
            startIndex = Integer.parseInt(lastNumber);
            initialName = initialName.substring(0, initialName.length() - lastNumber.length());
        }
        for (int i = startIndex; i < Integer.MAX_VALUE; ++i) {
            if (!doesNameExistFunction.test(group, (String)guessName)) {
                return guessName;
            }
            guessName = initialName + Integer.toString(i + 1);
        }
        return null;
    }

    public static <G extends YoGraphicFXItem> String createAvailableYoGraphicFXItemName(YoGroupFX parentGroup, String initialName, Class<G> itemType) {
        if (YoGraphicFX2D.class.isAssignableFrom(itemType)) {
            return YoGraphicFXControllerTools.createAvailableYoGraphicFX2DName(parentGroup, initialName);
        }
        if (YoGraphicFX3D.class.isAssignableFrom(itemType)) {
            return YoGraphicFXControllerTools.createAvailableYoGraphicFX3DName(parentGroup, initialName);
        }
        if (YoGroupFX.class.isAssignableFrom(itemType)) {
            return YoGraphicFXControllerTools.createAvailableYoGraphicFXGroupName(parentGroup, initialName);
        }
        throw new RuntimeException("Unexpected item type: " + itemType.getSimpleName());
    }

    public static String createAvailableYoGraphicFX2DName(YoGroupFX parentGroup) {
        return YoGraphicFXControllerTools.createAvailableYoGraphicFX2DName(parentGroup, YoGraphicFX2D.class.getSimpleName());
    }

    public static String createAvailableYoGraphicFX2DName(YoGroupFX parentGroup, String initialName) {
        return YoGraphicFXControllerTools.createAvailableYoGraphicFXItemName(parentGroup, initialName, YoGroupFX::containsYoGraphicFX2D);
    }

    public static String createAvailableYoGraphicFX3DName(YoGroupFX parentGroup) {
        return YoGraphicFXControllerTools.createAvailableYoGraphicFX3DName(parentGroup, YoGraphicFX3D.class.getSimpleName());
    }

    public static String createAvailableYoGraphicFX3DName(YoGroupFX parentGroup, String initialName) {
        return YoGraphicFXControllerTools.createAvailableYoGraphicFXItemName(parentGroup, initialName, YoGroupFX::containsYoGraphicFX3D);
    }

    public static String createAvailableYoGraphicFXGroupName(YoGroupFX parentGroup) {
        return YoGraphicFXControllerTools.createAvailableYoGraphicFXGroupName(parentGroup, YoGroupFX.class.getSimpleName());
    }

    public static String createAvailableYoGraphicFXGroupName(YoGroupFX parentGroup, String initialName) {
        return YoGraphicFXControllerTools.createAvailableYoGraphicFXItemName(parentGroup, initialName, YoGroupFX::containsChild);
    }

    private static String createAvailableYoGraphicFXItemName(YoGroupFX parentGroup, String initialName, BiPredicate<YoGroupFX, String> doesNameExistFunction) {
        String lastNumber;
        if (parentGroup == null) {
            return initialName;
        }
        Object guessName = initialName;
        int startIndex = 0;
        String[] numbers = initialName.split("[^0-9]+");
        if (numbers.length > 0 && initialName.endsWith(lastNumber = numbers[numbers.length - 1])) {
            startIndex = Integer.parseInt(lastNumber);
            initialName = initialName.substring(0, initialName.length() - lastNumber.length());
        }
        for (int i = startIndex; i < Integer.MAX_VALUE; ++i) {
            if (!doesNameExistFunction.test(parentGroup, (String)guessName)) {
                return guessName;
            }
            guessName = initialName + Integer.toString(i + 1);
        }
        return null;
    }

    public static ChangeListener<String> numericalValidityBinding(StringProperty stringProperty, BooleanProperty validityProperty) {
        ChangeListener listener = (observable, oldValue, newValue) -> validityProperty.set(CompositePropertyTools.isParsableAsDouble(newValue));
        stringProperty.addListener(listener);
        return listener;
    }

    public static InvalidationListener fullnameValidityBinding(StringProperty nameProperty, StringProperty namespaceProperty, BooleanProperty validityProperty, YoGroupFX rootGroup, YoGraphicFXItem yoGraphicFXItem) {
        Supplier<YoGraphicFXItem> searchBasedYoGraphicSupplier = () -> YoGraphicTools.findYoGraphicFXItem(rootGroup, (String)namespaceProperty.get(), (String)nameProperty.get(), yoGraphicFXItem.getClass());
        return YoGraphicFXControllerTools.fullnameValidityBinding(nameProperty, namespaceProperty, validityProperty, yoGraphicFXItem, searchBasedYoGraphicSupplier);
    }

    private static <T> InvalidationListener fullnameValidityBinding(StringProperty nameProperty, StringProperty namespaceProperty, BooleanProperty validityProperty, T yoGraphicFX, Supplier<T> searchBasedYoGraphicSupplier) {
        InvalidationListener listener = observable -> {
            if (nameProperty.get() == null || ((String)nameProperty.get()).isEmpty()) {
                validityProperty.set(false);
            } else {
                Object searchResult = searchBasedYoGraphicSupplier.get();
                validityProperty.set(searchResult == null || searchResult == yoGraphicFX);
            }
        };
        listener.invalidated(null);
        nameProperty.addListener(listener);
        namespaceProperty.addListener(listener);
        return listener;
    }

    public static ChangeListener<Boolean> bindValidityImageView(ObservableBooleanValue observableBoolean, ImageView imageView) {
        return YoGraphicFXControllerTools.bindBooleanToImageView(observableBoolean, imageView, SessionVisualizerIOTools.VALID_ICON_IMAGE, SessionVisualizerIOTools.INVALID_ICON_IMAGE);
    }

    public static ChangeListener<Boolean> bindBooleanToImageView(ObservableBooleanValue observableBoolean, ImageView imageView, Image imageWhenTrue, Image imageWhenFalse) {
        YoGraphicFXControllerTools.updateImageView(observableBoolean.get(), imageView, imageWhenTrue, imageWhenFalse);
        ChangeListener listener = (observable, oldValue, newValue) -> {
            if (newValue.equals(oldValue)) {
                return;
            }
            YoGraphicFXControllerTools.updateImageView(newValue, imageView, imageWhenTrue, imageWhenFalse);
        };
        observableBoolean.addListener(listener);
        return listener;
    }

    public static void updateImageView(boolean value, ImageView imageView, Image imageWhenTrue, Image imageWhenFalse) {
        imageView.setImage(value ? imageWhenTrue : imageWhenFalse);
    }

    public static String replaceAndMatchCase(String original, String search, String replacement) {
        int indexOf = original.toLowerCase().indexOf(search.toLowerCase());
        if (indexOf == -1) {
            return original;
        }
        replacement = Character.isUpperCase(original.charAt(indexOf)) ? Character.toUpperCase(((String)replacement).charAt(0)) + ((String)replacement).substring(1) : Character.toLowerCase(((String)replacement).charAt(0)) + ((String)replacement).substring(1);
        return original.replaceAll("(?i)" + search, (String)replacement);
    }

    public static ReadOnlyObjectProperty<List<DoubleProperty>> toSingletonDoubleSupplierListProperty(ReadOnlyObjectProperty<List<DoubleProperty[]>> inputProperty) {
        SimpleObjectProperty output = new SimpleObjectProperty(null, "singletonSupplierList", null);
        inputProperty.addListener((arg_0, arg_1, arg_2) -> YoGraphicFXControllerTools.lambda$toSingletonDoubleSupplierListProperty$12((ObjectProperty)output, arg_0, arg_1, arg_2));
        return output;
    }

    public static ReadOnlyObjectProperty<List<Tuple2DProperty>> toTuple2DDoubleSupplierListProperty(ReadOnlyObjectProperty<List<DoubleProperty[]>> inputProperty) {
        SimpleObjectProperty output = new SimpleObjectProperty(null, "tuple2DSupplierList", null);
        inputProperty.addListener((arg_0, arg_1, arg_2) -> YoGraphicFXControllerTools.lambda$toTuple2DDoubleSupplierListProperty$14((ObjectProperty)output, arg_0, arg_1, arg_2));
        return output;
    }

    public static ReadOnlyObjectProperty<List<Tuple3DProperty>> toTuple3DDoubleSupplierListProperty(ReadOnlyObjectProperty<List<DoubleProperty[]>> inputProperty) {
        SimpleObjectProperty output = new SimpleObjectProperty(null, "tuple3DSupplierList", null);
        inputProperty.addListener((arg_0, arg_1, arg_2) -> YoGraphicFXControllerTools.lambda$toTuple3DDoubleSupplierListProperty$16((ObjectProperty)output, arg_0, arg_1, arg_2));
        return output;
    }

    /*
     * Exception decompiling
     */
    public static List<String[]> convertSingletonsToArrays(List<String> definitions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void lambda$toTuple3DDoubleSupplierListProperty$16(ObjectProperty output, ObservableValue o, List oldValue, List newValue) {
        output.set(newValue.stream().map(array -> new Tuple3DProperty(null, (DoubleProperty[])array)).collect(Collectors.toList()));
    }

    private static /* synthetic */ void lambda$toTuple2DDoubleSupplierListProperty$14(ObjectProperty output, ObservableValue o, List oldValue, List newValue) {
        output.set(newValue.stream().map(array -> new Tuple2DProperty(null, (DoubleProperty[])array)).collect(Collectors.toList()));
    }

    private static /* synthetic */ void lambda$toSingletonDoubleSupplierListProperty$12(ObjectProperty output, ObservableValue o, List oldValue, List newValue) {
        output.set(newValue.stream().map(array -> array[0]).collect(Collectors.toList()));
    }

    static {
        Thread loader = new Thread(() -> {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)YoGraphicFXItem.class.getPackage().getName(), (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner()}));
            Set yoGraphicFXSubTypes = reflections.getSubTypesOf(YoGraphicFXItem.class);
            yoGraphicFXTypes = yoGraphicFXSubTypes.stream().filter(type -> !Modifier.isAbstract(type.getModifiers()) && !type.isInterface()).sorted((c1, c2) -> c1.getSimpleName().compareTo(c2.getSimpleName())).collect(Collectors.toList());
            Set yoGraphicFX2DSubTypes = reflections.getSubTypesOf(YoGraphicFX2D.class);
            yoGraphicFX2DTypes = yoGraphicFX2DSubTypes.stream().filter(type -> !Modifier.isAbstract(type.getModifiers()) && !type.isInterface()).sorted((c1, c2) -> c1.getSimpleName().compareTo(c2.getSimpleName())).collect(Collectors.toList());
            Set yoGraphicFX3DSubTypes = reflections.getSubTypesOf(YoGraphicFX3D.class);
            yoGraphicFX3DTypes = yoGraphicFX3DSubTypes.stream().filter(type -> !Modifier.isAbstract(type.getModifiers()) && !type.isInterface()).sorted((c1, c2) -> c1.getSimpleName().compareTo(c2.getSimpleName())).collect(Collectors.toList());
        }, "YoGraphicFX Loader");
        loader.setPriority(1);
        loader.setDaemon(true);
        loader.start();
    }
}

