/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.charts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.util.Pair;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartGroupModel;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIdentifier;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.yoVariables.variable.YoVariable;

public class ChartGroupLayout
extends ChartGroupModel {
    private final Map<ChartIdentifier, List<YoVariable>> layout;

    public ChartGroupLayout(ChartGroupModel model, YoComposite yoComposite) {
        super(model);
        List<YoVariable> yoComponents = yoComposite.getYoComponents();
        if (model.getChartIdentifiers().size() != yoComponents.size()) {
            throw new IllegalArgumentException("Given model does not match yoComposite: " + yoComposite.getPattern().getType());
        }
        this.layout = new HashMap<ChartIdentifier, List<YoVariable>>();
        List<ChartIdentifier> chartIdentifiers = this.getChartIdentifiers();
        for (int i = 0; i < chartIdentifiers.size(); ++i) {
            ChartIdentifier chartIdentifier = chartIdentifiers.get(i);
            List<YoVariable> yoVariables = this.layout.get(chartIdentifier);
            if (yoVariables == null) {
                yoVariables = new ArrayList<YoVariable>();
                this.layout.put(chartIdentifier, yoVariables);
            }
            yoVariables.add(yoComponents.get(i));
        }
    }

    public ChartGroupLayout(String name, Map<ChartIdentifier, List<? extends YoVariable>> layout) {
        super(name, new ArrayList<ChartIdentifier>(layout.keySet()));
        this.layout = new LinkedHashMap<ChartIdentifier, List<YoVariable>>();
        layout.entrySet().forEach(entry -> this.layout.put((ChartIdentifier)entry.getKey(), new ArrayList((Collection)entry.getValue())));
    }

    public List<YoVariable> getYoVariables(ChartIdentifier chartIdentifier) {
        return this.layout.get(chartIdentifier);
    }

    @Override
    public ChartGroupLayout shift(int rowShift, int columnShift) {
        return new ChartGroupLayout(this.getName(), this.layout.entrySet().stream().map(entry -> new Pair((Object)((ChartIdentifier)entry.getKey()).shift(rowShift, columnShift), (Object)((List)entry.getValue()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
    }

    @Override
    public int hashCode() {
        return this.layout.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ChartGroupLayout) {
            ChartGroupLayout other = (ChartGroupLayout)object;
            return this.layout.equals(other.layout);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getName() + ": " + this.layout.toString();
    }
}

