/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.AmbientLight;
import javafx.scene.Group;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.PointLight;
import javafx.scene.paint.Color;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinitionFactory;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXVisualTools;

public class Scene3DBuilder {
    private final Group root = new Group();
    private final ObservableList<LightBase> allLights = FXCollections.observableArrayList();

    public static Node coordinateSystem(double size) {
        VisualDefinitionFactory factory = new VisualDefinitionFactory();
        factory.addCoordinateSystem(size, (ColorDefinition)null);
        return JavaFXVisualTools.collectNodes(factory.getVisualDefinitions());
    }

    public Scene3DBuilder() {
        this.root.getChildren().addListener((ListChangeListener)new LightsChangedListener());
    }

    public void addDefaultLighting() {
        double ambientValue = 0.7;
        double pointValue = 0.2;
        double pointDistance = 1000.0;
        Color ambientColor = Color.color((double)ambientValue, (double)ambientValue, (double)ambientValue);
        this.addNodeToView((Node)new AmbientLight(ambientColor));
        Color indoorColor = Color.color((double)pointValue, (double)pointValue, (double)pointValue);
        this.addPointLight(pointDistance, pointDistance, pointDistance, indoorColor);
        this.addPointLight(-pointDistance, pointDistance, pointDistance, indoorColor);
        this.addPointLight(-pointDistance, -pointDistance, pointDistance, indoorColor);
        this.addPointLight(pointDistance, -pointDistance, pointDistance, indoorColor);
    }

    public void addPointLight(double x, double y, double z) {
        this.addPointLight(x, y, z, Color.WHITE);
    }

    public void addPointLight(double x, double y, double z, Color color) {
        PointLight light = new PointLight(color);
        light.setTranslateX(x);
        light.setTranslateY(y);
        light.setTranslateZ(z);
        this.addNodeToView((Node)light);
    }

    public void addCoordinateSystem(double scale) {
        this.addNodeToView(Scene3DBuilder.coordinateSystem(scale));
    }

    public void addNodesToView(Iterable<? extends Node> nodes) {
        nodes.forEach(this::addNodeToView);
    }

    public void addNodeToView(Node node) {
        this.root.getChildren().add((Object)node);
    }

    public void setRootMouseTransparent(boolean value) {
        this.root.setMouseTransparent(value);
    }

    public ObservableList<LightBase> getAllLights() {
        return this.allLights;
    }

    public Group getRoot() {
        return this.root;
    }

    public static ObservableList<LightBase> cloneAndBindLights(ObservableList<LightBase> original) {
        ObservableList clone = FXCollections.observableArrayList(original);
        Scene3DBuilder.setupLigthCloneList((ObservableList<? super LightBase>)clone, original);
        return clone;
    }

    public static ListChangeListener<LightBase> setupLigthCloneList(final ObservableList<? super LightBase> listToBind, ObservableList<? extends LightBase> original) {
        listToBind.setAll((Collection)original.stream().map(l -> Scene3DBuilder.cloneAndBindLight(l)).collect(Collectors.toList()));
        ListChangeListener<LightBase> listener = new ListChangeListener<LightBase>(){

            public void onChanged(ListChangeListener.Change<? extends LightBase> change) {
                while (change.next()) {
                    if (change.wasPermutated()) {
                        for (int oldIndex = change.getFrom(); oldIndex < change.getTo(); ++oldIndex) {
                            int newIndex = change.getPermutation(oldIndex);
                            Collections.swap(listToBind, oldIndex, newIndex);
                        }
                        continue;
                    }
                    if (change.wasUpdated()) {
                        LogTools.error((String)"wasUpdated is not handled!");
                        continue;
                    }
                    if (change.wasReplaced()) {
                        for (int i = change.getFrom(); i < change.getTo(); ++i) {
                            listToBind.set(i, (Object)Scene3DBuilder.cloneAndBindLight((LightBase)change.getList().get(i)));
                        }
                        continue;
                    }
                    if (change.wasRemoved()) {
                        listToBind.remove(change.getFrom(), change.getTo());
                    }
                    if (!change.wasAdded()) continue;
                    listToBind.addAll(change.getFrom(), (Collection)change.getAddedSubList().stream().map(l -> Scene3DBuilder.cloneAndBindLight(l)).collect(Collectors.toList()));
                }
            }
        };
        original.addListener((ListChangeListener)listener);
        return listener;
    }

    public static <L extends LightBase> L cloneAndBindLight(L original) {
        AmbientLight clone;
        if (original == null) {
            return null;
        }
        if (original.getClass() == AmbientLight.class) {
            clone = new AmbientLight();
        } else if (original.getClass() == PointLight.class) {
            clone = new PointLight();
        } else {
            throw new UnsupportedOperationException("Unsupported light type: " + original);
        }
        clone.colorProperty().bindBidirectional((Property)original.colorProperty());
        clone.getTransforms().setAll((Collection)original.getTransforms());
        clone.translateXProperty().bindBidirectional((Property)original.translateXProperty());
        clone.translateYProperty().bindBidirectional((Property)original.translateYProperty());
        clone.translateZProperty().bindBidirectional((Property)original.translateZProperty());
        clone.rotateProperty().bindBidirectional((Property)original.rotateProperty());
        clone.rotationAxisProperty().bind((ObservableValue)original.rotationAxisProperty());
        return (L)clone;
    }

    private class LightsChangedListener
    implements ListChangeListener<Node> {
        private LightsChangedListener() {
        }

        public void onChanged(ListChangeListener.Change<? extends Node> change) {
            while (change.next()) {
                for (Node removedNode : change.getRemoved()) {
                    if (removedNode instanceof LightBase) {
                        Scene3DBuilder.this.allLights.remove((Object)((LightBase)removedNode));
                        continue;
                    }
                    if (!(removedNode instanceof Group)) continue;
                    Group removedGroup = (Group)removedNode;
                    this.removeLightsRecursive((Node)removedGroup);
                    removedGroup.getChildren().removeListener((ListChangeListener)this);
                }
                for (Node addedNode : change.getAddedSubList()) {
                    if (addedNode instanceof LightBase) {
                        Scene3DBuilder.this.allLights.add((Object)((LightBase)addedNode));
                        continue;
                    }
                    if (!(addedNode instanceof Group)) continue;
                    Group addedGroup = (Group)addedNode;
                    this.addLightsRecursive((Node)addedGroup);
                    addedGroup.getChildren().addListener((ListChangeListener)this);
                }
            }
        }

        private void addLightsRecursive(Node group) {
            for (Node child : ((Group)group).getChildren()) {
                if (child instanceof LightBase) {
                    Scene3DBuilder.this.allLights.add((Object)((LightBase)child));
                    continue;
                }
                if (!(child instanceof Group)) continue;
                this.addLightsRecursive(child);
            }
        }

        private void removeLightsRecursive(Node group) {
            for (Node child : ((Group)group).getChildren()) {
                if (child instanceof LightBase) {
                    Scene3DBuilder.this.allLights.remove((Object)((LightBase)child));
                    continue;
                }
                if (!(child instanceof Group)) continue;
                this.removeLightsRecursive(child);
            }
        }
    }
}

