/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Pair;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.log.LogTools;
import us.ihmc.messager.SynchronizeHint;
import us.ihmc.scs2.definition.DefinitionIOTools;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.yoVariable.YoEquationListDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionIOTools;
import us.ihmc.scs2.session.SessionPropertiesHelper;
import us.ihmc.scs2.sessionVisualizer.jfx.MainWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.SCSGuiConfiguration;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.YoNameDisplay;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.entry.YoEntryTabPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.session.OpenSessionControlsRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.session.SessionControlsController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.SessionInfoController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.LogSessionManagerController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.mcap.MCAPLogSessionManagerController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.remote.RemoteSessionManagerController;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.SCS2JavaFXMessager;
import us.ihmc.scs2.symbolic.YoEquationManager;

public class MultiSessionManager {
    private static final boolean LOAD_SESSION_SYNCHRONOUS = SessionPropertiesHelper.loadBooleanPropertyOrEnvironment((String)"scs2.session.gui.loadconfig.synchronous", (String)"SCS2_GUI_LOAD_SESSION_SYNCHRONOUS", (boolean)true);
    private static final boolean LOAD_SESSION_TIME = SessionPropertiesHelper.loadBooleanProperty((String)"scs2.session.gui.loadconfig.time", (boolean)false);
    private static final boolean LOAD_MAIN_WINDOW_CONFIGURATION = SessionPropertiesHelper.loadBooleanProperty((String)"scs2.session.gui.mainwindow.loadconfig", (boolean)true);
    private static final boolean LOAD_BUFFER_SIZE_CONFIGURATION = SessionPropertiesHelper.loadBooleanProperty((String)"scs2.session.gui.buffersize.loadconfig", (boolean)false);
    private final SessionVisualizerToolkit toolkit;
    private final MainWindowController mainWindowController;
    private final Map<Class<? extends SessionControlsController>, SessionControlsController> inactiveControllerMap = new HashMap<Class<? extends SessionControlsController>, SessionControlsController>();
    private final ObjectProperty<SessionControlsController> activeController = new SimpleObjectProperty((Object)this, "activeSessionControls", null);
    private final ObjectProperty<Session> activeSession = new SimpleObjectProperty((Object)this, "activeSession", null);
    private boolean isFirstSession = true;
    private String robotName;
    private String sessionName;

    public MultiSessionManager(SessionVisualizerToolkit toolkit, MainWindowController mainWindowController) {
        this.toolkit = toolkit;
        this.mainWindowController = mainWindowController;
        this.activeSession.addListener((o, oldValue, newValue) -> {
            JavaFXMissingTools.runAndWait(this.getClass(), () -> {
                if (toolkit.hasActiveSession()) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to save the default configuration?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
                    Stage owner = this.activeController.get() != null ? ((SessionControlsController)this.activeController.get()).getStage() : toolkit.getMainWindow();
                    alert.initOwner((Window)owner);
                    JavaFXMissingTools.centerDialogInOwner(alert);
                    SessionVisualizerIOTools.addSCSIconToDialog(alert);
                    Optional result = alert.showAndWait();
                    this.stopSession(result.isPresent() && result.get() == ButtonType.YES, true);
                    if (oldValue != null) {
                        oldValue.shutdownSession();
                    }
                }
            });
            if (newValue != null) {
                this.startSession((Session)newValue, () -> {
                    if (this.activeController.get() != null) {
                        ((SessionControlsController)this.activeController.get()).notifySessionLoaded();
                    }
                });
            }
        });
        SessionVisualizerTopics topics = toolkit.getTopics();
        SCS2JavaFXMessager messager = toolkit.getMessager();
        messager.addTopicListener(topics.getStartNewSessionRequest(), m -> this.activeSession.set(m));
        messager.addFXTopicListener(topics.getOpenSessionControlsRequest(), m -> this.openSessionControls((OpenSessionControlsRequest)m));
        messager.addFXTopicListener(topics.getSessionVisualizerConfigurationLoadRequest(), m -> this.loadSessionConfiguration((File)m));
        messager.addFXTopicListener(topics.getSessionVisualizerConfigurationSaveRequest(), m -> this.saveSessionConfiguration((File)m, toolkit.getSession()));
        messager.addFXTopicListener(topics.getSessionVisualizerDefaultConfigurationLoadRequest(), m -> this.loadSessionDefaultConfiguration(toolkit.getSession()));
        messager.addFXTopicListener(topics.getSessionVisualizerDefaultConfigurationSaveRequest(), m -> this.saveSessionDefaultConfiguration(toolkit.getSession()));
    }

    public void startSession(Session session, Runnable sessionLoadedCallback) {
        Runnable callback = () -> {
            try {
                this.loadSessionDefaultConfiguration(session);
            }
            finally {
                if (sessionLoadedCallback != null) {
                    sessionLoadedCallback.run();
                }
                this.isFirstSession = false;
            }
        };
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            this.toolkit.startSession(session, callback);
            this.mainWindowController.startSession();
        });
    }

    public void stopSession(boolean saveConfiguration, boolean shutdownSession) {
        if (!this.toolkit.hasActiveSession()) {
            return;
        }
        if (saveConfiguration) {
            this.saveSessionDefaultConfiguration(this.toolkit.getSession());
        }
        this.toolkit.stopSession(shutdownSession);
        this.mainWindowController.stopSession();
        this.inactiveControllerMap.values().forEach(SessionControlsController::unloadSession);
    }

    private void openSessionControls(OpenSessionControlsRequest request) {
        Class controllerType;
        URL fxml;
        switch (request.getSessionType()) {
            case LOG: {
                fxml = SessionVisualizerIOTools.LOG_SESSION_MANAGER_PANE_FXML_URL;
                controllerType = LogSessionManagerController.class;
                break;
            }
            case REMOTE: {
                fxml = SessionVisualizerIOTools.REMOTE_SESSION_MANAGER_PANE_FXML_URL;
                controllerType = RemoteSessionManagerController.class;
                break;
            }
            case MCAP: {
                fxml = SessionVisualizerIOTools.MCAP_LOG_SESSION_MANAGER_PANE_FXML_URL;
                controllerType = MCAPLogSessionManagerController.class;
                break;
            }
            default: {
                LogTools.error((String)"Unhandled session type {}", (Object)((Object)request.getSessionType()));
                return;
            }
        }
        this.openSessionControls(request.getSource(), controllerType, fxml);
    }

    private void openSessionControls(Window source, Class<? extends SessionControlsController> controllerType, URL fxml) {
        SessionInfoController sessionInfoController;
        SessionControlsController controller;
        SessionControlsController activeSessionControls = (SessionControlsController)this.activeController.get();
        if (activeSessionControls != null) {
            if (!controllerType.isInstance(activeSessionControls)) {
                this.closeSessionControls(activeSessionControls);
            } else {
                activeSessionControls.bringUp(source);
                return;
            }
        }
        if ((controller = this.inactiveControllerMap.remove(controllerType)) == null) {
            try {
                FXMLLoader loader = new FXMLLoader(fxml);
                loader.load();
                controller = (SessionControlsController)loader.getController();
                controller.initialize(this.toolkit);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((sessionInfoController = controller.getSessionInfoController()) != null) {
            Pane infoPane = sessionInfoController.getMainPane();
            this.mainWindowController.getSceneAnchorPane().getChildren().add((Object)infoPane);
            AnchorPane.setLeftAnchor((Node)infoPane, (Double)5.0);
            AnchorPane.setBottomAnchor((Node)infoPane, (Double)5.0);
        }
        this.activeController.set((Object)controller);
        controller.bringUp(source);
    }

    private void closeSessionControls(SessionControlsController controller) {
        SessionInfoController sessionInfo = controller.getSessionInfoController();
        if (sessionInfo != null) {
            this.mainWindowController.getSceneAnchorPane().getChildren().remove((Object)sessionInfo.getMainPane());
        }
        controller.getStage().close();
        if (this.activeController.get() != null) {
            this.inactiveControllerMap.put(((SessionControlsController)this.activeController.get()).getClass(), (SessionControlsController)this.activeController.get());
        }
        if (this.activeController.get() == controller) {
            this.activeController.set(null);
        }
    }

    public void loadSessionDefaultConfiguration(Session session) {
        this.robotName = session.getRobotDefinitions().isEmpty() ? "UnknownRobot" : EuclidCoreIOTools.getCollectionString((String)"-", (Collection)session.getRobotDefinitions(), RobotDefinition::getName);
        this.sessionName = session.getSessionName();
        SCSGuiConfiguration configuration = SCSGuiConfiguration.defaultLoader(this.robotName, this.sessionName);
        if (configuration == null || configuration.exists()) {
            this.loadSessionConfiguration(configuration);
        } else {
            this.loadSessionConfiguration(SCSGuiConfiguration.defaultLoader(this.robotName));
        }
    }

    private void loadSessionConfiguration(SCSGuiConfiguration configuration) {
        if (configuration == null || !configuration.exists()) {
            return;
        }
        JavaFXMissingTools.runAndWait(this.getClass(), () -> this.toolkit.getWindowManager().closeAllSecondaryWindows());
        SynchronizeHint synchronizeHint = LOAD_SESSION_SYNCHRONOUS ? SynchronizeHint.SYNCHRONOUS : SynchronizeHint.NONE;
        LogTools.info((Object)synchronizeHint);
        long start = System.nanoTime();
        SCS2JavaFXMessager messager = this.toolkit.getMessager();
        SessionVisualizerTopics topics = this.toolkit.getTopics();
        if (configuration.hasYoEquationConfiguration()) {
            try (FileInputStream inputStream = new FileInputStream(configuration.getYoEquationConfigurationFile());){
                YoEquationListDefinition yoEquationListDefinition = DefinitionIOTools.loadYoEquationListDefinition((InputStream)inputStream);
                if (yoEquationListDefinition != null && yoEquationListDefinition.getYoEquations() != null) {
                    messager.submitMessage(topics.getSessionYoEquationListChangeRequest(), YoEquationManager.YoEquationListChange.add((List)yoEquationListDefinition.getYoEquations()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (LOAD_MAIN_WINDOW_CONFIGURATION) {
            JavaFXMissingTools.runAndWait(this.getClass(), () -> {
                if (this.isFirstSession && configuration.hasMainWindowConfiguration()) {
                    configuration.getMainWindowConfiguration(this.toolkit.getMainWindow());
                }
                JavaFXMissingTools.runNFramesLater(2, () -> this.toolkit.getMainWindow().toFront());
            });
        }
        if (configuration.hasYoGraphicsConfiguration()) {
            messager.submitMessage(topics.getYoGraphicLoadRequest(), configuration.getYoGraphicsConfigurationFile(), synchronizeHint);
        }
        if (configuration.hasYoCompositeConfiguration()) {
            messager.submitMessage(topics.getYoCompositePatternLoadRequest(), configuration.getYoCompositeConfigurationFile(), synchronizeHint);
        }
        if (configuration.hasYoEntryConfiguration()) {
            YoEntryTabPaneController yoEntryTabPaneController = this.mainWindowController.getSidePaneController().getYoEntryTabPaneController();
            if (LOAD_SESSION_SYNCHRONOUS) {
                JavaFXMissingTools.runAndWait(this.getClass(), () -> yoEntryTabPaneController.load(configuration.getYoEntryConfigurationFile()));
            } else {
                JavaFXMissingTools.runLaterWhen(this.getClass(), () -> this.toolkit.getYoCompositeSearchManager().isSessionLoaded(), () -> yoEntryTabPaneController.load(configuration.getYoEntryConfigurationFile()));
            }
        }
        if (configuration.hasMainYoChartGroupConfiguration()) {
            LogTools.info((String)"Submitting message to load main charts {}", (Object)configuration.getMainYoChartGroupConfigurationFile());
            Pair messageContent = new Pair((Object)this.toolkit.getMainWindow(), (Object)configuration.getMainYoChartGroupConfigurationFile());
            messager.submitMessage(topics.getYoChartGroupLoadConfiguration(), messageContent, synchronizeHint);
        }
        this.toolkit.getWindowManager().loadSessionConfiguration(configuration);
        if (LOAD_BUFFER_SIZE_CONFIGURATION && configuration.hasBufferSize()) {
            messager.submitMessage(topics.getYoBufferInitializeSize(), configuration.getBufferSize());
        }
        if (configuration.hasRecordTickPeriod()) {
            messager.submitMessage(topics.getInitializeBufferRecordTickPeriod(), configuration.getRecordTickPeriod());
        }
        if (configuration.hasNumberPrecision()) {
            messager.submitMessage(topics.getControlsNumberPrecision(), configuration.getNumberPrecision());
        }
        this.mainWindowController.leftSidePaneOpenProperty().set(configuration.getShowYoSearchPanel());
        messager.submitMessage(topics.getShowOverheadPlotter(), configuration.getShowOverheadPlotter());
        messager.submitMessage(topics.getShowAdvancedControls(), configuration.getShowAdvancedControls());
        messager.submitMessage(topics.getYoVariableNameDisplay(), (Object)(configuration.getShowYoVariableUniqueNames() ? YoNameDisplay.UNIQUE_NAME : YoNameDisplay.SHORT_NAME));
        if (configuration.hasYoSliderboardConfiguration()) {
            messager.submitMessage(topics.getYoMultiSliderboardLoad(), configuration.getYoSliderboardConfigurationFile(), synchronizeHint);
        }
        if (LOAD_SESSION_TIME) {
            long end = System.nanoTime();
            LogTools.info((String)"Loaded session configuration in: {}[sec]", (Object)((double)(end - start) * 1.0E-9));
        }
    }

    public void loadSessionConfiguration(File configurationFile) {
        if (!configurationFile.exists() || !configurationFile.isFile()) {
            return;
        }
        try {
            File unzippedConfiguration = SessionIOTools.getTemporaryDirectory((String)"configuration");
            SessionIOTools.unzipFile((File)configurationFile, (File)unzippedConfiguration);
            this.loadSessionConfiguration(SCSGuiConfiguration.loaderFromDirectory(this.robotName, this.sessionName, unzippedConfiguration));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveSessionDefaultConfiguration(Session session) {
        SCSGuiConfiguration configuration = SCSGuiConfiguration.defaultSaver(this.robotName, this.sessionName);
        this.saveSessionConfiguration(configuration, session);
        configuration = SCSGuiConfiguration.defaultSaver(this.robotName);
        this.saveSessionConfiguration(configuration, session);
    }

    private void saveSessionConfiguration(SCSGuiConfiguration configuration, Session session) {
        Integer numberPrecision;
        this.toolkit.getYoGraphicFXManager().saveYoGraphicToFile(configuration.getYoGraphicsConfigurationFile());
        this.toolkit.getYoCompositeSearchManager().saveYoCompositePatternToFile(configuration.getYoCompositeConfigurationFile());
        this.mainWindowController.getSidePaneController().getYoEntryTabPaneController().exportAllTabs(configuration.getYoEntryConfigurationFile());
        this.mainWindowController.getYoChartGroupPanelController().saveChartGroupConfiguration((Window)this.toolkit.getMainWindow(), configuration.getMainYoChartGroupConfigurationFile());
        this.toolkit.getWindowManager().saveSessionConfiguration(configuration);
        configuration.setMainStage(this.toolkit.getMainWindow());
        SessionVisualizerTopics topics = this.toolkit.getTopics();
        SCS2JavaFXMessager messager = this.toolkit.getMessager();
        int currentBufferSize = this.toolkit.getYoManager().getBufferSize();
        configuration.setBufferSize(currentBufferSize);
        Integer bufferRecordTickPeriod = messager.getLastValue(topics.getBufferRecordTickPeriod());
        if (bufferRecordTickPeriod != null) {
            configuration.setRecordTickPeriod(bufferRecordTickPeriod);
        }
        if ((numberPrecision = messager.getLastValue(topics.getControlsNumberPrecision())) != null) {
            configuration.setNumberPrecision(numberPrecision);
        }
        configuration.setShowYoSearchPanel(this.mainWindowController.leftSidePaneOpenProperty().get());
        configuration.setShowOverheadPlotter((Boolean)this.mainWindowController.showOverheadPlotterProperty().getValue());
        configuration.setShowAdvancedControls(this.mainWindowController.showAdvancedControlsProperty().get());
        configuration.setShowYoVariableUniqueNames(this.mainWindowController.yoNameDisplayProperty().getValue() == YoNameDisplay.UNIQUE_NAME);
        try (FileOutputStream outputStream = new FileOutputStream(configuration.getYoEquationConfigurationFile());){
            DefinitionIOTools.saveYoEquationListDefinition((OutputStream)outputStream, (List)session.getYoEquationDefinitions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        configuration.writeConfiguration();
    }

    public void saveSessionConfiguration(File destinationFile, Session session) {
        try {
            File intermediate = SessionIOTools.getTemporaryDirectory((String)"configuration");
            this.saveSessionConfiguration(SCSGuiConfiguration.saverToDirectory(this.robotName, this.sessionName, intermediate), session);
            SessionIOTools.zipFile((File)intermediate, (File)destinationFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        this.inactiveControllerMap.values().forEach(controller -> controller.shutdown());
    }
}

