/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import us.ihmc.scs2.session.SessionPropertiesHelper;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoDataReader;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;

public class VideoViewer {
    private static final boolean LOGGER_VIDEO_DEBUG = SessionPropertiesHelper.loadBooleanPropertyOrEnvironment((String)"scs2.session.gui.logger.video.debug", (String)"SCS2_GUI_LOGGER_VIDEO_DEBUG", (boolean)false);
    private static final double THUMBNAIL_HIGHLIGHT_SCALE = 1.05;
    private final ImageView thumbnail = new ImageView();
    private final StackPane thumbnailContainer = new StackPane(new Node[]{this.thumbnail});
    private final ImageView videoView = new ImageView();
    private final Label queryRobotTimestampLabel = new Label();
    private final Label demuxerCurrentPTSLabel = new Label();
    private final Label cameraCurrentPTSLabel = new Label();
    private final Label robotTimestampLabel = new Label();
    private final BooleanProperty updateVideoView = new SimpleBooleanProperty((Object)this, "updateVideoView", false);
    private final ObjectProperty<Stage> videoWindowProperty = new SimpleObjectProperty((Object)this, "videoWindow", null);
    private final VideoDataReader reader;
    private final double defaultThumbnailSize;
    private final ObjectProperty<Pane> imageViewRootPane = new SimpleObjectProperty((Object)this, "imageViewRootPane", null);

    public VideoViewer(Window owner, VideoDataReader reader, double defaultThumbnailSize) {
        this.reader = reader;
        this.defaultThumbnailSize = defaultThumbnailSize;
        this.thumbnail.setPreserveRatio(true);
        this.videoView.setPreserveRatio(true);
        this.thumbnail.setFitWidth(defaultThumbnailSize);
        this.thumbnail.setOnMouseEntered(e -> {
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.1), new KeyValue[]{new KeyValue((WritableValue)this.thumbnail.fitWidthProperty(), (Object)(1.05 * defaultThumbnailSize), Interpolator.EASE_BOTH)})});
            timeline.playFromStart();
        });
        this.thumbnail.setOnMouseExited(e -> {
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.1), new KeyValue[]{new KeyValue((WritableValue)this.thumbnail.fitWidthProperty(), (Object)defaultThumbnailSize, Interpolator.EASE_BOTH)})});
            timeline.playFromStart();
        });
        this.thumbnail.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            Stage stage;
            if (e.getClickCount() != 2) {
                return;
            }
            this.videoView.setImage(this.thumbnail.getImage());
            if (this.videoWindowProperty.get() != null) {
                stage = (Stage)this.videoWindowProperty.get();
            } else {
                stage = new Stage();
                AnchorPane anchorPane = new AnchorPane();
                Pane root = VideoViewer.createImageViewPane(this.videoView);
                anchorPane.getChildren().add((Object)root);
                JavaFXMissingTools.setAnchorConstraints((Node)root, 0.0);
                this.imageViewRootPane.set((Object)root);
                this.setupVideoStatistics(anchorPane);
                this.videoWindowProperty.set((Object)stage);
                stage.getIcons().add((Object)SessionVisualizerIOTools.LOG_SESSION_IMAGE);
                stage.setTitle(reader.getName());
                owner.setOnHiding(e2 -> stage.close());
                Scene scene = new Scene((Parent)anchorPane);
                stage.setScene(scene);
                this.updateVideoView.bind((ObservableValue)stage.showingProperty());
            }
            Screen screen = (Screen)Screen.getScreensForRectangle((double)e.getScreenX(), (double)e.getScreenY(), (double)1.0, (double)1.0).get(0);
            Rectangle2D visualBounds = screen.getVisualBounds();
            double width = 0.5 * visualBounds.getWidth();
            double height = 0.5 * visualBounds.getHeight();
            double x = visualBounds.getMinX() + 0.5 * (visualBounds.getWidth() - width);
            double y = visualBounds.getMinY() + 0.5 * (visualBounds.getHeight() - height);
            stage.setX(x);
            stage.setY(y);
            stage.setWidth(width);
            stage.setHeight(height);
            stage.toFront();
            stage.show();
        });
    }

    private void setupVideoStatistics(AnchorPane anchorPane) {
        Label videoStatisticTitle = new Label("Video Statistics");
        videoStatisticTitle.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)14.0));
        Background generalBackground = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)});
        Border noRightBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, null, (Paint)Color.BLACK, (Paint)Color.BLACK, BorderStrokeStyle.SOLID, BorderStrokeStyle.NONE, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT, Insets.EMPTY)});
        Border noLeftBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, (Paint)Color.BLACK, (Paint)Color.BLACK, null, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.NONE, CornerRadii.EMPTY, BorderWidths.DEFAULT, Insets.EMPTY)});
        Border generalBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)});
        Insets textInsets = new Insets(0.0, 2.0, 0.0, 2.0);
        if (LOGGER_VIDEO_DEBUG) {
            VBox videoStatisticBox = new VBox(new Node[]{videoStatisticTitle});
            videoStatisticBox.setAlignment(Pos.CENTER);
            videoStatisticBox.setBackground(generalBackground);
            videoStatisticBox.setBorder(generalBorder);
            VBox videoStatisticLabels = new VBox(new Node[]{new Label("queryRobotTimestamp"), new Label("robotTimestamp"), new Label("cameraCurrentPTS"), new Label("demuxerCurrentPTS")});
            videoStatisticLabels.setBackground(generalBackground);
            videoStatisticLabels.setBorder(noRightBorder);
            videoStatisticLabels.setPadding(textInsets);
            VBox videoStatistics = new VBox(new Node[]{this.queryRobotTimestampLabel, this.robotTimestampLabel, this.cameraCurrentPTSLabel, this.demuxerCurrentPTSLabel});
            videoStatistics.setBackground(generalBackground);
            videoStatistics.setBorder(noLeftBorder);
            videoStatistics.setPadding(textInsets);
            HBox labelsContainer = new HBox(0.0, new Node[]{videoStatisticLabels, videoStatistics});
            VBox videoStatisticsDisplay = new VBox(0.0, new Node[]{videoStatisticBox, labelsContainer});
            anchorPane.getChildren().add((Object)videoStatisticsDisplay);
            AnchorPane.setLeftAnchor((Node)videoStatisticsDisplay, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)videoStatisticsDisplay, (Double)0.0);
        }
    }

    private static Pane createImageViewPane(final ImageView imageView) {
        return new Pane(new Node[]{imageView}){

            protected void layoutChildren() {
                Image image = imageView.getImage();
                if (image == null) {
                    return;
                }
                double imageRatio = image.getWidth() / image.getHeight();
                double paneWidth = this.getWidth() - this.getPadding().getTop() - this.getPadding().getBottom();
                double paneHeight = this.getHeight() - this.getPadding().getLeft() - this.getPadding().getRight();
                double width = Math.min(paneWidth, paneHeight * imageRatio);
                double height = width / imageRatio;
                double x = 0.5 * (paneWidth - width);
                double y = 0.5 * (paneHeight - height);
                imageView.setFitWidth(width);
                imageView.setX(x + this.getPadding().getLeft());
                imageView.setY(y + this.getPadding().getTop());
            }
        };
    }

    public void update() {
        VideoDataReader.FrameData currentFrameData = this.reader.pollCurrentFrame();
        if (currentFrameData == null) {
            return;
        }
        WritableImage currentFrame = currentFrameData.frame;
        this.thumbnailContainer.setPrefWidth(1.05 * this.defaultThumbnailSize);
        this.thumbnailContainer.setPrefHeight(1.05 * this.defaultThumbnailSize * currentFrame.getHeight() / currentFrame.getWidth());
        this.thumbnail.setImage((Image)currentFrame);
        if (this.updateVideoView.get()) {
            this.videoView.setImage((Image)currentFrame);
            this.queryRobotTimestampLabel.setText(Long.toString(currentFrameData.queryRobotTimestamp));
            this.robotTimestampLabel.setText(Long.toString(currentFrameData.robotTimestamp));
            this.cameraCurrentPTSLabel.setText(Long.toString(currentFrameData.cameraCurrentPTS));
            this.demuxerCurrentPTSLabel.setText(Long.toString(currentFrameData.demuxerCurrentPTS));
            if (this.imageViewRootPane.get() != null) {
                ((Pane)this.imageViewRootPane.get()).setPadding(new Insets(16.0, 16.0, 16.0, 16.0));
                if (this.reader.replacedRobotTimestampsContainsIndex(this.reader.getCurrentIndex())) {
                    ((Pane)this.imageViewRootPane.get()).setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.DARKORANGE, CornerRadii.EMPTY, Insets.EMPTY)}));
                } else {
                    ((Pane)this.imageViewRootPane.get()).setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
                }
            }
        }
    }

    public void stop() {
        if (this.videoWindowProperty.get() != null) {
            ((Stage)this.videoWindowProperty.get()).close();
            this.videoWindowProperty.set(null);
        }
    }

    public Node getThumbnail() {
        return this.thumbnailContainer;
    }
}

