/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TitledPane;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartDoubleBounds;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartOptionController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoNumberSeries;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;

public class YoChartVariableOptionController
implements VisualizerController {
    @FXML
    private TitledPane mainPane;
    @FXML
    private ComboBox<ChartVariableScalingMode> scalingComboBox;
    @FXML
    private CheckBox negateCheckBox;
    @FXML
    private TextField manualRangeMinTextField;
    @FXML
    private TextField manualRangeMaxTextField;
    @FXML
    private Label actualRangeMinLabel;
    @FXML
    private Label actualRangeMaxLabel;
    private final ObjectProperty<ChartDoubleBounds> actualYBoundsProperty = new SimpleObjectProperty((Object)this, "actualYBounds", null);
    private final ObjectProperty<ChartDoubleBounds> manualYBoundsProperty = new SimpleObjectProperty((Object)this, "manualYBounds", null);
    private final TextFormatter<Double> minFormatter = new TextFormatter((StringConverter)new DoubleStringConverter(), (Object)0.0);
    private final TextFormatter<Double> maxFormatter = new TextFormatter((StringConverter)new DoubleStringConverter(), (Object)0.0);
    private YoNumberSeries series;
    private Property<YoChartOptionController.ChartScalingMode> masterScalingModeProperty;
    private final ChangeListener<Boolean> negateUpdater = (o, oldValue, newValue) -> this.series.setNegated((boolean)newValue);
    private final ChangeListener<YoChartOptionController.ChartScalingMode> globalScalingListener = (o, oldValue, newValue) -> this.setGlobalScaling((YoChartOptionController.ChartScalingMode)((Object)newValue));
    private final ChangeListener<ChartDoubleBounds> customBoundsUpdater = (o, oldValue, newValue) -> this.series.setCustomYBounds((ChartDoubleBounds)newValue);
    private final ChangeListener<ChartVariableScalingMode> localScalingListener = (o, oldValue, newValue) -> this.setLocalScaling((ChartVariableScalingMode)((Object)newValue));
    private final ChangeListener<ChartDoubleBounds> actualYBoundsUpdater = (o, oldValue, newValue) -> this.actualYBoundsProperty.set(newValue);

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.scalingComboBox.setItems(FXCollections.observableArrayList((Object[])ChartVariableScalingMode.values()));
        this.scalingComboBox.setValue((Object)ChartVariableScalingMode.AUTO);
        this.manualRangeMinTextField.setTextFormatter(this.minFormatter);
        this.manualRangeMaxTextField.setTextFormatter(this.maxFormatter);
        this.actualRangeMinLabel.setText("N/A");
        this.actualRangeMaxLabel.setText("N/A");
        this.minFormatter.valueProperty().addListener((o, oldValue, newValue) -> {
            if (this.manualRangeMinTextField.isDisabled()) {
                return;
            }
            if (newValue > ((ChartDoubleBounds)this.manualYBoundsProperty.get()).getUpper()) {
                this.minFormatter.setValue(oldValue);
                return;
            }
            this.manualYBoundsProperty.set((Object)new ChartDoubleBounds((double)newValue, ((ChartDoubleBounds)this.manualYBoundsProperty.get()).getUpper()));
        });
        this.maxFormatter.valueProperty().addListener((o, oldValue, newValue) -> {
            if (this.manualRangeMinTextField.isDisabled()) {
                return;
            }
            if (newValue < ((ChartDoubleBounds)this.manualYBoundsProperty.get()).getLower()) {
                this.maxFormatter.setValue(oldValue);
                return;
            }
            this.manualYBoundsProperty.set((Object)new ChartDoubleBounds(((ChartDoubleBounds)this.manualYBoundsProperty.get()).getLower(), (double)newValue));
        });
    }

    public void setInput(YoNumberSeries series, Property<YoChartOptionController.ChartScalingMode> masterScalingModeProperty) {
        this.series = series;
        this.masterScalingModeProperty = masterScalingModeProperty;
        this.mainPane.setText(series.getYoVariable().getName());
        this.manualYBoundsProperty.set((Object)series.getCustomYBounds());
        if (masterScalingModeProperty.getValue() == YoChartOptionController.ChartScalingMode.INDIVIDUAL && this.manualYBoundsProperty.get() != null) {
            this.scalingComboBox.setValue((Object)ChartVariableScalingMode.MANUAL);
        } else {
            this.scalingComboBox.setValue((Object)ChartVariableScalingMode.AUTO);
        }
        this.negateCheckBox.setSelected(series.isNegated());
        this.negateCheckBox.selectedProperty().addListener(this.negateUpdater);
        this.setGlobalScaling((YoChartOptionController.ChartScalingMode)((Object)masterScalingModeProperty.getValue()));
        masterScalingModeProperty.addListener(this.globalScalingListener);
        this.setLocalScaling((ChartVariableScalingMode)((Object)this.scalingComboBox.getValue()));
        this.scalingComboBox.valueProperty().addListener(this.localScalingListener);
        series.yBoundsProperty().addListener(this.actualYBoundsUpdater);
        this.actualYBoundsProperty.addListener((o, oldValue, newValue) -> {
            if (newValue == null) {
                this.actualRangeMinLabel.setText("N/A");
                this.actualRangeMaxLabel.setText("N/A");
            } else {
                if (this.manualYBoundsProperty.get() == null) {
                    this.minFormatter.setValue((Object)newValue.getLower());
                    this.maxFormatter.setValue((Object)newValue.getUpper());
                }
                this.actualRangeMinLabel.setText(Double.toString(newValue.getLower()));
                this.actualRangeMaxLabel.setText(Double.toString(newValue.getUpper()));
            }
        });
        if (series.yBoundsProperty().getValue() != null) {
            this.actualYBoundsProperty.set((Object)new ChartDoubleBounds((ChartDoubleBounds)series.yBoundsProperty().getValue()));
        } else {
            this.actualYBoundsProperty.set(null);
        }
    }

    private void setGlobalScaling(YoChartOptionController.ChartScalingMode mode) {
        this.scalingComboBox.setDisable(mode != YoChartOptionController.ChartScalingMode.INDIVIDUAL);
        if (mode != YoChartOptionController.ChartScalingMode.INDIVIDUAL) {
            this.manualRangeMinTextField.setDisable(true);
            this.manualRangeMaxTextField.setDisable(true);
        }
    }

    private void setLocalScaling(ChartVariableScalingMode mode) {
        this.manualRangeMinTextField.setDisable(mode == ChartVariableScalingMode.AUTO);
        this.manualRangeMaxTextField.setDisable(mode == ChartVariableScalingMode.AUTO);
        if (mode == ChartVariableScalingMode.MANUAL) {
            if (this.manualYBoundsProperty.get() == null) {
                this.manualYBoundsProperty.set((Object)new ChartDoubleBounds((ChartDoubleBounds)this.actualYBoundsProperty.get()));
            }
            this.minFormatter.setValue((Object)((ChartDoubleBounds)this.manualYBoundsProperty.get()).getLower());
            this.maxFormatter.setValue((Object)((ChartDoubleBounds)this.manualYBoundsProperty.get()).getUpper());
            this.manualYBoundsProperty.addListener(this.customBoundsUpdater);
            this.series.setCustomYBounds((ChartDoubleBounds)this.manualYBoundsProperty.get());
        } else {
            this.manualYBoundsProperty.removeListener(this.customBoundsUpdater);
            this.series.setCustomYBounds(null);
        }
    }

    public void detachListeners() {
        this.masterScalingModeProperty.removeListener(this.globalScalingListener);
        this.scalingComboBox.valueProperty().removeListener(this.localScalingListener);
        this.manualYBoundsProperty.removeListener(this.customBoundsUpdater);
        this.series.yBoundsProperty().removeListener(this.actualYBoundsUpdater);
    }

    public YoNumberSeries getSeries() {
        return this.series;
    }

    public TitledPane getMainPane() {
        return this.mainPane;
    }

    public static enum ChartVariableScalingMode {
        AUTO,
        MANUAL;

    }
}

