/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D;

import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPointcloud3DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoCompositeListEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D.YoGraphicFX3DEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXResourceManager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoPointcloudFX3D;

public class YoPointcloudFX3DEditorController
extends YoGraphicFX3DEditorController<YoPointcloudFX3D> {
    @FXML
    private YoCompositeListEditorPaneController pointListEditorController;
    @FXML
    private TextField sizeTextField;
    @FXML
    private ImageView sizeValidImageView;
    @FXML
    private ComboBox<String> graphicComboBox;
    private YoGraphicPointcloud3DDefinition definitionBeforeEdits;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, YoPointcloudFX3D yoGraphicToEdit) {
        super.initialize(toolkit, yoGraphicToEdit);
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicPointcloud3DDefinition(yoGraphicToEdit);
        yoGraphicToEdit.visibleProperty().addListener((observable, oldValue, newValue) -> this.definitionBeforeEdits.setVisible(newValue.booleanValue()));
        this.setupTuple3DPropertyListEditor(this.pointListEditorController, "Point", true, yoGraphicToEdit::setNumberOfPoints, yoGraphicToEdit::setPoints);
        this.setupDoublePropertyEditor(this.sizeTextField, this.sizeValidImageView, YoPointcloudFX3D::setSize);
        YoGraphicFXResourceManager yoGraphicFXResourceManager = toolkit.getYoGraphicFXManager().getYoGraphicFXResourceManager();
        this.graphicComboBox.setItems(FXCollections.observableArrayList(yoGraphicFXResourceManager.getGraphic3DNameList()));
        this.graphicComboBox.valueProperty().addListener((o, oldValue, newValue) -> yoGraphicToEdit.setGraphicResource(yoGraphicFXResourceManager.loadGraphic3DResource((String)newValue)));
        this.graphicComboBox.valueProperty().addListener(this::updateHasChangesPendingProperty);
        this.setupHeightAdjustment();
        this.resetFields();
    }

    private void setupHeightAdjustment() {
        this.mainPane.parentProperty().addListener((o, oldValue, newValue) -> {
            Region parent;
            for (parent = (Region)newValue; parent != null && !(parent instanceof ScrollPane); parent = (Region)parent.getParent()) {
            }
            if (parent == null) {
                return;
            }
            this.pointListEditorController.setupHeightAdjustmentForScrollPane((ScrollPane)parent);
        });
    }

    @Override
    protected <T> void updateHasChangesPendingProperty(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        this.hasChangesPendingProperty.set(!this.definitionBeforeEdits.equals((Object)YoGraphicTools.toYoGraphicPointcloud3DDefinition((YoPointcloudFX3D)this.yoGraphicToEdit)));
    }

    @Override
    public void resetFields() {
        this.pointListEditorController.setInputFromDefinition(this.definitionBeforeEdits.getPoints(), this.definitionBeforeEdits.getNumberOfPoints());
        if (this.definitionBeforeEdits.getGraphicName() == null) {
            this.definitionBeforeEdits.setGraphicName(YoGraphicFXResourceManager.DEFAULT_POINT3D_GRAPHIC_RESOURCE.getResourceName());
        }
        this.graphicComboBox.setValue((Object)this.definitionBeforeEdits.getGraphicName());
        this.sizeTextField.setText(this.definitionBeforeEdits.getSize());
        this.styleEditorController.setInput((YoGraphic3DDefinition)this.definitionBeforeEdits);
        this.nameEditorController.setInput(this.definitionBeforeEdits.getName(), ((YoPointcloudFX3D)this.yoGraphicToEdit).getNamespace());
    }

    @Override
    public void saveChanges() {
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicPointcloud3DDefinition((YoPointcloudFX3D)this.yoGraphicToEdit);
        this.hasChangesPendingProperty.set(false);
    }
}

