/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.pattern;

import com.jfoenix.controls.JFXButton;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.definition.yoComposite.YoCompositePatternDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.pattern.YoCompositePatternEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ListViewTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.MenuTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositePattern;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeTools;

public class YoCompositePatternPropertyWindowController {
    private static final String NEW_PATTERN_NAME = "New Pattern";
    @FXML
    private AnchorPane mainAnchorPane;
    @FXML
    private JFXButton addPatternButton;
    @FXML
    private JFXButton removePatternButton;
    @FXML
    private ListView<ObjectProperty<YoCompositePatternDefinition>> yoCompositePatternListView;
    @FXML
    private JFXButton exportButton;
    @FXML
    private JFXButton importButton;
    @FXML
    private AnchorPane yoCompositePatternEditorPane;
    @FXML
    private JFXButton saveChangesButton;
    @FXML
    private JFXButton revertChangesButton;
    private final ObjectProperty<YoCompositePatternEditorController> activeEditor = new SimpleObjectProperty((Object)this, "activeEditor", null);
    private final Map<ObjectProperty<YoCompositePatternDefinition>, YoCompositePatternEditorController> cachedEditors = new HashMap<ObjectProperty<YoCompositePatternDefinition>, YoCompositePatternEditorController>();
    private YoCompositeSearchManager yoCompositeSearchManager;
    private Stage window;
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;
    private SessionVisualizerToolkit toolkit;
    private boolean ignoreTreeSelectionUpdate = false;

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.toolkit = toolkit;
        this.topics = toolkit.getTopics();
        this.messager = toolkit.getMessager();
        this.yoCompositeSearchManager = toolkit.getYoCompositeSearchManager();
        this.yoCompositePatternListView.setCellFactory(param -> new ListCell<ObjectProperty<YoCompositePatternDefinition>>(){
            private final ObjectProperty<YoCompositePatternDefinition> cellValueProperty = new SimpleObjectProperty((Object)this, "cellValue", null);
            {
                this.cellValueProperty.addListener((o, oldValue, newValue) -> {
                    if (newValue == null) {
                        this.setText(null);
                    } else {
                        this.setText(newValue.getName());
                    }
                });
            }

            protected void updateItem(ObjectProperty<YoCompositePatternDefinition> item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || item == null) {
                    this.cellValueProperty.unbind();
                    this.cellValueProperty.set(null);
                } else {
                    this.cellValueProperty.bind(item);
                }
            }
        });
        this.yoCompositePatternListView.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> this.processListSelectionUpdate((ObjectProperty<YoCompositePatternDefinition>)oldValue, (ObjectProperty<YoCompositePatternDefinition>)newValue));
        this.window = new Stage(StageStyle.UTILITY);
        this.window.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                this.window.close();
            }
        });
        toolkit.getMainWindow().addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            if (!e.isConsumed()) {
                this.window.close();
            }
        });
        this.window.setTitle("YoCompositePattern properties");
        this.window.setScene(new Scene((Parent)this.mainAnchorPane));
        this.window.initOwner((Window)toolkit.getMainWindow());
        List<YoCompositePatternDefinition> customYoCompositePatterns = YoCompositeTools.toYoCompositePatternDefinitions(this.yoCompositeSearchManager.customYoCompositePatterns());
        this.yoCompositePatternListView.getItems().clear();
        for (YoCompositePatternDefinition yoCompositePattern : customYoCompositePatterns) {
            this.yoCompositePatternListView.getItems().add((Object)new SimpleObjectProperty((Object)yoCompositePattern));
        }
        this.yoCompositeSearchManager.customYoCompositePatterns().addListener(change -> {
            if (change.wasAdded()) {
                this.updateOrAddPattern((YoCompositePattern)change.getElementAdded());
            }
            if (change.wasRemoved()) {
                this.removePattern((YoCompositePattern)change.getElementRemoved());
            }
        });
        MenuTools.setupContextMenu(this.yoCompositePatternListView, new Function[]{ListViewTools.addBeforeMenuItemFactory(this::newEmptyPattern), ListViewTools.addAfterMenuItemFactory(this::newEmptyPattern), ListViewTools.removeMenuItemFactory(false)});
        this.saveChangesButton.setDisable(true);
        this.revertChangesButton.setDisable(true);
        this.activeEditor.addListener((observable, oldValue, newValue) -> {
            this.saveChangesButton.disableProperty().unbind();
            this.revertChangesButton.disableProperty().unbind();
            if (newValue == null) {
                this.saveChangesButton.setDisable(true);
                this.revertChangesButton.setDisable(true);
            } else {
                this.saveChangesButton.disableProperty().bind((ObservableValue)newValue.hasChangesPendingProperty().and((ObservableBooleanValue)newValue.inputsValidityProperty()).not());
                this.revertChangesButton.disableProperty().bind((ObservableValue)newValue.hasChangesPendingProperty().not());
            }
        });
        this.yoCompositePatternEditorPane.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.CONTROL) {
                return;
            }
            if (e.isControlDown()) {
                if (e.getCode() == KeyCode.S && !this.saveChangesButton.isDisabled()) {
                    this.saveChangesButton.fire();
                } else if (e.getCode() == KeyCode.Z && !this.revertChangesButton.isDisabled()) {
                    this.revertChangesButton.fire();
                }
            }
        });
    }

    public void showWindow() {
        this.window.setOpacity(0.0);
        this.window.toFront();
        this.window.show();
        Timeline timeline = new Timeline();
        KeyFrame key = new KeyFrame(Duration.seconds((double)0.125), new KeyValue[]{new KeyValue((WritableValue)this.window.opacityProperty(), (Object)1.0)});
        timeline.getKeyFrames().add((Object)key);
        timeline.play();
    }

    public void closeAndDispose() {
        this.window.close();
        if (this.activeEditor.get() != null) {
            ((YoCompositePatternEditorController)this.activeEditor.get()).closeAndDispose();
        }
        this.cachedEditors.values().forEach(YoCompositePatternEditorController::closeAndDispose);
    }

    private void processListSelectionUpdate(ObjectProperty<YoCompositePatternDefinition> oldSelectedValue, ObjectProperty<YoCompositePatternDefinition> newSelectedValue) {
        if (this.ignoreTreeSelectionUpdate) {
            return;
        }
        if (this.shouldCancelAction(oldSelectedValue)) {
            return;
        }
        this.unloadEditor();
        if (newSelectedValue == null) {
            return;
        }
        YoCompositePatternEditorController controller = this.cachedEditors.get(newSelectedValue);
        if (controller == null) {
            try {
                FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.YO_COMPOSITE_PATTERN_EDITOR_PANE_URL);
                loader.load();
                controller = (YoCompositePatternEditorController)loader.getController();
                controller.initialize(this.toolkit);
                controller.setInput((YoCompositePatternDefinition)newSelectedValue.get());
                this.cachedEditors.put(newSelectedValue, controller);
                YoCompositePatternEditorController controllerFinal = controller;
                JavaFXMissingTools.runNFramesLater(1, () -> controllerFinal.startEditingCompositePatternName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (controller != null) {
            VBox editorPane = controller.getMainPane();
            controller.setNameOfOtherPatterns(this.yoCompositePatternListView.getItems().stream().filter(item -> item != newSelectedValue).map(item -> ((YoCompositePatternDefinition)item.get()).getName()).collect(Collectors.toList()));
            this.activeEditor.set((Object)controller);
            this.yoCompositePatternEditorPane.getChildren().add((Object)editorPane);
            AnchorPane.setLeftAnchor((Node)editorPane, (Double)0.0);
            AnchorPane.setRightAnchor((Node)editorPane, (Double)0.0);
            AnchorPane.setTopAnchor((Node)editorPane, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)editorPane, (Double)0.0);
            newSelectedValue.bind(controller.patternDefinitionProperty());
        }
    }

    private boolean shouldCancelAction(ObjectProperty<YoCompositePatternDefinition> itemToSelectOnCancel) {
        if (this.activeEditor.get() != null && ((YoCompositePatternEditorController)this.activeEditor.get()).hasChangesPending()) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to discard the changes?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
            SessionVisualizerIOTools.addSCSIconToDialog(alert);
            Optional result = alert.showAndWait();
            ButtonType answer = (ButtonType)result.get();
            if (answer == ButtonType.YES) {
                this.cancelChanges();
                return false;
            }
            if (answer == ButtonType.NO) {
                if (itemToSelectOnCancel != null) {
                    JavaFXMissingTools.runLater(this.getClass(), () -> {
                        this.ignoreTreeSelectionUpdate = true;
                        this.yoCompositePatternListView.getSelectionModel().clearSelection();
                        this.yoCompositePatternListView.getSelectionModel().select((Object)itemToSelectOnCancel);
                        this.ignoreTreeSelectionUpdate = false;
                    });
                }
                return true;
            }
        }
        return false;
    }

    private void unloadEditor() {
        this.yoCompositePatternEditorPane.getChildren().clear();
        this.activeEditor.set(null);
    }

    private ObjectProperty<YoCompositePatternDefinition> newEmptyPattern() {
        if (this.shouldCancelAction(null)) {
            return null;
        }
        return new SimpleObjectProperty((Object)new YoCompositePatternDefinition(NEW_PATTERN_NAME));
    }

    @FXML
    public void addPattern() {
        this.addPattern(new YoCompositePatternDefinition(NEW_PATTERN_NAME));
    }

    public void addPattern(YoCompositePatternDefinition pattern) {
        this.updateOrAddPattern(pattern, false);
    }

    public void updateOrAddPattern(YoCompositePattern pattern) {
        this.updateOrAddPattern(YoCompositeTools.toYoCompositePatternDefinition(pattern));
    }

    public void updateOrAddPattern(YoCompositePatternDefinition pattern) {
        this.updateOrAddPattern(pattern, true);
    }

    private void updateOrAddPattern(YoCompositePatternDefinition pattern, boolean allowUpdate) {
        SimpleObjectProperty patternProperty;
        if (this.shouldCancelAction(null)) {
            return;
        }
        if (allowUpdate) {
            Optional<ObjectProperty> matchingPattern = this.yoCompositePatternListView.getItems().stream().filter(item -> ((YoCompositePatternDefinition)item.get()).getName().equals(pattern.getName())).findFirst();
            if (matchingPattern.isPresent()) {
                patternProperty = matchingPattern.get();
                if (patternProperty.isBound()) {
                    this.cachedEditors.get(patternProperty).setInput(pattern);
                } else {
                    patternProperty.set((Object)pattern);
                }
            } else {
                patternProperty = new SimpleObjectProperty((Object)pattern);
                this.yoCompositePatternListView.getItems().add((Object)patternProperty);
            }
        } else {
            patternProperty = new SimpleObjectProperty((Object)pattern);
            this.yoCompositePatternListView.getItems().add((Object)patternProperty);
        }
        this.yoCompositePatternListView.getSelectionModel().select((Object)patternProperty);
    }

    @FXML
    public void removePattern() {
        if (this.shouldCancelAction(null)) {
            return;
        }
        ObjectProperty selectedItem = (ObjectProperty)this.yoCompositePatternListView.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        this.yoCompositePatternListView.getItems().remove((Object)selectedItem);
        if (selectedItem.get() != null) {
            this.yoCompositeSearchManager.discardYoComposite(((YoCompositePatternDefinition)selectedItem.get()).getName());
        }
    }

    public void removePattern(YoCompositePattern pattern) {
        this.removePattern(pattern.getType());
    }

    public void removePattern(YoCompositePatternDefinition pattern) {
        this.removePattern(pattern.getName());
    }

    public void removePattern(String patternName) {
        if (this.shouldCancelAction(null)) {
            return;
        }
        Optional<ObjectProperty> firstPattern = this.yoCompositePatternListView.getItems().stream().filter(p -> ((YoCompositePatternDefinition)p.get()).getName().equals(patternName)).findFirst();
        if (firstPattern.isPresent()) {
            this.yoCompositePatternListView.getItems().remove((Object)firstPattern.get());
            if (firstPattern.get().get() != null) {
                this.yoCompositeSearchManager.discardYoComposite(((YoCompositePatternDefinition)firstPattern.get().get()).getName());
            }
        }
    }

    @FXML
    public void exportYoCompositePatterns() {
        File result = SessionVisualizerIOTools.yoCompositeConfigurationSaveFileDialog((Window)this.window);
        if (result != null) {
            this.messager.submitMessage(this.topics.getYoCompositePatternSaveRequest(), (Object)result);
        }
    }

    @FXML
    public void importYoCompositePatterns() {
        if (this.shouldCancelAction(null)) {
            return;
        }
        File result = SessionVisualizerIOTools.yoCompositeConfigurationOpenFileDialog((Window)this.window);
        if (result != null) {
            this.messager.submitMessage(this.topics.getYoCompositePatternLoadRequest(), (Object)result);
        }
    }

    @FXML
    public void saveChanges() {
        YoCompositePatternEditorController editor = (YoCompositePatternEditorController)this.activeEditor.get();
        if (editor != null) {
            String originalDefinitionName = editor.getDefinitionBeforeEdits().getName();
            editor.saveChanges();
            this.yoCompositeSearchManager.discardYoComposite(originalDefinitionName);
            ObjectProperty<YoCompositePatternDefinition> patternDefinitionProperty = editor.patternDefinitionProperty();
            this.yoCompositeSearchManager.searchYoCompositeInBackground(YoCompositeTools.toYoCompositePattern((YoCompositePatternDefinition)patternDefinitionProperty.get()));
        }
    }

    @FXML
    public void cancelChanges() {
        if (this.activeEditor.get() != null) {
            ((YoCompositePatternEditorController)this.activeEditor.get()).resetFields();
        }
    }

    public Stage getWindow() {
        return this.window;
    }
}

