/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import us.ihmc.messager.Messager;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.YoVariableChartData;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sharedMemory.LinkedYoVariable;
import us.ihmc.yoVariables.variable.YoVariable;

public class ChartDataManager
implements Manager {
    private final Map<YoVariable, LinkedYoVariable<?>> linkedVariableMap = new HashMap();
    private final Map<YoVariable, YoVariableChartData> chartDataMap = new ConcurrentHashMap<YoVariable, YoVariableChartData>();
    private final SessionVisualizerTopics topics;
    private final JavaFXMessager messager;
    private final YoManager yoManager;
    private final BackgroundExecutorManager backgroundExecutorManager;
    private Future<?> activeTask;

    public ChartDataManager(JavaFXMessager messager, SessionVisualizerTopics topics, YoManager yoManager, BackgroundExecutorManager backgroundExecutorManager) {
        this.topics = topics;
        this.messager = messager;
        this.yoManager = yoManager;
        this.backgroundExecutorManager = backgroundExecutorManager;
    }

    @Override
    public void startSession(Session session) {
        this.activeTask = this.backgroundExecutorManager.scheduleTaskInBackground(this::updateData, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stopSession() {
        if (this.activeTask != null) {
            this.activeTask.cancel(true);
        }
        this.activeTask = null;
    }

    @Override
    public boolean isSessionLoaded() {
        return true;
    }

    private void updateData() {
        try {
            this.chartDataMap.values().removeIf(value -> {
                boolean remove;
                boolean bl = remove = !value.isCurrentlyInUse();
                if (remove) {
                    value.dispose();
                    this.linkedVariableMap.remove(value.getYoVariable());
                }
                return remove;
            });
            this.chartDataMap.values().forEach(YoVariableChartData::updateBufferData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public YoVariableChartData getYoVariableChartData(Object callerID, YoVariable yoVariable) {
        YoVariableChartData yoVariableChartData = this.chartDataMap.get(yoVariable);
        if (yoVariableChartData == null) {
            LinkedYoVariable<?> linkedYoVariable = this.linkedVariableMap.get(yoVariable);
            if (linkedYoVariable == null) {
                linkedYoVariable = this.yoManager.newLinkedYoVariable(yoVariable, this);
                this.linkedVariableMap.put(yoVariable, linkedYoVariable);
                yoVariableChartData = new YoVariableChartData((Messager)this.messager, this.topics, linkedYoVariable);
                linkedYoVariable.removeUser((Object)this);
            } else {
                yoVariableChartData = new YoVariableChartData((Messager)this.messager, this.topics, linkedYoVariable);
            }
            yoVariableChartData.registerCaller(callerID);
            this.chartDataMap.put(yoVariable, yoVariableChartData);
        } else {
            yoVariableChartData.registerCaller(callerID);
        }
        return yoVariableChartData;
    }
}

