/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;

public class UserSidePaneController
implements VisualizerController {
    @FXML
    private AnchorPane userMainSidePane;
    @FXML
    private Accordion accordion;
    @FXML
    private TitledPane userCustomControlsTitledPane;
    @FXML
    private FlowPane userCustomControlsPane;
    private DoubleProperty computedPrefWidth = new SimpleDoubleProperty((Object)this, "computedPrefWidth", -1.0);
    private SessionVisualizerWindowToolkit toolkit;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.toolkit = toolkit;
        this.accordion.setExpandedPane(this.userCustomControlsTitledPane);
        this.computePrefWidth();
    }

    private void computePrefWidth() {
        JavaFXMissingTools.runLater(this.getClass(), () -> this.computedPrefWidth.set(this.userMainSidePane.prefWidth(-1.0)));
    }

    public void addControl(Node control) {
        this.addControl(control, null);
    }

    public void addControl(Node control, VisualizerController controller) {
        JavaFXMissingTools.runAndWait(this.getClass(), () -> {
            if (controller != null) {
                controller.initialize(this.toolkit);
            }
            this.userCustomControlsPane.getChildren().add((Object)control);
            this.computePrefWidth();
        });
    }

    public boolean removeControl(Node control) {
        boolean result = JavaFXMissingTools.runAndWait(this.getClass(), () -> this.userCustomControlsPane.getChildren().remove((Object)control));
        if (result) {
            this.computePrefWidth();
        }
        return result;
    }

    public void loadCustomPane(String name, URL fxmlResource) {
        this.loadCustomPane(name, fxmlResource, null);
    }

    public void loadCustomPane(String name, URL fxmlResource, VisualizerController controller) {
        JavaFXMissingTools.runAndWait(this.getClass(), () -> {
            try {
                FXMLLoader fxmlLoader = new FXMLLoader(fxmlResource);
                Pane pane = (Pane)fxmlLoader.load();
                if (controller != null) {
                    this.addCustomPane(name, pane, controller);
                } else if (fxmlLoader.getController() instanceof VisualizerController) {
                    this.addCustomPane(name, pane, (VisualizerController)fxmlLoader.getController());
                } else {
                    this.addCustomPane(name, pane);
                }
            }
            catch (IOException e) {
                LogTools.error((String)"Couldn't load FXML resource, skipping. Following is the stack-trace:");
                e.printStackTrace();
            }
        });
    }

    public void addCustomPane(String name, Pane pane) {
        this.addCustomPane(name, pane, null);
    }

    public void addCustomPane(String name, Pane pane, VisualizerController controller) {
        JavaFXMissingTools.runAndWait(this.getClass(), () -> {
            if (controller != null) {
                controller.initialize(this.toolkit);
            }
            TitledPane titledPane = new TitledPane(name, (Node)pane);
            this.accordion.getPanes().add((Object)titledPane);
            this.accordion.setExpandedPane(titledPane);
            this.computePrefWidth();
        });
    }

    public boolean removeCustomPane(String name) {
        boolean result = JavaFXMissingTools.runAndWait(this.getClass(), () -> this.accordion.getPanes().removeIf(pane -> Objects.equals(pane.getText(), name)));
        if (result) {
            this.computePrefWidth();
        }
        return result;
    }

    public DoubleProperty computedPrefWidthProperty() {
        return this.computedPrefWidth;
    }

    public AnchorPane getUserMainSidePane() {
        return this.userMainSidePane;
    }
}

