/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.color;

import java.util.Arrays;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.visual.PaintDefinition;
import us.ihmc.scs2.definition.yoComposite.YoColorRGBAIntDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.color.PaintEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.YoColorRGBAIntFX;

public class YoColorRGBAIntEditorController
extends PaintEditorController<YoColorRGBAIntFX> {
    @FXML
    private GridPane mainPane;
    @FXML
    private Label searchRedLabel;
    @FXML
    private Label searchGreenLabel;
    @FXML
    private Label searchBlueLabel;
    @FXML
    private Label searchAlphaLabel;
    @FXML
    private TextField searchRedTextField;
    @FXML
    private TextField searchGreenTextField;
    @FXML
    private TextField searchBlueTextField;
    @FXML
    private TextField searchAlphaTextField;
    @FXML
    private ImageView redValidImageView;
    @FXML
    private ImageView greenValidImageView;
    @FXML
    private ImageView blueValidImageView;
    @FXML
    private ImageView alphaValidImageView;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit) {
        super.initialize(toolkit, new YoColorRGBAIntFX());
        for (Label label : Arrays.asList(this.searchRedLabel, this.searchGreenLabel, this.searchBlueLabel, this.searchAlphaLabel)) {
            label.setText(label.getText() + " [0-255]");
        }
        this.setupIntegerPropertyEditor(this.searchRedTextField, this.redValidImageView, YoColorRGBAIntFX::setRed);
        this.setupIntegerPropertyEditor(this.searchGreenTextField, this.greenValidImageView, YoColorRGBAIntFX::setGreen);
        this.setupIntegerPropertyEditor(this.searchBlueTextField, this.blueValidImageView, YoColorRGBAIntFX::setBlue);
        this.setupIntegerPropertyEditor(this.searchAlphaTextField, this.alphaValidImageView, YoColorRGBAIntFX::setAlpha);
    }

    @Override
    public void setInput(PaintDefinition input) {
        if (input instanceof YoColorRGBAIntDefinition) {
            YoColorRGBAIntDefinition colorDefinition = (YoColorRGBAIntDefinition)input;
            this.setInput(colorDefinition);
        } else {
            LogTools.error((String)"Unexpected input: {}", (Object)input);
        }
    }

    public void setInput(YoColorRGBAIntDefinition definition) {
        String red = definition.getRed();
        String green = definition.getGreen();
        String blue = definition.getBlue();
        String alpha = definition.getAlpha();
        if (alpha == null) {
            alpha = Double.toString(1.0);
        }
        this.searchRedTextField.setText(red);
        this.searchGreenTextField.setText(green);
        this.searchBlueTextField.setText(blue);
        this.searchAlphaTextField.setText(alpha);
    }

    @Override
    public Pane getMainPane() {
        return this.mainPane;
    }
}

