/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.charts;

import us.ihmc.scs2.definition.yoChart.YoChartIdentifierDefinition;

public class ChartIdentifier {
    private final int row;
    private final int column;
    private int hashCode = 0;

    public ChartIdentifier(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public ChartIdentifier(YoChartIdentifierDefinition definition) {
        this(definition.getRow(), definition.getColumn());
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public ChartIdentifier shift(int rowShift, int columnShift) {
        return new ChartIdentifier(this.row + rowShift, this.column + columnShift);
    }

    public YoChartIdentifierDefinition toYoChartIdentifierDefinition() {
        return new YoChartIdentifierDefinition(this.row, this.column);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 31 * this.row + this.column;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ChartIdentifier) {
            ChartIdentifier other = (ChartIdentifier)object;
            return this.row == other.row && this.column == other.column;
        }
        return false;
    }

    public String toString() {
        return "Row " + this.row + ", column " + this.column;
    }
}

