/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Shape3D;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Translate;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXVisualTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXResource;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXResourceManager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;

public class YoPointcloudFX3D
extends YoGraphicFX3D {
    private final Group pointcloudNode = new Group();
    private List<Tuple3DProperty> points = new ArrayList<Tuple3DProperty>();
    private IntegerProperty numberOfPoints = null;
    private DoubleProperty size = new SimpleDoubleProperty(0.01);
    private YoGraphicFXResource graphicResource = YoGraphicFXResourceManager.DEFAULT_POINT3D_GRAPHIC_RESOURCE;
    private final PhongMaterial material = new PhongMaterial(Color.BLUE);
    private final Scale scale = new Scale();
    private final List<Translate> translates = new ArrayList<Translate>();
    private final IntegerProperty numberOfPointsProperty = new SimpleIntegerProperty((Object)this, "numberOfPoints", 0);
    private final BooleanProperty refreshGraphicsProperty = new SimpleBooleanProperty((Object)this, "refreshGraphics", true);

    public YoPointcloudFX3D() {
        this.numberOfPointsProperty.addListener((observable, oldValue, newValue) -> this.refreshGraphicsProperty.set(true));
        this.pointcloudNode.idProperty().bind((ObservableValue)this.nameProperty());
        this.pointcloudNode.getProperties().put((Object)YO_GRAPHICFX_ITEM_KEY, (Object)this);
    }

    public YoPointcloudFX3D(ReferenceFrame worldFrame) {
        this();
    }

    @Override
    public void render() {
        if (this.size != null) {
            this.scale.setX(this.size.get());
            this.scale.setY(this.size.get());
            this.scale.setZ(this.size.get());
        }
        if (this.color != null) {
            this.material.setDiffuseColor((Color)this.color.get());
        }
        if (this.graphicResource == null || this.graphicResource.getResourceURL() == null) {
            return;
        }
        if (this.points == null) {
            this.numberOfPointsProperty.set(0);
        } else if (this.numberOfPoints != null) {
            this.numberOfPointsProperty.set(Math.min(this.numberOfPoints.get(), this.points.size()));
        } else {
            this.numberOfPointsProperty.set(this.points.size());
        }
        if (this.refreshGraphicsProperty.get()) {
            this.refreshGraphicsProperty.set(false);
            this.refreshGraphics();
        }
        for (int i = 0; i < this.numberOfPointsProperty.get(); ++i) {
            Translate translate = this.translates.get(i);
            if (this.points.get(i).containsNaN()) {
                translate.setX(Double.NEGATIVE_INFINITY);
                translate.setY(Double.NEGATIVE_INFINITY);
                translate.setZ(Double.NEGATIVE_INFINITY);
                continue;
            }
            Point3D position = this.points.get(i).toPoint3DInWorld();
            translate.setX(position.getX());
            translate.setY(position.getY());
            translate.setZ(position.getZ());
        }
    }

    private void refreshGraphics() {
        this.pointcloudNode.getChildren().clear();
        this.translates.clear();
        if (this.numberOfPointsProperty.get() == 0 || this.graphicResource == null || this.graphicResource.getResourceURL() == null) {
            return;
        }
        for (int i = 0; i < this.numberOfPointsProperty.get(); ++i) {
            Translate translate = new Translate();
            this.translates.add(translate);
            Node[] nodes = JavaFXVisualTools.importModel(this.graphicResource.getResourceURL());
            List<Shape3D> shapes = YoGraphicTools.extractShape3Ds(Arrays.asList(nodes));
            for (Shape3D shape : shapes) {
                shape.setMaterial((Material)this.material);
                shape.getTransforms().addAll(0, Arrays.asList(translate, this.scale));
                shape.idProperty().bind((ObservableValue)this.nameProperty().concat((Object)" (").concat((Object)Integer.toString(i)).concat((Object)")"));
            }
            this.pointcloudNode.getChildren().addAll(shapes);
        }
    }

    public void setPoints(List<Tuple3DProperty> points) {
        this.points = points;
    }

    public void addPoint(DoubleProperty x, DoubleProperty y, DoubleProperty z) {
        this.addPoint(new Tuple3DProperty(null, x, y, z));
    }

    public void addPoint(Tuple3DProperty point) {
        this.points.add(point);
    }

    public void setNumberOfPoints(IntegerProperty numberOfPoints) {
        this.numberOfPoints = numberOfPoints;
    }

    public void setNumberOfPoints(int numberOfPoints) {
        this.numberOfPoints = new SimpleIntegerProperty(numberOfPoints);
    }

    public void setSize(DoubleProperty size) {
        this.size = size;
    }

    public void setSize(double size) {
        this.size = new SimpleDoubleProperty(size);
    }

    public void setGraphicResource(YoGraphicFXResource graphicResouce) {
        this.graphicResource = graphicResouce;
        this.refreshGraphicsProperty.set(true);
    }

    @Override
    public void clear() {
        this.points = null;
        this.numberOfPoints = null;
        this.size = null;
        this.graphicResource = null;
        this.color = null;
    }

    @Override
    public YoGraphicFX clone() {
        YoPointcloudFX3D clone = new YoPointcloudFX3D();
        clone.setName(this.getName());
        clone.setPoints(new ArrayList<Tuple3DProperty>(this.points));
        clone.setNumberOfPoints(this.numberOfPoints);
        clone.setSize(this.size);
        clone.setGraphicResource(this.graphicResource);
        clone.setColor(this.color);
        return clone;
    }

    public List<Tuple3DProperty> getPoints() {
        return this.points;
    }

    public IntegerProperty getNumberOfPoints() {
        return this.numberOfPoints;
    }

    public DoubleProperty getSize() {
        return this.size;
    }

    public YoGraphicFXResource getGraphicResource() {
        return this.graphicResource;
    }

    @Override
    public Node getNode() {
        return this.pointcloudNode;
    }
}

