/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXToggleButton;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.controlsfx.control.CheckTreeView;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.javaFXToolkit.messager.MessageBidirectionalBinding;
import us.ihmc.messager.TopicListener;
import us.ihmc.scs2.session.SessionDataExportRequest;
import us.ihmc.scs2.session.SessionDataFilterParameters;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.TreeViewTools;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryIOTools;
import us.ihmc.yoVariables.listener.YoRegistryChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class SessionDataExportStageController
implements VisualizerController {
    private static final String MODIFIED_FILTER_NAME = "- Modified -";
    private static final String NONE_FILTER_NAME = "None";
    private static final String ALL_FILTER_NAME = "All";
    @FXML
    private Stage stage;
    @FXML
    private VBox mainPane;
    @FXML
    private CheckTreeView<Object> selectedVariablesCheckTreeView;
    @FXML
    private JFXButton selectAllButton;
    @FXML
    private JFXButton unselectAllButton;
    @FXML
    private ComboBox<String> filterComboBox;
    @FXML
    private JFXSlider currentBufferIndexSlider;
    @FXML
    private JFXToggleButton exportRobotDefinitionToggleButton;
    @FXML
    private JFXToggleButton exportTerrainDefinitionToggleButton;
    @FXML
    private JFXToggleButton exportYoGraphicsDefinitionToggleButton;
    @FXML
    private JFXToggleButton exportRobotStateToggleButton;
    @FXML
    private JFXToggleButton exportDataToggleButton;
    @FXML
    private JFXComboBox<SharedMemoryIOTools.DataFormat> dataFormatComboBox;
    private SessionDataFilterParameters currentFilter;
    private final SessionDataCollectionBasedFilter modifiedFilter = new SessionDataCollectionBasedFilter("- Modified -");
    private final Property<SessionMode> currentSessionMode = new SimpleObjectProperty((Object)this, "currentSessionMode", null);
    private final Property<YoBufferPropertiesReadOnly> bufferProperties = new SimpleObjectProperty((Object)this, "bufferProperties", null);
    private final ObjectProperty<ContextMenu> activeContexMenu = new SimpleObjectProperty((Object)this, "activeContextMenu", null);
    private final List<Runnable> cleanupActions = new ArrayList<Runnable>();
    private CheckBoxTreeItem<Object> rootItem;
    private Window owner;
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;
    private YoManager yoManager;
    private boolean treeItemSelectedListenerEnabled = true;
    private ChangeListener<? super Boolean> treeItemSelectedListener = (o, oldValue, newValue) -> {
        if (this.treeItemSelectedListenerEnabled && !MODIFIED_FILTER_NAME.equals(this.filterComboBox.getSelectionModel().getSelectedItem())) {
            this.updateModifiedFilterFromTreeView();
            this.filterComboBox.getSelectionModel().select((Object)MODIFIED_FILTER_NAME);
        }
    };

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.owner = toolkit.getWindow();
        this.topics = toolkit.getTopics();
        this.messager = toolkit.getMessager();
        this.yoManager = toolkit.getYoManager();
        MessageBidirectionalBinding currentSessionModeBinding = this.messager.bindBidirectional(this.topics.getSessionCurrentMode(), this.currentSessionMode, false);
        this.cleanupActions.add(() -> {
            this.messager.removeJavaFXSyncedTopicListener(this.topics.getSessionCurrentMode(), (TopicListener)currentSessionModeBinding);
            this.currentSessionMode.removeListener((ChangeListener)currentSessionModeBinding);
        });
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
        MutableBoolean updatingBufferIndex = new MutableBoolean(false);
        TopicListener bufferPropertiesBinding = this.messager.bindPropertyToTopic(this.topics.getYoBufferCurrentProperties(), this.bufferProperties);
        this.cleanupActions.add(() -> this.messager.removeJavaFXSyncedTopicListener(this.topics.getYoBufferCurrentProperties(), bufferPropertiesBinding));
        ChangeListener currentSessionModeChangeListener = (o, oldValue, newValue) -> {
            if (newValue != SessionMode.PAUSE) {
                this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
            } else if (this.bufferProperties.getValue() != null) {
                this.currentBufferIndexSlider.setMax((double)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getSize());
                updatingBufferIndex.setTrue();
                this.currentBufferIndexSlider.setValue((double)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getCurrentIndex());
                updatingBufferIndex.setFalse();
            }
        };
        this.currentSessionMode.addListener(currentSessionModeChangeListener);
        this.cleanupActions.add(() -> this.currentSessionMode.removeListener(currentSessionModeChangeListener));
        TopicListener bufferPropertiesTopicListener = m -> {
            if (this.currentSessionMode.getValue() != SessionMode.PAUSE) {
                return;
            }
            this.currentBufferIndexSlider.setMax((double)m.getSize());
            if (updatingBufferIndex.isFalse()) {
                updatingBufferIndex.setTrue();
                this.currentBufferIndexSlider.setValue((double)m.getCurrentIndex());
                updatingBufferIndex.setFalse();
            }
        };
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getYoBufferCurrentProperties(), bufferPropertiesTopicListener);
        this.cleanupActions.add(() -> this.messager.removeJavaFXSyncedTopicListener(this.topics.getYoBufferCurrentProperties(), bufferPropertiesTopicListener));
        ChangeListener bufferIndexSliderListener = (o, oldValue, newValue) -> {
            if (this.currentSessionMode.getValue() != SessionMode.PAUSE) {
                return;
            }
            if (updatingBufferIndex.isFalse()) {
                updatingBufferIndex.setTrue();
                this.messager.submitMessage(this.topics.getYoBufferCurrentIndexRequest(), (Object)newValue.intValue());
                updatingBufferIndex.setFalse();
            }
        };
        this.currentBufferIndexSlider.valueProperty().addListener(bufferIndexSliderListener);
        this.cleanupActions.add(() -> this.currentBufferIndexSlider.valueProperty().removeListener(bufferIndexSliderListener));
        this.dataFormatComboBox.setItems(FXCollections.observableArrayList((Object[])SharedMemoryIOTools.DataFormat.values()));
        this.dataFormatComboBox.getSelectionModel().select((Object)SharedMemoryIOTools.DataFormat.ASCII);
        this.selectedVariablesCheckTreeView.setCellFactory(param -> new CheckBoxTreeCell<Object>(){

            public void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else if (item instanceof YoRegistry) {
                    this.setText(((YoRegistry)item).getName());
                } else if (item instanceof YoVariable) {
                    this.setText(((YoVariable)item).getName());
                } else {
                    throw new IllegalStateException("Unexpected item type: " + item.getClass());
                }
            }
        });
        this.selectedVariablesCheckTreeView.setOnContextMenuRequested(e -> {
            if (this.activeContexMenu.get() != null) {
                ((ContextMenu)this.activeContexMenu.get()).hide();
                this.activeContexMenu.set(null);
            }
            FontAwesomeIconView collapseIcon = new FontAwesomeIconView(FontAwesomeIcon.MINUS_SQUARE_ALT);
            FontAwesomeIconView expandIcon = new FontAwesomeIconView(FontAwesomeIcon.PLUS_SQUARE_ALT);
            MenuItem collapseItem = new MenuItem("Collapse all", (Node)collapseIcon);
            MenuItem expandItem = new MenuItem("Expand all", (Node)expandIcon);
            collapseItem.setOnAction(e2 -> this.collapseAll());
            expandItem.setOnAction(e2 -> this.expandAll());
            ContextMenu contextMenu = new ContextMenu(new MenuItem[]{collapseItem, expandItem});
            contextMenu.show(this.selectedVariablesCheckTreeView, e.getScreenX(), e.getScreenY());
            this.activeContexMenu.set((Object)contextMenu);
        });
        this.selectedVariablesCheckTreeView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.selectedVariablesCheckTreeView.setShowRoot(true);
        YoRegistryChangedListener rootRegistryListener = change -> this.refreshTreeView();
        this.yoManager.getRootRegistry().addListener(rootRegistryListener);
        this.cleanupActions.add(() -> this.yoManager.getRootRegistry().removeListener(rootRegistryListener));
        this.refreshTreeView();
        SessionDataFilterParameters allFilter = new SessionDataFilterParameters(ALL_FILTER_NAME, v -> true, null);
        SessionDataFilterParameters noneFilter = new SessionDataFilterParameters(NONE_FILTER_NAME, v -> false, null);
        this.filterComboBox.setItems(FXCollections.observableArrayList());
        this.filterComboBox.getItems().addAll((Object[])new String[]{MODIFIED_FILTER_NAME});
        this.filterComboBox.getItems().addAll((Object[])new String[]{ALL_FILTER_NAME});
        this.filterComboBox.getItems().addAll((Object[])new String[]{NONE_FILTER_NAME});
        this.filterComboBox.getItems().addAll(toolkit.getSessionDataPreferenceManager().getFilterMap().keySet());
        this.filterComboBox.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> {
            if (MODIFIED_FILTER_NAME.equals(oldValue)) {
                this.updateModifiedFilterFromTreeView();
            }
            this.currentFilter = MODIFIED_FILTER_NAME.equals(newValue) ? this.modifiedFilter : (ALL_FILTER_NAME.equals(newValue) ? allFilter : (NONE_FILTER_NAME.equals(newValue) ? noneFilter : toolkit.getSessionDataPreferenceManager().getFilterMap().get(newValue)));
            this.applyFilterToTreeItems(this.currentFilter);
        });
        this.filterComboBox.getSelectionModel().select((Object)ALL_FILTER_NAME);
        this.selectAllButton.setOnAction(e -> this.filterComboBox.getSelectionModel().select((Object)ALL_FILTER_NAME));
        this.unselectAllButton.setOnAction(e -> this.filterComboBox.getSelectionModel().select((Object)NONE_FILTER_NAME));
        EventHandler closeWindowEventHandler = e -> this.close();
        this.owner.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, closeWindowEventHandler);
        this.cleanupActions.add(() -> this.owner.removeEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, closeWindowEventHandler));
        this.stage.setOnCloseRequest(e -> this.close());
        SessionVisualizerIOTools.addSCSIconToWindow((Window)this.stage);
        JavaFXMissingTools.centerWindowInOwner((Window)this.stage, this.owner);
    }

    private void applyFilterToTreeItems(SessionDataFilterParameters filter) {
        this.treeItemSelectedListenerEnabled = false;
        ArrayList<CheckBoxTreeItem> itemsToProcess = new ArrayList<CheckBoxTreeItem>(Arrays.asList(this.rootItem));
        while (!itemsToProcess.isEmpty()) {
            CheckBoxTreeItem item = (CheckBoxTreeItem)itemsToProcess.remove(itemsToProcess.size() - 1);
            Object object = item.getValue();
            if (object instanceof YoVariable) {
                YoVariable var = (YoVariable)object;
                item.setSelected(filter.getVariableFilter().test(var));
                continue;
            }
            itemsToProcess.addAll((Collection<CheckBoxTreeItem>)item.getChildren());
        }
        this.treeItemSelectedListenerEnabled = true;
    }

    private void refreshTreeView() {
        this.modifiedFilter.clear();
        this.rootItem = new CheckBoxTreeItem((Object)this.yoManager.getRootRegistry());
        this.rootItem.setSelected(true);
        this.rootItem.setExpanded(true);
        this.buildTreeRecursively((TreeItem<Object>)this.rootItem);
        this.selectedVariablesCheckTreeView.setRoot(this.rootItem);
        this.filterComboBox.getSelectionModel().select((Object)ALL_FILTER_NAME);
    }

    private void buildTreeRecursively(TreeItem<Object> parent) {
        Object value = parent.getValue();
        if (value instanceof YoRegistry) {
            CheckBoxTreeItem childItem;
            YoRegistry registry = (YoRegistry)value;
            for (YoRegistry childRegistry : registry.getChildren()) {
                childItem = new CheckBoxTreeItem((Object)childRegistry);
                childItem.setSelected(!childRegistry.getChildren().isEmpty() || !childRegistry.getVariables().isEmpty());
                childItem.setExpanded(true);
                parent.getChildren().add((Object)childItem);
                this.buildTreeRecursively((TreeItem<Object>)childItem);
            }
            for (YoVariable variable : registry.getVariables()) {
                childItem = new CheckBoxTreeItem((Object)variable);
                childItem.selectedProperty().addListener(this.treeItemSelectedListener);
                childItem.setSelected(true);
                childItem.setExpanded(true);
                parent.getChildren().add((Object)childItem);
            }
        }
    }

    private void updateModifiedFilterFromTreeView() {
        this.modifiedFilter.yoVariableNames.clear();
        ArrayList<CheckBoxTreeItem> itemsToProcess = new ArrayList<CheckBoxTreeItem>(Arrays.asList(this.rootItem));
        while (!itemsToProcess.isEmpty()) {
            CheckBoxTreeItem item = (CheckBoxTreeItem)itemsToProcess.remove(itemsToProcess.size() - 1);
            Object object = item.getValue();
            if (object instanceof YoVariable) {
                YoVariable var = (YoVariable)object;
                if (!item.isSelected()) continue;
                this.modifiedFilter.yoVariableNames.add(var.getFullNameString());
                continue;
            }
            object = item.getValue();
            if (object instanceof YoRegistry) {
                YoRegistry reg = (YoRegistry)object;
                if (reg.getChildren().isEmpty() && reg.getVariables().isEmpty()) {
                    item.setSelected(false);
                    continue;
                }
                itemsToProcess.addAll((Collection<CheckBoxTreeItem>)item.getChildren());
                continue;
            }
            throw new IllegalStateException("Unexpected value type: " + item.getValue().getClass().getSimpleName());
        }
    }

    public void collapseAll() {
        TreeViewTools.collapseRecursively(this.rootItem);
    }

    public void expandAll() {
        TreeViewTools.expandRecursively(this.rootItem);
    }

    public Stage getStage() {
        return this.stage;
    }

    public void close() {
        this.stage.close();
        this.cleanupActions.forEach(Runnable::run);
        this.cleanupActions.clear();
    }

    @FXML
    void cancel(ActionEvent event) {
        this.close();
    }

    @FXML
    void exportData(ActionEvent event) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath("export-data"));
        File result = directoryChooser.showDialog(this.owner);
        if (result == null) {
            return;
        }
        SessionVisualizerIOTools.setDefaultFilePath("export-data", result);
        SessionDataExportRequest request = new SessionDataExportRequest();
        request.setFile(result);
        request.setOverwrite(true);
        request.setVariableFilter(this.buildVariableFilter());
        request.setRegistryFilter(this.buildRegistryFilter());
        request.setExportRobotDefinitions(this.exportRobotDefinitionToggleButton.isSelected());
        request.setExportTerrainObjectDefinitions(this.exportTerrainDefinitionToggleButton.isSelected());
        request.setExportSessionYoGraphicDefinitions(this.exportYoGraphicsDefinitionToggleButton.isSelected());
        request.setExportRobotStateDefinitions(this.exportRobotStateToggleButton.isSelected());
        request.setExportSessionBufferRegistryDefinition(this.exportDataToggleButton.isSelected());
        if (this.exportDataToggleButton.isSelected()) {
            request.setExportSessionBufferDataFormat((SharedMemoryIOTools.DataFormat)this.dataFormatComboBox.getSelectionModel().getSelectedItem());
        } else {
            request.setExportSessionBufferDataFormat(null);
        }
        request.setOnExportStartCallback(() -> this.messager.submitMessage(this.topics.getDisableUserControls(), (Object)true));
        request.setOnExportEndCallback(() -> this.messager.submitMessage(this.topics.getDisableUserControls(), (Object)false));
        this.close();
        this.messager.submitMessage(this.topics.getSessionDataExportRequest(), (Object)request);
    }

    private Predicate<YoVariable> buildVariableFilter() {
        Set<String> selectedFullnames = this.collectSelectedVariableFullnames(this.rootItem, null);
        return var -> selectedFullnames.contains(var.getFullNameString());
    }

    private Set<String> collectSelectedVariableFullnames(CheckBoxTreeItem<Object> current, Set<String> fullnamesToPack) {
        if (current.getValue() instanceof YoRegistry) {
            if (!current.isSelected() && !current.isIndeterminate()) {
                return fullnamesToPack;
            }
            for (TreeItem childItem : current.getChildren()) {
                fullnamesToPack = this.collectSelectedVariableFullnames((CheckBoxTreeItem<Object>)((CheckBoxTreeItem)childItem), fullnamesToPack);
            }
        } else if (current.getValue() instanceof YoVariable) {
            if (!current.isSelected()) {
                return fullnamesToPack;
            }
            if (fullnamesToPack == null) {
                fullnamesToPack = new LinkedHashSet<String>();
            }
            fullnamesToPack.add(((YoVariable)current.getValue()).getFullNameString());
        }
        return fullnamesToPack;
    }

    private Predicate<YoRegistry> buildRegistryFilter() {
        Set<String> selectedFullnames = this.collectSelectedRegistryFullnames(this.rootItem, null);
        return var -> selectedFullnames.contains(var.getNamespace().getName());
    }

    private Set<String> collectSelectedRegistryFullnames(CheckBoxTreeItem<Object> current, Set<String> fullnamesToPack) {
        if (current.getValue() instanceof YoRegistry) {
            if (!current.isSelected() && !current.isIndeterminate()) {
                return fullnamesToPack;
            }
            if (fullnamesToPack == null) {
                fullnamesToPack = new LinkedHashSet<String>();
            }
            fullnamesToPack.add(((YoRegistry)current.getValue()).getNamespace().getName());
            for (TreeItem childItem : current.getChildren()) {
                fullnamesToPack = this.collectSelectedRegistryFullnames((CheckBoxTreeItem<Object>)((CheckBoxTreeItem)childItem), fullnamesToPack);
            }
        }
        return fullnamesToPack;
    }

    private static class SessionDataCollectionBasedFilter
    extends SessionDataFilterParameters {
        private final Set<String> yoVariableNames = new LinkedHashSet<String>();
        private final Predicate<YoVariable> variableFilter = v -> this.yoVariableNames.contains(v.getFullNameString());
        private final Predicate<YoRegistry> registryFilter = null;

        public SessionDataCollectionBasedFilter(String name) {
            super(name, null, null);
        }

        private void clear() {
            this.yoVariableNames.clear();
        }

        public Predicate<YoVariable> getVariableFilter() {
            return this.variableFilter;
        }

        public Predicate<YoRegistry> getRegistryFilter() {
            return this.registryFilter;
        }
    }
}

