/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javafx.application.Application;
import javafx.stage.Stage;

public class JavaFXApplicationCreator
extends Application {
    private static JavaFXApplicationCreator mainApplication;
    private static final CountDownLatch latch;
    private static JavaFXApplicationCreator startUpTest;
    private static List<Runnable> stopListeners;

    public JavaFXApplicationCreator() {
        this.setStartUpTest(this);
    }

    private void setStartUpTest(JavaFXApplicationCreator startUpTest) {
        JavaFXApplicationCreator.startUpTest = startUpTest;
        latch.countDown();
    }

    private static JavaFXApplicationCreator waitForStartUpTest() {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return startUpTest;
    }

    public static void attachStopListener(Runnable stopListener) {
        stopListeners.add(stopListener);
    }

    public void start(Stage primaryStage) throws Exception {
    }

    public void stop() throws Exception {
        for (Runnable stopListener : stopListeners) {
            stopListener.run();
        }
        mainApplication = null;
    }

    public static JavaFXApplicationCreator spawnJavaFXMainApplication() {
        if (mainApplication != null) {
            return mainApplication;
        }
        new Thread(() -> Application.launch(JavaFXApplicationCreator.class, (String[])new String[0]), "JavaFX-spawner").start();
        mainApplication = JavaFXApplicationCreator.waitForStartUpTest();
        return mainApplication;
    }

    static {
        latch = new CountDownLatch(1);
        startUpTest = null;
        stopListeners = new ArrayList<Runnable>();
    }
}

