/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard;

import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXTextField;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.Slider;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoVariableSlider;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoEnumAsStringProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;
import us.ihmc.scs2.sharedMemory.LinkedYoEnum;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;

public class YoEnumSlider
implements YoVariableSlider {
    private final YoEnumAsStringProperty<?> yoEnumProperty;
    private final List<Runnable> cleanupTasks = new ArrayList<Runnable>();

    public YoEnumSlider(YoEnum<?> yoEnum, LinkedYoRegistry linkedYoRegistry) {
        this.yoEnumProperty = new YoEnumAsStringProperty(yoEnum, this);
        this.yoEnumProperty.setLinkedBuffer((LinkedYoEnum)linkedYoRegistry.linkYoVariable(yoEnum, this.yoEnumProperty));
    }

    @Override
    public void bindMaxTextField(JFXTextField maxTextField) {
        maxTextField.setDisable(true);
        this.cleanupTasks.add(() -> maxTextField.setDisable(false));
    }

    @Override
    public void bindMinTextField(JFXTextField minTextField) {
        minTextField.setDisable(true);
        this.cleanupTasks.add(() -> minTextField.setDisable(false));
    }

    @Override
    public void bindVirtualSlider(Slider virtualSlider) {
        virtualSlider.setMin(0.0);
        virtualSlider.setMax((double)this.yoEnumProperty.getYoVariable().getEnumValuesAsString().length);
        virtualSlider.setMajorTickUnit(1.0);
        MutableBoolean updating = new MutableBoolean(false);
        ChangeListener sliderUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            updating.setTrue();
            virtualSlider.valueProperty().set((double)this.yoEnumProperty.toEnumOrdinal(this.yoEnumProperty.get()));
            updating.setFalse();
        };
        ChangeListener yoEnumUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            JavaFXMissingTools.runLater(this.getClass(), () -> {
                updating.setTrue();
                this.yoEnumProperty.set(this.yoEnumProperty.toEnumString(virtualSlider.valueProperty().getValue().intValue()));
                updating.setFalse();
            });
        };
        this.yoEnumProperty.addListener(sliderUpdater);
        virtualSlider.valueProperty().addListener(yoEnumUpdater);
        this.cleanupTasks.add(() -> {
            this.yoEnumProperty.removeListener(sliderUpdater);
            virtualSlider.valueProperty().removeListener(yoEnumUpdater);
        });
    }

    @Override
    public void bindVirtualKnob(JFXSpinner virtualKnob) {
        ChangeListener knobUpdater = (o, oldValue, newValue) -> {
            double value = (double)this.yoEnumProperty.toEnumOrdinal(this.yoEnumProperty.get()) / (double)this.yoEnumProperty.getYoVariable().getEnumSize();
            virtualKnob.setProgress(value);
        };
        knobUpdater.changed(null, null, null);
        this.yoEnumProperty.addListener(knobUpdater);
        this.cleanupTasks.add(() -> this.yoEnumProperty.removeListener(knobUpdater));
    }

    @Override
    public void bindSliderVariable(SliderboardVariable sliderVariable) {
        MutableBoolean updating = new MutableBoolean(false);
        ChangeListener sliderUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            int sliderPosition = SliderboardVariable.doubleToInt((double)this.yoEnumProperty.getYoVariable().getOrdinal(), (double)0.0, (double)(this.yoEnumProperty.getYoVariable().getEnumValuesAsString().length - 1), (int)sliderVariable.getMin(), (int)sliderVariable.getMax());
            updating.setTrue();
            sliderVariable.setValue(sliderPosition);
            updating.setFalse();
        };
        ChangeListener yoEnumUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            int yoEnumOrdinal = SliderboardVariable.doubleToInt((double)newValue.intValue(), (double)sliderVariable.getMin(), (double)sliderVariable.getMax(), (int)0, (int)(this.yoEnumProperty.getYoVariable().getEnumValuesAsString().length - 1));
            JavaFXMissingTools.runLater(this.getClass(), () -> {
                updating.setTrue();
                this.yoEnumProperty.set(this.yoEnumProperty.toEnumString(yoEnumOrdinal));
                updating.setFalse();
            });
        };
        this.yoEnumProperty.addListener(sliderUpdater);
        sliderVariable.valueProperty().addListener(yoEnumUpdater);
        this.cleanupTasks.add(() -> {
            sliderVariable.valueProperty().removeListener(yoEnumUpdater);
            this.yoEnumProperty.removeListener(sliderUpdater);
        });
    }

    public YoEnum<?> getYoVariable() {
        return this.yoEnumProperty.getYoVariable();
    }

    @Override
    public YoSliderDefinition toYoSliderDefinition() {
        YoSliderDefinition definition = new YoSliderDefinition();
        definition.setVariableName(this.getYoVariable().getFullNameString());
        return definition;
    }

    @Override
    public YoKnobDefinition toYoKnobDefinition() {
        YoKnobDefinition definition = new YoKnobDefinition();
        definition.setVariableName(this.getYoVariable().getFullNameString());
        return definition;
    }

    @Override
    public void dispose() {
        this.yoEnumProperty.dispose();
        this.cleanupTasks.forEach(Runnable::run);
    }
}

