/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard;

import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXTextField;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.Slider;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoVariableSlider;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoBooleanProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;
import us.ihmc.scs2.sharedMemory.LinkedYoBoolean;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoBooleanSlider
implements YoVariableSlider {
    private final YoBooleanProperty yoBooleanProperty;
    private final List<Runnable> cleanupTasks = new ArrayList<Runnable>();

    public YoBooleanSlider(YoBoolean yoBoolean, LinkedYoRegistry linkedYoRegistry) {
        this.yoBooleanProperty = new YoBooleanProperty(yoBoolean, this);
        this.yoBooleanProperty.setLinkedBuffer((LinkedYoBoolean)linkedYoRegistry.linkYoVariable((YoVariable)yoBoolean, (Object)this.yoBooleanProperty));
    }

    @Override
    public void bindMaxTextField(JFXTextField maxTextField) {
        maxTextField.setDisable(true);
        this.cleanupTasks.add(() -> maxTextField.setDisable(false));
    }

    @Override
    public void bindMinTextField(JFXTextField minTextField) {
        minTextField.setDisable(true);
        this.cleanupTasks.add(() -> minTextField.setDisable(false));
    }

    @Override
    public void bindVirtualSlider(Slider virtualSlider) {
        virtualSlider.setMin(0.0);
        virtualSlider.setMax(1.0);
        virtualSlider.setMajorTickUnit(1.0);
        MutableBoolean updating = new MutableBoolean(false);
        virtualSlider.valueProperty().set(this.yoBooleanProperty.get() ? 1.0 : 0.0);
        ChangeListener sliderUpdater = (o, oldValue, newValue) -> {
            boolean currentSliderValue;
            if (updating.isTrue()) {
                return;
            }
            boolean bl = currentSliderValue = virtualSlider.valueProperty().get() > 0.5;
            if (currentSliderValue == this.yoBooleanProperty.get()) {
                return;
            }
            updating.setTrue();
            virtualSlider.valueProperty().set(this.yoBooleanProperty.get() ? 1.0 : 0.0);
            updating.setFalse();
        };
        ChangeListener yoBooleanUpdater = (o, oldValue, newValue) -> {
            boolean currentSliderValue;
            if (updating.isTrue()) {
                return;
            }
            boolean bl = currentSliderValue = virtualSlider.valueProperty().get() > 0.5;
            if (currentSliderValue == this.yoBooleanProperty.get()) {
                return;
            }
            JavaFXMissingTools.runLater(this.getClass(), () -> {
                updating.setTrue();
                this.yoBooleanProperty.set(currentSliderValue);
                updating.setFalse();
            });
        };
        this.yoBooleanProperty.addListener(sliderUpdater);
        virtualSlider.valueProperty().addListener(yoBooleanUpdater);
        this.cleanupTasks.add(() -> {
            this.yoBooleanProperty.removeListener(sliderUpdater);
            virtualSlider.valueProperty().removeListener(yoBooleanUpdater);
        });
    }

    @Override
    public void bindVirtualKnob(JFXSpinner virtualKnob) {
        ChangeListener knobUpdater = (o, oldValue, newValue) -> virtualKnob.setProgress(newValue != false ? 1.0 : 0.0);
        knobUpdater.changed(null, null, null);
        this.yoBooleanProperty.addListener(knobUpdater);
        this.cleanupTasks.add(() -> this.yoBooleanProperty.removeListener(knobUpdater));
    }

    @Override
    public void bindSliderVariable(SliderboardVariable sliderVariable) {
        MutableBoolean updating = new MutableBoolean(false);
        sliderVariable.setValue(SliderboardVariable.booleanToInt((boolean)this.yoBooleanProperty.get(), (int)sliderVariable.getMin(), (int)sliderVariable.getMax()));
        ChangeListener sliderUpdater = (o, oldValue, newValue) -> {
            boolean currentSliderValue;
            if (updating.isTrue()) {
                return;
            }
            boolean bl = currentSliderValue = (double)sliderVariable.valueProperty().get() > 0.5;
            if (currentSliderValue == this.yoBooleanProperty.get()) {
                return;
            }
            int sliderPosition = SliderboardVariable.booleanToInt((boolean)this.yoBooleanProperty.get(), (int)sliderVariable.getMin(), (int)sliderVariable.getMax());
            updating.setTrue();
            sliderVariable.setValue(sliderPosition);
            updating.setFalse();
        };
        ChangeListener yoBooleanUpdater = (o, oldValue, newValue) -> {
            boolean currentSliderValue;
            if (updating.isTrue()) {
                return;
            }
            boolean bl = currentSliderValue = (double)sliderVariable.valueProperty().get() > 0.5;
            if (currentSliderValue == this.yoBooleanProperty.get()) {
                return;
            }
            boolean yoBooleanValue = SliderboardVariable.intToBoolean((int)newValue.intValue(), (int)sliderVariable.getMin(), (int)sliderVariable.getMax());
            JavaFXMissingTools.runLater(this.getClass(), () -> {
                updating.setTrue();
                this.yoBooleanProperty.set(yoBooleanValue);
                updating.setFalse();
            });
        };
        this.yoBooleanProperty.addListener(sliderUpdater);
        sliderVariable.valueProperty().addListener(yoBooleanUpdater);
        this.cleanupTasks.add(() -> {
            this.yoBooleanProperty.removeListener(sliderUpdater);
            sliderVariable.valueProperty().removeListener(yoBooleanUpdater);
        });
    }

    public YoBooleanProperty getYoBooleanProperty() {
        return this.yoBooleanProperty;
    }

    public YoBoolean getYoVariable() {
        return this.yoBooleanProperty.getYoVariable();
    }

    @Override
    public YoSliderDefinition toYoSliderDefinition() {
        YoSliderDefinition definition = new YoSliderDefinition();
        definition.setVariableName(this.getYoVariable().getFullNameString());
        return definition;
    }

    @Override
    public YoKnobDefinition toYoKnobDefinition() {
        YoKnobDefinition definition = new YoKnobDefinition();
        definition.setVariableName(this.getYoVariable().getFullNameString());
        return definition;
    }

    @Override
    public void dispose() {
        this.yoBooleanProperty.dispose();
        this.cleanupTasks.forEach(Runnable::run);
    }
}

