/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class MenuTools {
    public static void configureTextFieldForCustomMenuItem(CustomMenuItem owner, TextField textField) {
        SimpleBooleanProperty editMode = new SimpleBooleanProperty(false);
        EventHandler eventConsumer = e -> e.consume();
        textField.addEventFilter(InputEvent.ANY, arg_0 -> MenuTools.lambda$configureTextFieldForCustomMenuItem$1(owner, (BooleanProperty)editMode, textField, eventConsumer, arg_0));
    }

    private static boolean isAncestor(Node query, Node ancestor) {
        if (query == null) {
            return false;
        }
        Parent parent = query.getParent();
        if (parent == ancestor) {
            return true;
        }
        return MenuTools.isAncestor((Node)parent, ancestor);
    }

    @SafeVarargs
    public static <T extends Node> void setupContextMenu(T owner, Function<T, MenuItem> ... menuItemFactories) {
        BiFunction[] factoryAdapters = (BiFunction[])Stream.of(menuItemFactories).map(factory -> (t, u) -> (MenuItem)factory.apply(t)).toArray(BiFunction[]::new);
        MenuTools.setupContextMenu(owner, factoryAdapters);
    }

    @SafeVarargs
    public static <T extends Node> void setupContextMenu(T owner, BiFunction<T, MouseEvent, MenuItem> ... menuItemFactories) {
        SimpleObjectProperty activeContexMenu = new SimpleObjectProperty(owner, "activeContextMenu", null);
        owner.addEventHandler(MouseEvent.MOUSE_RELEASED, arg_0 -> MenuTools.lambda$setupContextMenu$9((ObjectProperty)activeContexMenu, menuItemFactories, owner, arg_0));
    }

    private static /* synthetic */ void lambda$setupContextMenu$9(ObjectProperty activeContexMenu, BiFunction[] menuItemFactories, Node owner, MouseEvent e) {
        MenuItem[] menuItems;
        if (e.getButton() != MouseButton.SECONDARY || !e.isStillSincePress()) {
            return;
        }
        if (activeContexMenu.get() != null) {
            ((ContextMenu)activeContexMenu.get()).hide();
            activeContexMenu.set(null);
        }
        if ((menuItems = (MenuItem[])Stream.of(menuItemFactories).map(factory -> (MenuItem)factory.apply(owner, e)).filter(item -> item != null).toArray(MenuItem[]::new)).length == 0) {
            return;
        }
        ContextMenu contextMenu = new ContextMenu(menuItems);
        contextMenu.show(owner, e.getScreenX(), e.getScreenY());
        contextMenu.setAutoFix(true);
        contextMenu.setAutoHide(true);
        activeContexMenu.set((Object)contextMenu);
        owner.addEventFilter(MouseEvent.MOUSE_PRESSED, e2 -> {
            contextMenu.hide();
            activeContexMenu.set(null);
        });
        e.consume();
    }

    private static /* synthetic */ void lambda$configureTextFieldForCustomMenuItem$1(CustomMenuItem owner, BooleanProperty editMode, TextField textField, EventHandler eventConsumer, InputEvent inputEvent) {
        Parent menuItemContainer = owner.getContent().getParent();
        if (inputEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)inputEvent;
            if (mouseEvent.getEventType() == MouseEvent.MOUSE_PRESSED) {
                editMode.set(true);
                textField.requestFocus();
                menuItemContainer.addEventFilter(MouseEvent.MOUSE_ENTERED, eventConsumer);
            }
            if (mouseEvent.getEventType() == MouseEvent.MOUSE_EXITED && mouseEvent.getPickResult().getIntersectedNode() != textField && !MenuTools.isAncestor(mouseEvent.getPickResult().getIntersectedNode(), (Node)textField)) {
                editMode.set(false);
                textField.cancelEdit();
            }
        }
        if (inputEvent.getEventType() == KeyEvent.KEY_PRESSED) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            if (keyEvent.getCode() == KeyCode.ESCAPE) {
                editMode.set(false);
                textField.cancelEdit();
                keyEvent.consume();
            } else if (keyEvent.getCode() == KeyCode.ENTER) {
                editMode.set(false);
                textField.commitValue();
                menuItemContainer.requestFocus();
                keyEvent.consume();
            }
        }
        if (inputEvent instanceof MouseEvent && editMode.get()) {
            inputEvent.consume();
        }
        if (!editMode.get()) {
            menuItemContainer.removeEventFilter(MouseEvent.MOUSE_ENTERED, eventConsumer);
        }
    }
}

