/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.charts;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.Executor;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.chart.InvisibleNumberAxis;
import us.ihmc.javaFXExtensions.chart.DynamicXYChart;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartDoubleBounds;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIntegerBounds;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartMarker;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.DynamicChartLegend;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.NumberSeries;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.NumberSeriesLayer;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ChartRenderManager;

public class DynamicLineChart
extends DynamicXYChart {
    private final ObjectProperty<ChartStyle> chartStyleProperty = new SimpleObjectProperty((Object)this, "chartStyle", (Object)ChartStyle.RAW);
    private final ObservableList<NumberSeriesLayer> seriesLayers = FXCollections.observableArrayList();
    private final ChangeListener<Object> chartUpdaterListener = (o, oldValue, newValue) -> this.requestChartLayout();
    private final ObservableList<ChartMarker> markers = FXCollections.observableArrayList();
    private final DynamicChartLegend legend = new DynamicChartLegend();
    private final BooleanProperty updateIndexMarkersVisible = new SimpleBooleanProperty((Object)this, "updateIndexMarkersVisible", false);
    private final InvisibleNumberAxis xAxis;
    private final InvisibleNumberAxis yAxis;
    private final Executor backgroundExecutor;
    private final ChartRenderManager chartRenderManager;

    public DynamicLineChart(InvisibleNumberAxis xAxis, InvisibleNumberAxis yAxis, Executor backgroundExecutor, ChartRenderManager chartRenderManager) {
        super(xAxis, yAxis);
        this.xAxis = xAxis;
        this.chartRenderManager = chartRenderManager;
        if (xAxis.getSide() == null) {
            xAxis.setSide(Side.BOTTOM);
        }
        this.yAxis = yAxis;
        if (yAxis.getSide() == null) {
            yAxis.setSide(Side.LEFT);
        }
        this.backgroundExecutor = backgroundExecutor;
        xAxis.autoRangingProperty().addListener((ov, t, t1) -> this.updateAxisRange());
        yAxis.autoRangingProperty().addListener((ov, t, t1) -> this.updateAxisRange());
        this.chartStyleProperty.addListener(this.chartUpdaterListener);
        this.markers.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (ChartMarker newMarker : change.getAddedSubList()) {
                        this.plotContent.getChildren().add((Object)newMarker);
                        newMarker.addListener((ChangeListener<Object>)((ChangeListener)(o, oldValue, newValue) -> this.updateMarkers()));
                    }
                    this.updateMarkers();
                }
                if (!change.wasRemoved()) continue;
                for (ChartMarker oldMarker : change.getRemoved()) {
                    this.plotContent.getChildren().remove((Object)oldMarker);
                    oldMarker.destroy();
                }
            }
        });
        this.setLegend((Node)this.legend);
    }

    public void addSeries(NumberSeries series) {
        int seriesIndex = this.seriesLayers.size();
        series.negatedProperty().addListener(this.chartUpdaterListener);
        series.customYBoundsProperty().addListener(this.chartUpdaterListener);
        series.dirtyProperty().addListener(this.chartUpdaterListener);
        NumberSeriesLayer layer = new NumberSeriesLayer(this.xAxis, this.yAxis, series, this.backgroundExecutor, this.chartRenderManager);
        layer.chartStyleProperty().bind(this.chartStyleProperty);
        layer.updateIndexMarkerVisibleProperty().bind((ObservableValue)this.updateIndexMarkersVisible);
        DynamicLineChart.setSeriesDefaultStyleClass(layer, seriesIndex);
        this.seriesLayers.add((Object)layer);
        this.legend.getItems().add((Object)layer.getLegendNode());
        this.plotContent.getChildren().add((Object)layer);
        this.chartUpdaterListener.changed(null, null, null);
    }

    public void removeSeries(NumberSeries series) {
        Optional<NumberSeriesLayer> containingLayer = this.seriesLayers.stream().filter(layer -> layer.getNumberSeries() == series).findFirst();
        if (containingLayer.isPresent()) {
            int indexOf = this.seriesLayers.indexOf((Object)containingLayer.get());
            NumberSeriesLayer removedLayer = (NumberSeriesLayer)((Object)this.seriesLayers.remove(indexOf));
            removedLayer.chartStyleProperty().unbind();
            removedLayer.updateIndexMarkerVisibleProperty().unbind();
            series.negatedProperty().removeListener(this.chartUpdaterListener);
            series.customYBoundsProperty().removeListener(this.chartUpdaterListener);
            series.dirtyProperty().removeListener(this.chartUpdaterListener);
            containingLayer.get().chartStyleProperty().unbind();
            this.plotContent.getChildren().remove((Object)containingLayer.get());
            this.legend.getItems().remove((Object)containingLayer.get().getLegendNode());
            for (int i = indexOf; i < this.seriesLayers.size(); ++i) {
                DynamicLineChart.setSeriesDefaultStyleClass((NumberSeriesLayer)((Object)this.seriesLayers.get(i)), i);
            }
            this.chartUpdaterListener.changed(null, null, null);
        }
    }

    public void addMarker(ChartMarker marker) {
        this.markers.add((Object)marker);
    }

    public void removeMarker(ChartMarker marker) {
        this.markers.remove((Object)marker);
    }

    private void updateSeriesList(double top, double left, double width, double height) {
        for (NumberSeriesLayer seriesLayer : this.seriesLayers) {
            seriesLayer.scheduleRender();
        }
    }

    protected void layoutPlotChildren(double top, double left, double width, double height) {
        this.updateSeriesList(top, left, width, height);
        this.updateMarkers();
    }

    private void updateMarkers() {
        this.markers.forEach(marker -> marker.updateMarker(this.xAxis, this.yAxis));
    }

    protected void updateAxisRange() {
        this.updateXAxisRange();
        this.updateYAxisRange();
    }

    protected void updateXAxisRange() {
        ChartIntegerBounds xBounds = null;
        if (this.xAxis.isAutoRanging()) {
            for (NumberSeriesLayer layer : this.seriesLayers) {
                NumberSeries series = layer.getNumberSeries();
                ChartIntegerBounds dataXBounds = (ChartIntegerBounds)series.xBoundsProperty().getValue();
                if (dataXBounds == null) continue;
                if (xBounds == null) {
                    xBounds = new ChartIntegerBounds(dataXBounds);
                    continue;
                }
                xBounds = xBounds.union(dataXBounds);
            }
            if (xBounds != null) {
                this.xAxis.invalidateRange(Arrays.asList(xBounds.getLower(), xBounds.getUpper()));
            }
        }
    }

    protected void updateYAxisRange() {
        ChartDoubleBounds yBounds = null;
        if (this.yAxis.isAutoRanging()) {
            if (this.chartStyleProperty.get() == ChartStyle.NORMALIZED) {
                this.yAxis.invalidateRange(0.0, 1.0);
            } else {
                for (NumberSeriesLayer layer : this.seriesLayers) {
                    NumberSeries series = layer.getNumberSeries();
                    ChartDoubleBounds dataYBounds = (ChartDoubleBounds)series.yBoundsProperty().getValue();
                    if (dataYBounds == null) continue;
                    if (series.getCustomYBounds() != null) {
                        dataYBounds = series.getCustomYBounds();
                    }
                    if (series.isNegated()) {
                        dataYBounds = dataYBounds.negate();
                    }
                    if (yBounds == null) {
                        yBounds = dataYBounds;
                        continue;
                    }
                    yBounds = yBounds.union(dataYBounds);
                }
                if (yBounds != null) {
                    this.yAxis.invalidateRange(yBounds.getLower(), yBounds.getUpper());
                }
            }
        }
    }

    public InvisibleNumberAxis getXAxis() {
        return this.xAxis;
    }

    public InvisibleNumberAxis getYAxis() {
        return this.yAxis;
    }

    public BooleanProperty updateIndexMarkersVisible() {
        return this.updateIndexMarkersVisible;
    }

    public void setChartStyle(ChartStyle style) {
        this.chartStyleProperty.set((Object)style);
    }

    public ChartStyle getChartStyle() {
        return (ChartStyle)((Object)this.chartStyleProperty.get());
    }

    public ObjectProperty<ChartStyle> chartStyleProperty() {
        return this.chartStyleProperty;
    }

    private static void setSeriesDefaultStyleClass(NumberSeriesLayer seriesLayer, int seriesIndex) {
        seriesLayer.getStyleClass().setAll((Object[])new String[]{"chart-series-line", "series" + seriesIndex, DynamicLineChart.getDefaultColorStyle(seriesIndex)});
    }

    public static String getDefaultColorStyle(int index) {
        return "default-color" + index % 8;
    }

    public static enum ChartStyle {
        RAW,
        NORMALIZED;

    }
}

