/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.menu;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Group;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SubScene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.MenuItem;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.xml.bind.JAXBException;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.SessionDataExportStageController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VideoRecordingPreviewPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.simulation.SimulationDataSession;

public class FileMenuController
implements VisualizerController {
    @FXML
    private MenuItem takeSnapshotMenuItem;
    @FXML
    private MenuItem exportVideoMenuItem;
    @FXML
    private MenuItem loadConfigurationMenuItem;
    @FXML
    private MenuItem loadDefaultConfigurationMenuItem;
    @FXML
    private MenuItem saveConfigurationMenuItem;
    @FXML
    private MenuItem saveDefaultConfigurationMenuItem;
    @FXML
    private MenuItem closeMenuItem;
    private Stage owner;
    private JavaFXMessager messager;
    private SessionVisualizerTopics topics;
    private Property<VideoRecordingPreviewPaneController> videoExportController = new SimpleObjectProperty((Object)this, "videoExportController", null);
    private Property<SessionDataExportStageController> dataExportController = new SimpleObjectProperty((Object)this, "dataExportController", null);
    private SubScene mainScene3D;
    private Group mainView3DRoot;
    private SessionVisualizerWindowToolkit toolkit;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.toolkit = toolkit;
        this.owner = toolkit.getWindow();
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.mainScene3D = toolkit.getGlobalToolkit().getMainScene3D();
        this.mainView3DRoot = toolkit.getGlobalToolkit().getMainView3DRoot();
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getDisableUserControls(), disable -> {
            this.takeSnapshotMenuItem.setDisable(disable.booleanValue());
            this.exportVideoMenuItem.setDisable(disable.booleanValue());
        });
    }

    @FXML
    private void exportData() {
        if (this.dataExportController.getValue() != null) {
            ((SessionDataExportStageController)this.dataExportController.getValue()).close();
            this.dataExportController.setValue(null);
        }
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.SESSION_DATA_EXPORT_STAGE_URL);
            loader.load();
            SessionDataExportStageController controller = (SessionDataExportStageController)loader.getController();
            controller.initialize(this.toolkit);
            controller.getStage().show();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void importData() {
        SimulationDataSession newSession;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open data file");
        fileChooser.getExtensionFilters().add((Object)SessionVisualizerIOTools.scs2InfoFilter);
        fileChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath("import-data"));
        File result = fileChooser.showOpenDialog((Window)this.owner);
        if (result == null) {
            return;
        }
        SessionVisualizerIOTools.setDefaultFilePath("import-data", result);
        try {
            newSession = new SimulationDataSession(result);
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
            return;
        }
        this.messager.submitMessage(this.topics.getStartNewSessionRequest(), (Object)newSession);
    }

    @FXML
    private void requestVideo() {
        if (this.videoExportController.getValue() != null) {
            ((VideoRecordingPreviewPaneController)this.videoExportController.getValue()).close();
            this.videoExportController.setValue(null);
        }
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.VIDEO_PREVIEW_PANE_URL);
            loader.load();
            VideoRecordingPreviewPaneController controller = (VideoRecordingPreviewPaneController)loader.getController();
            controller.initialize((Window)this.owner, this.mainView3DRoot, (PerspectiveCamera)this.mainScene3D.getCamera(), this.messager, this.topics);
            controller.getStage().show();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void loadConfiguration() {
        File result = SessionVisualizerIOTools.scs2ConfigurationOpenFileDialog((Window)this.owner);
        if (result != null) {
            this.messager.submitMessage(this.topics.getSessionVisualizerConfigurationLoadRequest(), (Object)result);
        }
    }

    @FXML
    private void loadDefaultConfiguration() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Load default configuration?", new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        SessionVisualizerIOTools.addSCSIconToDialog(alert);
        Optional result = alert.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK) {
            this.messager.submitMessage(this.topics.getSessionVisualizerDefaultConfigurationLoadRequest(), (Object)true);
        }
    }

    @FXML
    private void saveConfiguration() {
        File result = SessionVisualizerIOTools.scs2ConfigurationSaveFileDialog((Window)this.owner);
        if (result != null) {
            this.messager.submitMessage(this.topics.getSessionVisualizerConfigurationSaveRequest(), (Object)result);
        }
    }

    @FXML
    private void saveDefaultConfiguration() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Save current configuration as default?", new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        SessionVisualizerIOTools.addSCSIconToDialog(alert);
        Optional result = alert.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK) {
            this.messager.submitMessage(this.topics.getSessionVisualizerDefaultConfigurationSaveRequest(), (Object)true);
        }
    }

    @FXML
    private void requestSnapshot() {
        this.messager.submitMessage(this.topics.getTakeSnapshot(), new Object());
    }

    @FXML
    private void close() {
        this.messager.submitMessage(this.topics.getSessionVisualizerCloseRequest(), (Object)true);
    }
}

