/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor;

import com.jfoenix.controls.JFXColorPicker;
import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXTextField;
import java.util.function.UnaryOperator;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.util.StringConverter;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXVisualTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.PositiveIntegerValueFilter;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.RoundedDoubleConverter;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;

public class YoGraphic3DStyleEditorPaneController {
    @FXML
    private GridPane mainPane;
    @FXML
    private Label colorLabel;
    @FXML
    private JFXColorPicker colorPicker;
    @FXML
    private Label opacityLabel;
    @FXML
    private JFXSlider opacitySlider;
    @FXML
    private JFXTextField opacityTextField;
    private final ObjectProperty<Color> colorProperty = new SimpleObjectProperty((Object)this, "color", null);
    private final ObservableBooleanValue inputsValidityProperty = new SimpleBooleanProperty((Object)this, "inputsValidity", true);

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.colorPicker.valueProperty().bindBidirectional(this.colorProperty);
        TextFormatter value = new TextFormatter((StringConverter)new RoundedDoubleConverter(), (Object)this.opacitySlider.getValue(), (UnaryOperator)new PositiveIntegerValueFilter());
        this.opacityTextField.setTextFormatter(value);
        value.valueProperty().bindBidirectional((Property)this.opacitySlider.valueProperty().asObject());
        MutableBoolean updatingOpacity = new MutableBoolean(false);
        MutableBoolean updatingSlider = new MutableBoolean(false);
        this.opacitySlider.valueProperty().addListener((o, oldValue, newValue) -> {
            if (updatingSlider.isFalse()) {
                updatingOpacity.setTrue();
                this.colorProperty.set((Object)YoGraphic3DStyleEditorPaneController.changeOpacity((Color)this.colorProperty.get(), newValue.doubleValue()));
                updatingOpacity.setFalse();
            }
        });
        this.colorProperty.addListener((o, oldValue, newValue) -> {
            if (updatingOpacity.isFalse()) {
                updatingSlider.setTrue();
                this.opacitySlider.setValue(100.0 * newValue.getOpacity());
                updatingSlider.setFalse();
            }
        });
    }

    public void setInput(YoGraphic3DDefinition definition) {
        this.setInput(JavaFXVisualTools.toColor(definition.getColor(), YoGraphicFX3D.DEFAULT_COLOR));
    }

    public void setInput(Color color) {
        this.colorPicker.setValue((Object)color);
        this.opacitySlider.setValue(100.0 * color.getOpacity());
    }

    public void bindYoGraphicFX3D(YoGraphicFX3D yoGraphicFX3DToBind) {
        this.colorProperty.addListener((o, oldValue, newValue) -> yoGraphicFX3DToBind.setColor((Color)newValue));
    }

    public void addInputNotification(Runnable callback) {
        this.colorProperty.addListener((o, oldValue, newValue) -> callback.run());
    }

    private static Color changeOpacity(Color original, double newOpacity) {
        double red = original.getRed();
        double green = original.getGreen();
        double blue = original.getBlue();
        return new Color(red, green, blue, 0.01 * newOpacity);
    }

    public ObservableBooleanValue inputsValidityProperty() {
        return this.inputsValidityProperty;
    }

    public ReadOnlyObjectProperty<Color> colorProperty() {
        return this.colorProperty;
    }

    public GridPane getMainPane() {
        return this.mainPane;
    }
}

