/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import com.jfoenix.controls.JFXDrawer;
import com.jfoenix.controls.JFXHamburger;
import com.jfoenix.controls.events.JFXDrawerEvent;
import com.jfoenix.transitions.hamburger.HamburgerSlideCloseTransition;
import java.io.IOException;
import java.time.Duration;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SubScene;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import us.ihmc.commons.Conversions;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.SidePaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.SessionAdvancedControlsController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.SessionSimpleControlsController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartGroupPanelController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.menu.MainWindowMenuBarController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.plotter.Plotter2D;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;

public class MainWindowController
extends ObservedAnimationTimer {
    @FXML
    private AnchorPane mainPane;
    @FXML
    private AnchorPane sceneAnchorPane;
    @FXML
    private SplitPane mainViewSplitPane;
    @FXML
    private JFXHamburger hamburger;
    @FXML
    private JFXDrawer toolDrawer;
    @FXML
    private Label fpsLabel;
    @FXML
    private MainWindowMenuBarController mainWindowMenuBarController;
    @FXML
    private SessionSimpleControlsController sessionSimpleControlsController;
    @FXML
    private SessionAdvancedControlsController sessionAdvancedControlsController;
    @FXML
    private YoChartGroupPanelController yoChartGroupPanelController;
    private SidePaneController sidePaneController;
    private SessionVisualizerToolkit globalToolkit;
    private SessionVisualizerWindowToolkit windowToolkit;
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;
    private Property<Boolean> showOverheadPlotterProperty;
    private long timeLast = -1L;
    private long timeIntervalBetweenUpdates = Duration.ofMillis(500L).toNanos();
    private int frameCounter = 0;
    private double goodFPSLowerThreshold = 40.0;
    private double mediumFPSLowerThreshold = 20.0;
    private Color goodFPSColor = Color.FORESTGREEN;
    private Color mediumFPSColor = Color.DARKORANGE;
    private Color poorFPSColor = Color.RED;

    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.windowToolkit = toolkit;
        this.globalToolkit = toolkit.getGlobalToolkit();
        this.topics = toolkit.getTopics();
        this.messager = toolkit.getMessager();
        this.mainWindowMenuBarController.initialize(this.windowToolkit);
        this.sessionSimpleControlsController.initialize(this.windowToolkit);
        this.sessionAdvancedControlsController.initialize(this.windowToolkit);
        this.yoChartGroupPanelController.initialize(this.windowToolkit);
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.SIDE_PANE_URL);
            Pane sidePane = this.setupDrawer((Pane)loader.load());
            this.messager.registerJavaFXSyncedTopicListener(this.topics.getDisableUserControls(), disable -> sidePane.setDisable(disable.booleanValue()));
            this.sidePaneController = (SidePaneController)loader.getController();
            this.sidePaneController.initialize(toolkit.getGlobalToolkit());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setupViewport3D(Pane viewportPane) {
        this.sceneAnchorPane.getChildren().set(0, (Object)viewportPane);
        AnchorPane.setTopAnchor((Node)viewportPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)viewportPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)viewportPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)viewportPane, (Double)0.0);
        this.globalToolkit.getSnapshotManager().registerRecordable(viewportPane);
    }

    public Property<Boolean> setupPlotter2D(Plotter2D plotter2D) {
        SubScene plotter2DScene = new SubScene((Parent)plotter2D, 100.0, 10.0);
        Pane pane = new Pane(new Node[]{plotter2DScene});
        plotter2DScene.heightProperty().bind((ObservableValue)pane.heightProperty());
        plotter2DScene.widthProperty().bind((ObservableValue)pane.widthProperty());
        plotter2D.getRoot().getChildren().add((Object)this.globalToolkit.getYoGraphicFXManager().getRootNode2D());
        this.showOverheadPlotterProperty = this.messager.createPropertyInput(this.topics.getShowOverheadPlotter(), (Object)false);
        this.showOverheadPlotterProperty.addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                if (!this.mainViewSplitPane.getItems().contains((Object)pane)) {
                    this.mainViewSplitPane.getItems().add((Object)pane);
                    plotter2D.setScale(80.0);
                }
            } else {
                this.mainViewSplitPane.getItems().remove((Object)pane);
            }
        });
        return this.showOverheadPlotterProperty;
    }

    public Pane setupDrawer(Pane sidePane) {
        StackPane edge = new StackPane();
        edge.setStyle("-fx-background-color:white;-fx-effect:innershadow(three-pass-box, #A9A9A9, 2.5, 0.0, -1.0, 0.0)");
        edge.setPrefWidth(5.0);
        edge.setMinWidth(5.0);
        edge.setCursor(Cursor.E_RESIZE);
        HBox hBox = new HBox(new Node[]{sidePane, edge});
        this.toolDrawer.setSidePane(new Node[]{hBox});
        HBox.setHgrow((Node)sidePane, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)edge, (Priority)Priority.NEVER);
        edge.addEventHandler(MouseEvent.MOUSE_PRESSED, arg_0 -> ((Parent)hBox.getParent()).fireEvent(arg_0));
        edge.addEventHandler(MouseEvent.MOUSE_DRAGGED, arg_0 -> ((Parent)hBox.getParent()).fireEvent(arg_0));
        edge.addEventHandler(MouseEvent.MOUSE_RELEASED, arg_0 -> ((Parent)hBox.getParent()).fireEvent(arg_0));
        Node remove = (Node)this.toolDrawer.getChildren().remove(this.toolDrawer.getChildren().size() - 1);
        this.mainPane.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE && this.toolDrawer.isOpened()) {
                this.toolDrawer.close();
                e.consume();
            }
        });
        this.toolDrawer.setResizeContent(true);
        this.toolDrawer.setResizableOnDrag(true);
        this.toolDrawer.setContent(new Node[]{remove});
        hBox.setVisible(this.toolDrawer.isOpened());
        hBox.setDisable(!this.toolDrawer.isOpened());
        this.toolDrawer.addEventHandler(JFXDrawerEvent.ANY, e -> {
            if (e.getEventType() == JFXDrawerEvent.CLOSED) {
                hBox.setVisible(false);
                hBox.setDisable(true);
            }
            if (e.getEventType() == JFXDrawerEvent.OPENING || e.getEventType() == JFXDrawerEvent.OPENED) {
                hBox.setVisible(true);
                hBox.setDisable(false);
            }
        });
        this.hamburger.setOnMouseClicked(e -> {
            if (this.toolDrawer.isClosed() || this.toolDrawer.isClosing()) {
                this.toolDrawer.open();
                hBox.setVisible(true);
                hBox.setDisable(false);
            } else {
                this.toolDrawer.close();
            }
        });
        HamburgerSlideCloseTransition transition = new HamburgerSlideCloseTransition(this.hamburger);
        this.toolDrawer.addEventHandler(JFXDrawerEvent.CLOSING, e -> {
            transition.setRate(-0.5);
            transition.play();
        });
        this.toolDrawer.addEventFilter(JFXDrawerEvent.OPENING, e -> {
            transition.setRate(0.5);
            transition.play();
        });
        return hBox;
    }

    @Override
    public void handleImpl(long timeNow) {
        if (this.timeLast == -1L) {
            this.timeLast = timeNow;
            this.frameCounter = 0;
            return;
        }
        ++this.frameCounter;
        if (timeNow - this.timeLast < this.timeIntervalBetweenUpdates) {
            return;
        }
        double framesPerSecond = (double)this.frameCounter / Conversions.nanosecondsToSeconds((long)(timeNow - this.timeLast));
        this.fpsLabel.setText(String.format("%6.2f FPS", framesPerSecond));
        if (framesPerSecond >= this.goodFPSLowerThreshold) {
            this.fpsLabel.setTextFill((Paint)this.goodFPSColor);
        } else if (framesPerSecond >= this.mediumFPSLowerThreshold) {
            this.fpsLabel.setTextFill((Paint)this.mediumFPSColor);
        } else {
            this.fpsLabel.setTextFill((Paint)this.poorFPSColor);
        }
        this.timeLast = timeNow;
        this.frameCounter = 0;
    }

    public void start() {
        super.start();
        this.windowToolkit.start();
    }

    public void stop() {
        this.stopSession();
        super.stop();
        this.windowToolkit.stop();
    }

    public void startSession() {
        this.yoChartGroupPanelController.start();
        this.sidePaneController.start();
    }

    public void stopSession() {
        this.yoChartGroupPanelController.closeAndDispose();
        this.sidePaneController.stop();
    }

    public AnchorPane getMainPane() {
        return this.mainPane;
    }

    public AnchorPane getSceneAnchorPane() {
        return this.sceneAnchorPane;
    }

    public SplitPane getMainViewSplitPane() {
        return this.mainViewSplitPane;
    }

    public YoChartGroupPanelController getYoChartGroupPanelController() {
        return this.yoChartGroupPanelController;
    }

    public SidePaneController getSidePaneController() {
        return this.sidePaneController;
    }

    public Property<Boolean> showOverheadPlotterProperty() {
        return this.showOverheadPlotterProperty;
    }

    public BooleanProperty showAdvancedControlsProperty() {
        return this.sessionAdvancedControlsController.showProperty();
    }
}

