/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.scene.Group;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.CameraObjectTrackingRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.JavaFXRigidBody;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.yoRobot.YoRobotFX;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;

public class YoRobotFXManager
extends ObservedAnimationTimer
implements Manager {
    private final Group rootNode = new Group();
    private final List<YoRobotFX> robots = new ArrayList<YoRobotFX>();
    private final YoManager yoManager;
    private final ReferenceFrameManager referenceFrameManager;
    private final BackgroundExecutorManager backgroundExecutorManager;
    private int numberOfRobotDefinitions = -1;

    public YoRobotFXManager(JavaFXMessager messager, SessionVisualizerTopics topics, YoManager yoManager, ReferenceFrameManager referenceFrameManager, BackgroundExecutorManager backgroundExecutorManager) {
        this.yoManager = yoManager;
        this.referenceFrameManager = referenceFrameManager;
        this.backgroundExecutorManager = backgroundExecutorManager;
        messager.registerTopicListener(topics.getCameraTrackObject(), request -> {
            if (!this.isSessionLoaded()) {
                throw new IllegalOperationException("Session has not been loaded yet.");
            }
            String rigidBodyName = request.getRigidBodyName();
            String robotName = request.getRobotName();
            if (rigidBodyName != null) {
                Optional<JavaFXRigidBody> result = robotName != null ? this.robots.stream().filter(r -> r.getRobotDefinition().getName().equalsIgnoreCase(robotName)).findFirst().map(r -> r.findRigidBody(rigidBodyName)) : this.robots.stream().map(r -> r.findRigidBody(rigidBodyName)).filter(Objects::nonNull).findFirst();
                result.ifPresent(rigidBody -> {
                    if (rigidBody.getGraphics() != null && rigidBody.getGraphics().getNode() != null) {
                        messager.submitMessage(topics.getCameraTrackObject(), (Object)new CameraObjectTrackingRequest(rigidBody.getGraphics().getNode()));
                    }
                });
            }
        });
    }

    public void addRobotDefinition(RobotDefinition robotDefinition) {
        YoRobotFX robot = new YoRobotFX(this.yoManager, this.referenceFrameManager, robotDefinition);
        robot.loadRobot(command -> this.backgroundExecutorManager.queueTaskToExecuteInBackground(this, command));
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            this.robots.add(robot);
            this.rootNode.getChildren().add((Object)robot.getRootNode());
        });
    }

    public void addRobotDefinitions(Collection<? extends RobotDefinition> robotDefinitions) {
        robotDefinitions.forEach(robotDefinition -> this.addRobotDefinition((RobotDefinition)robotDefinition));
    }

    public void removeRobotDefinition(RobotDefinition robotDefinition) {
        Optional<YoRobotFX> result = this.robots.stream().filter(robotFX -> robotFX.getRobotDefinition() == robotDefinition).findFirst();
        if (result.isPresent()) {
            YoRobotFX robotToRemove = result.get();
            JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
                this.rootNode.getChildren().remove((Object)robotToRemove.getRootNode());
                this.robots.remove(robotToRemove);
            });
        }
    }

    public void removeRobotDefinitions(Collection<? extends RobotDefinition> robotDefinitions) {
        robotDefinitions.forEach(this::removeRobotDefinition);
    }

    public void removeAllRobotDefinitions() {
        List nodesToDetach = this.robots.stream().map(YoRobotFX::getRootNode).collect(Collectors.toList());
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            this.rootNode.getChildren().removeAll((Collection)nodesToDetach);
            this.robots.clear();
        });
    }

    @Override
    public void handleImpl(long now) {
        this.robots.forEach(YoRobotFX::render);
    }

    @Override
    public void startSession(Session session) {
        this.start();
        List robotDefinitions = session.getRobotDefinitions();
        this.numberOfRobotDefinitions = robotDefinitions.size();
        this.addRobotDefinitions(robotDefinitions);
    }

    @Override
    public void stopSession() {
        this.removeAllRobotDefinitions();
        this.numberOfRobotDefinitions = -1;
    }

    @Override
    public boolean isSessionLoaded() {
        if (this.robots.size() < this.numberOfRobotDefinitions) {
            return false;
        }
        return this.robots.stream().allMatch(YoRobotFX::isRobotLoaded);
    }

    public RigidBodyReadOnly getRobotRootBody(String robotName) {
        return this.robots.stream().filter(robot -> robot.getRobotDefinition().getName().equals(robotName)).findFirst().map(YoRobotFX::getRootBody).orElse(null);
    }

    public Group getRootNode() {
        return this.rootNode;
    }
}

