/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import com.google.common.base.CaseFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javax.xml.bind.JAXBException;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartGroupModel;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIdentifier;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeCollection;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositePattern;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeTools;
import us.ihmc.yoVariables.listener.YoRegistryChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoCompositeSearchManager
implements Manager {
    private final YoCompositePattern yoVariablePattern = YoCompositePattern.singleton(YoCompositeTools.YO_VARIABLE);
    private final YoCompositePattern yoBooleanPattern = YoCompositePattern.singleton(YoCompositeTools.YO_BOOLEAN);
    private final YoCompositePattern yoDoublePattern = YoCompositePattern.singleton(YoCompositeTools.YO_DOUBLE);
    private final YoCompositePattern yoIntegerPattern = YoCompositePattern.singleton(YoCompositeTools.YO_INTEGER);
    private final YoCompositePattern yoLongPattern = YoCompositePattern.singleton(YoCompositeTools.YO_LONG);
    private final Set<YoCompositePattern> primitivePatterns = new LinkedHashSet<YoCompositePattern>(Arrays.asList(this.yoVariablePattern, this.yoBooleanPattern, this.yoDoublePattern, this.yoIntegerPattern, this.yoLongPattern));
    private final Map<YoCompositePattern, Class<? extends YoVariable>> primitivePatternToClass = new HashMap<YoCompositePattern, Class<? extends YoVariable>>();
    private final Property<YoCompositeCollection> yoTuple2DCollection = new SimpleObjectProperty((Object)this, "yoTuple2DCollectionProperty", null);
    private final Property<YoCompositeCollection> yoTuple3DCollection = new SimpleObjectProperty((Object)this, "yoTuple3DCollectionProperty", null);
    private final Property<YoCompositeCollection> yoQuaternionCollection = new SimpleObjectProperty((Object)this, "yoQuaternionCollectionProperty", null);
    private final Property<YoCompositeCollection> yoYawPitchRollCollection = new SimpleObjectProperty((Object)this, "yoYawPitchRollCollectionProperty", null);
    private final List<YoCompositePattern> defaultCompositePatterns = new ArrayList<YoCompositePattern>();
    private final ObservableSet<YoCompositePattern> yoCompositePatterns = FXCollections.observableSet(new LinkedHashSet());
    private final ObservableSet<YoCompositePattern> customYoCompositePatterns = FXCollections.observableSet(new LinkedHashSet());
    private final ObservableMap<String, YoCompositePattern> typeToCompositePattern = FXCollections.observableMap(new LinkedHashMap());
    private final ObservableMap<String, Property<YoCompositeCollection>> typeToCompositeCollection = FXCollections.observableMap(new LinkedHashMap());
    private final Map<YoCompositePattern, Map<String, List<YoComposite>>> listOfYoCompositeMaps = new HashMap<YoCompositePattern, Map<String, List<YoComposite>>>();
    private final YoRegistryChangedListener rootRegistryChangeListener = change -> this.refreshYoCompositesInBackground();
    private final YoManager yoManager;
    private final BackgroundExecutorManager backgroundExecutorManager;

    public YoCompositeSearchManager(JavaFXMessager messager, SessionVisualizerTopics topics, YoManager yoManager, BackgroundExecutorManager backgroundExecutorManager) {
        List<YoCompositePattern> compositePatterns;
        this.yoManager = yoManager;
        this.backgroundExecutorManager = backgroundExecutorManager;
        try {
            compositePatterns = XMLTools.loadYoCompositePatterns(SessionVisualizerIOTools.getConfigurationResource("DefaultYoCompositePatterns.scs2.yoComposite"));
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException("Failed to load the default " + YoCompositePattern.class.getSimpleName() + "s.", e);
        }
        this.typeToCompositePattern.addListener(change -> {
            if (change.wasAdded()) {
                this.yoCompositePatterns.add(change.getValueAdded());
            }
            if (change.wasRemoved()) {
                this.yoCompositePatterns.remove(change.getValueRemoved());
            }
        });
        this.primitivePatternToClass.put(this.yoVariablePattern, YoVariable.class);
        this.primitivePatternToClass.put(this.yoBooleanPattern, YoBoolean.class);
        this.primitivePatternToClass.put(this.yoDoublePattern, YoDouble.class);
        this.primitivePatternToClass.put(this.yoIntegerPattern, YoInteger.class);
        this.primitivePatternToClass.put(this.yoLongPattern, YoLong.class);
        for (YoCompositePattern primitivePattern : this.primitivePatterns) {
            String namePrefix = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, primitivePattern.getType());
            SimpleObjectProperty collection = new SimpleObjectProperty((Object)this, namePrefix + "CollectionProperty", null);
            this.typeToCompositeCollection.put((Object)primitivePattern.getType(), (Object)collection);
            this.typeToCompositePattern.put((Object)primitivePattern.getType(), (Object)primitivePattern);
            primitivePattern.getPreferredChartConfigurations().add(new ChartGroupModel("single", Collections.singletonList(new ChartIdentifier(0, 0))));
        }
        for (YoCompositePattern compositePattern : compositePatterns) {
            this.typeToCompositePattern.put((Object)compositePattern.getType(), (Object)compositePattern);
        }
        this.typeToCompositeCollection.put((Object)"YoTuple2D", this.yoTuple2DCollection);
        this.typeToCompositeCollection.put((Object)"YoTuple3D", this.yoTuple3DCollection);
        this.typeToCompositeCollection.put((Object)"YoQuaternion", this.yoQuaternionCollection);
        this.typeToCompositeCollection.put((Object)"YoYawPitchRoll", this.yoYawPitchRollCollection);
        this.defaultCompositePatterns.addAll(this.typeToCompositePattern.values());
        this.typeToCompositePattern.addListener(change -> {
            if (change.wasAdded()) {
                this.customYoCompositePatterns.add(change.getValueAdded());
            }
            if (change.wasRemoved()) {
                this.customYoCompositePatterns.remove(change.getValueRemoved());
            }
        });
        messager.registerTopicListener(topics.getYoCompositePatternLoadRequest(), this::loadYoCompositePatternFromFile);
        messager.registerTopicListener(topics.getYoCompositePatternSaveRequest(), this::saveYoCompositePatternToFile);
        messager.registerTopicListener(topics.getYoCompositeRefreshAll(), m -> this.refreshYoCompositesInBackground());
    }

    @Override
    public void startSession(Session session) {
        LogTools.info((String)"Searching default YoComposite.");
        this.typeToCompositePattern.values().forEach(this::searchYoCompositeNow);
        this.yoManager.getRootRegistry().addListener(this.rootRegistryChangeListener);
        LogTools.info((String)"Initialized default YoComposite.");
    }

    @Override
    public void stopSession() {
        this.yoManager.getRootRegistry().removeListener(this.rootRegistryChangeListener);
        this.typeToCompositePattern.entrySet().removeIf(entry -> !this.defaultCompositePatterns.contains(entry.getValue()));
        this.typeToCompositeCollection.entrySet().removeIf(entry -> !this.typeToCompositePattern.containsKey(entry.getKey()));
        for (YoCompositePattern pattern : this.defaultCompositePatterns) {
            ((Property)this.typeToCompositeCollection.get((Object)pattern.getType())).setValue(null);
        }
        this.customYoCompositePatterns.clear();
        this.listOfYoCompositeMaps.clear();
    }

    @Override
    public boolean isSessionLoaded() {
        for (YoCompositePattern pattern : this.defaultCompositePatterns) {
            if (((Property)this.typeToCompositeCollection.get((Object)pattern.getType())).getValue() != null) continue;
            return false;
        }
        return true;
    }

    public void refreshYoCompositesInBackground() {
        this.typeToCompositePattern.values().forEach(this::searchYoCompositeInBackground);
    }

    public void refreshYoCompositesNow() {
        this.typeToCompositePattern.values().forEach(this::searchYoCompositeNow);
    }

    public void searchYoCompositeInBackground(YoCompositePattern pattern) {
        this.backgroundExecutorManager.queueTaskToExecuteInBackground(this, () -> this.searchYoCompositeNow(pattern));
    }

    public void searchYoCompositeNow(YoCompositePattern pattern) {
        YoRegistry rootRegistry = this.yoManager.getRootRegistry();
        if (rootRegistry == null) {
            return;
        }
        Class<? extends YoVariable> primitiveClass = this.primitivePatternToClass.get(pattern);
        String type = pattern.getType();
        if (primitiveClass != null) {
            List allYoPrimitives = rootRegistry.collectSubtreeVariables().stream().filter(primitiveClass::isInstance).collect(Collectors.toList());
            List<YoComposite> result = allYoPrimitives.stream().map(yoVariable -> new YoComposite(pattern, (YoVariable)yoVariable)).collect(Collectors.toList());
            YoCompositeCollection collection = new YoCompositeCollection(pattern, result);
            JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> ((Property)this.typeToCompositeCollection.get((Object)type)).setValue((Object)collection));
        } else {
            List<YoComposite> result = YoCompositeTools.searchYoComposites(pattern, rootRegistry);
            if (result != null) {
                YoCompositeCollection collection = new YoCompositeCollection(pattern, result);
                JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
                    Property property = (Property)this.typeToCompositeCollection.get((Object)type);
                    if (property == null) {
                        String propertyName = type + "CollectionProperty";
                        property = new SimpleObjectProperty((Object)this, propertyName, null);
                        this.typeToCompositeCollection.put((Object)type, (Object)property);
                        this.typeToCompositePattern.put((Object)type, (Object)pattern);
                    }
                    property.setValue((Object)collection);
                });
            }
        }
    }

    public void discardYoComposite(String typeToDiscard) {
        this.discardYoComposite(this.getPatternFromType(typeToDiscard));
    }

    public void discardYoComposite(YoCompositePattern patternToDiscard) {
        if (patternToDiscard == null || !this.customYoCompositePatterns.contains((Object)patternToDiscard)) {
            return;
        }
        this.typeToCompositePattern.remove((Object)patternToDiscard.getType());
        Property collectionProperty = (Property)this.typeToCompositeCollection.remove((Object)patternToDiscard.getType());
        if (collectionProperty != null) {
            collectionProperty.setValue(null);
        }
        this.listOfYoCompositeMaps.remove(patternToDiscard);
    }

    private void loadYoCompositePatternFromFile(File file) {
        if (file == null) {
            return;
        }
        LogTools.info((String)("Loading file: " + file));
        try {
            List<YoCompositePattern> newPatterns = XMLTools.loadYoCompositePatterns(new FileInputStream(file));
            newPatterns.forEach(this::searchYoCompositeInBackground);
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    public void saveYoCompositePatternToFile(File file) {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Save must only be used from the FX Application Thread");
        }
        if (file == null) {
            return;
        }
        LogTools.info((String)("Saving file: " + file));
        ArrayList<YoCompositePattern> patternsToExport = new ArrayList<YoCompositePattern>(this.typeToCompositePattern.values());
        patternsToExport.removeAll(this.defaultCompositePatterns);
        try {
            XMLTools.saveYoCompositePatterns(new FileOutputStream(file), patternsToExport);
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    public void requestSearchListOfYoComposites(String compositeType, Consumer<Map<String, List<YoComposite>>> callback) {
        this.requestSearchListOfYoComposites(this.getPatternFromType(compositeType), callback);
    }

    public void requestSearchListOfYoComposites(YoCompositePattern compositeDefintion, Consumer<Map<String, List<YoComposite>>> callback) {
        if (this.listOfYoCompositeMaps.containsKey(compositeDefintion)) {
            callback.accept(this.listOfYoCompositeMaps.get(compositeDefintion));
            return;
        }
        this.backgroundExecutorManager.queueTaskToExecuteInBackground(this, () -> {
            Map<String, List<YoComposite>> result = YoCompositeTools.searchYoCompositeLists(this.getCollectionFromType(compositeDefintion.getType()));
            if (result != null) {
                JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
                    this.listOfYoCompositeMaps.put(compositeDefintion, result);
                    callback.accept(result);
                });
            }
        });
    }

    public ObservableMap<String, Property<YoCompositeCollection>> typeToCompositeCollection() {
        return this.typeToCompositeCollection;
    }

    public YoComposite getYoComposite(String type, String fullname) {
        YoCompositeCollection collectionFromType = this.getCollectionFromType(type);
        if (collectionFromType != null) {
            return collectionFromType.getYoCompositeFromFullname(fullname);
        }
        return null;
    }

    public YoCompositeCollection getCollectionFromType(String type) {
        Property property = (Property)this.typeToCompositeCollection.get((Object)type);
        if (property != null) {
            return (YoCompositeCollection)property.getValue();
        }
        return null;
    }

    public ObservableSet<YoCompositePattern> yoCompositePatterns() {
        return this.yoCompositePatterns;
    }

    public ObservableSet<YoCompositePattern> customYoCompositePatterns() {
        return this.customYoCompositePatterns;
    }

    public YoCompositePattern getPatternFromType(String type) {
        return (YoCompositePattern)this.typeToCompositePattern.get((Object)type);
    }

    public YoCompositeCollection getYoVariableCollection() {
        return this.getCollectionFromType(this.yoVariablePattern.getType());
    }

    public YoCompositeCollection getYoBooleanCollection() {
        return this.getCollectionFromType(this.yoBooleanPattern.getType());
    }

    public YoCompositeCollection getYoDoubleCollection() {
        return this.getCollectionFromType(this.yoDoublePattern.getType());
    }

    public YoCompositeCollection getYoIntegerCollection() {
        return this.getCollectionFromType(this.yoIntegerPattern.getType());
    }

    public YoCompositeCollection getYoLongCollection() {
        return this.getCollectionFromType(this.yoLongPattern.getType());
    }

    public YoCompositeCollection getYoTuple2DCollection() {
        return (YoCompositeCollection)this.yoTuple2DCollection.getValue();
    }

    public YoCompositeCollection getYoTuple3DCollection() {
        return (YoCompositeCollection)this.yoTuple3DCollection.getValue();
    }

    public YoCompositeCollection getYoQuaternionCollection() {
        return (YoCompositeCollection)this.yoQuaternionCollection.getValue();
    }

    public YoCompositeCollection getYoYawPitchRollCollection() {
        return (YoCompositeCollection)this.yoYawPitchRollCollection.getValue();
    }
}

