/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.commons.math.stat.descriptive.moment.StandardDeviation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.TimestampScrubber;

public class TimestampScrubberTest {
    private static TimestampScrubber scrubber;
    private static long[] robotTimestamps;
    private static long[] videoTimestamps;
    private static int duplicatesAtEndOfFile;

    @BeforeAll
    public static void loadFileTimestamps() throws URISyntaxException, IOException {
        File timestampFile = new File(Objects.requireNonNull(TimestampScrubberTest.class.getClassLoader().getResource("sessionLogs/Capture.dat")).toURI());
        scrubber = new TimestampScrubber(timestampFile, true, false);
        robotTimestamps = scrubber.getRobotTimestampsArray();
        videoTimestamps = scrubber.getVideoTimestampsArray();
        for (int i = robotTimestamps.length - 1; i > 0; --i) {
            if (robotTimestamps[i] != robotTimestamps[i - 1]) continue;
            ++duplicatesAtEndOfFile;
        }
    }

    @Test
    public void testChronologicallyIncreasingRobotTimestamps() {
        for (int i = 1; i < robotTimestamps.length - duplicatesAtEndOfFile; ++i) {
            long currentRobotTimestamp = robotTimestamps[i];
            long previousRobotTimestamp = robotTimestamps[i - 1];
            if (currentRobotTimestamp == previousRobotTimestamp) {
                System.out.println(currentRobotTimestamp + " -- " + previousRobotTimestamp);
            }
            Assertions.assertTrue((currentRobotTimestamp > previousRobotTimestamp ? 1 : 0) != 0, (String)("Current: " + currentRobotTimestamp + " and Previous: " + previousRobotTimestamp + " at Index: " + i));
        }
    }

    @Test
    public void testStandardDeviationBetweenRobotTimestamps() {
        StandardDeviation standardDeviation = new StandardDeviation();
        double[] copyRobotTimestamps = new double[robotTimestamps.length];
        for (int i = 1; i < robotTimestamps.length; ++i) {
            long currentDelta = robotTimestamps[i] - robotTimestamps[i - 1];
            copyRobotTimestamps[i - 1] = currentDelta;
        }
        System.out.println("robotTimestamps Length: " + robotTimestamps.length);
        System.out.println("copyOfRobotTimestamps Length: " + copyRobotTimestamps.length);
        System.out.println("Standard Deviation: " + (long)standardDeviation.evaluate(copyRobotTimestamps));
    }

    @Test
    public void testDeltaStatisticsBetweenRobotTimestamps() {
        long delta = 0L;
        long smallestDelta = 1000000000L;
        long largestDelta = 0L;
        int duplicates = 0;
        long whereItHappened = 0L;
        for (int i = 1; i < robotTimestamps.length - duplicatesAtEndOfFile; ++i) {
            long currentTimestamp = robotTimestamps[i];
            long previousTimestamp = robotTimestamps[i - 1];
            Assertions.assertTrue((currentTimestamp > previousTimestamp ? 1 : 0) != 0, (String)("Current: " + currentTimestamp + "\n Previous: " + previousTimestamp + " at Index: " + i));
            long currentDelta = currentTimestamp - previousTimestamp;
            delta += currentDelta;
            if (currentDelta < smallestDelta) {
                smallestDelta = currentDelta;
            }
            if (currentDelta <= largestDelta) continue;
            largestDelta = currentDelta;
            whereItHappened = previousTimestamp;
        }
        System.out.println("Smallest Delta: " + smallestDelta);
        System.out.println("Largest Delta: " + largestDelta);
        System.out.println("Duplicate robotTimestamps: " + duplicates);
        System.out.println("Average delta for robotTimestamps: " + (delta /= (long)(robotTimestamps.length - duplicates)));
        System.out.println("Where it happened: " + whereItHappened);
    }

    @Test
    public void testGoingThroughRobotTimestampsInOrder() {
        for (int i = 0; i < robotTimestamps.length - duplicatesAtEndOfFile; ++i) {
            long currentVideoTimestamp = scrubber.getVideoTimestampFromRobotTimestamp(robotTimestamps[i]);
            Assertions.assertEquals((long)currentVideoTimestamp, (long)videoTimestamps[i]);
        }
    }

    @Test
    public void testGoingThroughRobotTimestampsBackwards() {
        for (int i = robotTimestamps.length - duplicatesAtEndOfFile - 1; i > 0; --i) {
            scrubber.getVideoTimestampFromRobotTimestamp(robotTimestamps[i]);
            Assertions.assertEquals((long)scrubber.getCurrentVideoTimestamp(), (long)videoTimestamps[i]);
        }
    }

    @Test
    public void testGoingThroughRobotTimestampsEveryOther() {
        for (int i = 0; i < robotTimestamps.length - duplicatesAtEndOfFile; i += 2) {
            scrubber.getVideoTimestampFromRobotTimestamp(robotTimestamps[i]);
            Assertions.assertEquals((long)scrubber.getCurrentVideoTimestamp(), (long)videoTimestamps[i], (String)("For loop index: " + i));
        }
    }

    @Test
    public void testGettingRandomTimestamp() {
        scrubber.getVideoTimestampFromRobotTimestamp(robotTimestamps[26]);
        Assertions.assertEquals((long)scrubber.getCurrentVideoTimestamp(), (long)videoTimestamps[26]);
        scrubber.getVideoTimestampFromRobotTimestamp(robotTimestamps[40]);
        Assertions.assertEquals((long)scrubber.getCurrentVideoTimestamp(), (long)videoTimestamps[40]);
        scrubber.getVideoTimestampFromRobotTimestamp(robotTimestamps[34]);
        Assertions.assertEquals((long)scrubber.getCurrentVideoTimestamp(), (long)videoTimestamps[34]);
    }

    @Test
    public void testSearchRobotTimestampsForIndex() {
        scrubber.getVideoTimestampFromRobotTimestamp(Long.MAX_VALUE);
        int endOfArray = scrubber.getCurrentIndex();
        Assertions.assertEquals((int)(robotTimestamps.length - 1), (int)endOfArray);
    }

    @Test
    public void testFileNotFoundException() {
        File badName = new File("This_is_a_bad_file_name_lol");
        Throwable thrown = Assertions.assertThrows(RuntimeException.class, () -> new TimestampScrubber(badName, true, false));
        String messageException = thrown.getMessage().substring(0, 58);
        Assertions.assertEquals((Object)("java.io.FileNotFoundException: " + String.valueOf(badName)), (Object)messageException);
    }

    @Test
    public void testInsertionPointWhenSearching() {
        scrubber.getVideoTimestampFromRobotTimestamp(robotTimestamps[0] + 1L);
        int insertionPointIndex = scrubber.getCurrentIndex();
        Assertions.assertEquals((int)1, (int)insertionPointIndex);
    }

    static {
        duplicatesAtEndOfFile = 1;
    }
}

