/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoGraphic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="YoList")
public class YoListDefinition {
    private List<String> elements;
    private String size;

    public YoListDefinition() {
    }

    public YoListDefinition(List<String> elements) {
        this.elements = elements;
    }

    public YoListDefinition(List<String> elements, String size) {
        this.elements = elements;
        this.size = size;
    }

    @XmlElement
    public void setElements(List<String> elements) {
        this.elements = elements;
    }

    public void addElement(String element) {
        if (this.elements == null) {
            this.elements = new ArrayList<String>();
        }
        this.elements.add(element);
    }

    public void addElement(double element) {
        this.addElement(Double.toString(element));
    }

    public void addElement(float element) {
        this.addElement(Float.toString(element));
    }

    public void addElement(boolean element) {
        this.addElement(Boolean.toString(element));
    }

    public void addElement(int element) {
        this.addElement(Integer.toString(element));
    }

    public void addElement(long element) {
        this.addElement(Long.toString(element));
    }

    public void addElement(byte element) {
        this.addElement(Byte.toString(element));
    }

    public void setElements(double[] elements) {
        for (double element : elements) {
            this.addElement(element);
        }
    }

    public void setElements(float[] elements) {
        for (float element : elements) {
            this.addElement(element);
        }
    }

    public void setElements(boolean[] elements) {
        for (boolean element : elements) {
            this.addElement(element);
        }
    }

    public void setElements(int[] elements) {
        for (int element : elements) {
            this.addElement(element);
        }
    }

    public void setElements(long[] elements) {
        for (long element : elements) {
            this.addElement(element);
        }
    }

    public void setElements(byte[] elements) {
        for (byte element : elements) {
            this.addElement(element);
        }
    }

    @XmlElement
    public void setSize(String size) {
        this.size = size;
    }

    public void setSize(int size) {
        this.size = Integer.toString(size);
    }

    public List<String> getElements() {
        return this.elements;
    }

    public String getSize() {
        return this.size;
    }

    public int hashCode() {
        return Objects.hash(this.elements, this.size);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        YoListDefinition other = (YoListDefinition)object;
        if (!Objects.equals(this.elements, other.elements)) {
            return false;
        }
        return Objects.equals(this.size, other.size);
    }

    public String toString() {
        return "YoList(elements=" + this.elements + ", size=" + this.size + ")";
    }

    public YoListDefinition copy() {
        return new YoListDefinition((List<String>)(this.elements == null ? null : new ArrayList<String>(this.elements)), this.size);
    }

    public static YoListDefinition parse(String value) {
        if ((value = value.trim()).startsWith("YoList")) {
            String[] elements;
            int elementsFirstIndex = value.indexOf("[");
            if (elementsFirstIndex == -1) {
                elements = null;
            } else {
                String elementsSubstring = value.substring(elementsFirstIndex + 1, value.indexOf("]")).trim();
                if (elementsSubstring.isEmpty()) {
                    elements = new String[]{};
                } else {
                    elements = value.substring(value.indexOf("=") + 2, value.lastIndexOf(",") - 1).split(",");
                    for (int i = 0; i < elements.length; ++i) {
                        elements[i] = elements[i].trim();
                    }
                }
            }
            String size = value.substring(value.lastIndexOf("=") + 1, value.length() - 1).trim();
            if (size.equalsIgnoreCase("null")) {
                size = null;
            }
            return new YoListDefinition(elements == null ? null : Arrays.asList(elements), size);
        }
        throw new IllegalArgumentException("Unknown yoList format: " + value);
    }
}

