/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoGraphic;

import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import us.ihmc.scs2.definition.yoComposite.YoOrientation3DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple2DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;

@XmlRootElement(name="YoGraphicPolygonExtruded3D")
public class YoGraphicPolygonExtruded3DDefinition
extends YoGraphic3DDefinition {
    private YoTuple3DDefinition position;
    private YoOrientation3DDefinition orientation;
    private List<YoTuple2DDefinition> vertices;
    private String numberOfVertices;
    private String thickness;

    public YoGraphicPolygonExtruded3DDefinition() {
    }

    public YoGraphicPolygonExtruded3DDefinition(YoGraphicPolygonExtruded3DDefinition other) {
        super(other);
        this.position = other.position == null ? null : other.position.copy();
        this.orientation = other.orientation == null ? null : other.orientation.copy();
        this.vertices = other.vertices == null ? null : other.vertices.stream().map(YoTuple2DDefinition::copy).toList();
        this.numberOfVertices = other.numberOfVertices;
        this.thickness = other.thickness;
    }

    @Override
    protected void registerFields() {
        super.registerFields();
        this.registerTuple3DField("position", this::getPosition, this::setPosition);
        this.registerOrientation3DField("orientation", this::getOrientation, this::setOrientation);
        this.registerListField("vertices", this::getVertices, this::setVertices, "v", Object::toString, YoTuple2DDefinition::parse);
        this.registerStringField("numberOfVertices", this::getNumberOfVertices, this::setNumberOfVertices);
        this.registerStringField("thickness", this::getThickness, this::setThickness);
    }

    @XmlElement
    public void setPosition(YoTuple3DDefinition position) {
        this.position = position;
    }

    @XmlElement
    public void setOrientation(YoOrientation3DDefinition orientation) {
        this.orientation = orientation;
    }

    @XmlElement
    public void setVertices(List<YoTuple2DDefinition> vertices) {
        this.vertices = vertices;
    }

    public void setNumberOfVertices(int numberOfVertices) {
        this.numberOfVertices = Integer.toString(numberOfVertices);
    }

    @XmlElement
    public void setNumberOfVertices(String numberOfVertices) {
        this.numberOfVertices = numberOfVertices;
    }

    public void setThickness(double thickness) {
        this.thickness = Double.toString(thickness);
    }

    @XmlElement
    public void setThickness(String thickness) {
        this.thickness = thickness;
    }

    public YoTuple3DDefinition getPosition() {
        return this.position;
    }

    public YoOrientation3DDefinition getOrientation() {
        return this.orientation;
    }

    public List<YoTuple2DDefinition> getVertices() {
        return this.vertices;
    }

    public String getNumberOfVertices() {
        return this.numberOfVertices;
    }

    public String getThickness() {
        return this.thickness;
    }

    @Override
    public YoGraphicPolygonExtruded3DDefinition copy() {
        return new YoGraphicPolygonExtruded3DDefinition(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof YoGraphicPolygonExtruded3DDefinition) {
            YoGraphicPolygonExtruded3DDefinition other = (YoGraphicPolygonExtruded3DDefinition)object;
            if (!Objects.equals(this.position, other.position)) {
                return false;
            }
            if (!Objects.equals(this.orientation, other.orientation)) {
                return false;
            }
            if (!Objects.equals(this.vertices, other.vertices)) {
                return false;
            }
            if (!Objects.equals(this.numberOfVertices, other.numberOfVertices)) {
                return false;
            }
            return Objects.equals(this.thickness, other.thickness);
        }
        return false;
    }

    @Override
    public String toString(int indent) {
        String out = "%s [name=%s, visible=%b, color=%s, position=%s, orientation=%s, vertices=%s, numberOfVertices=%s, thickness=%s]";
        return out.formatted(this.getClass().getSimpleName(), this.name, this.visible, this.color, this.position, this.orientation, YoGraphicPolygonExtruded3DDefinition.indentedListString(indent, true, this.vertices, Object::toString), this.numberOfVertices, this.thickness);
    }
}

