/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import java.util.Objects;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.PlanarJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.PlanarJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.state.PlanarJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;

public class PlanarJointDefinition
extends JointDefinition {
    private PlanarJointState initialJointState;

    public PlanarJointDefinition() {
    }

    public PlanarJointDefinition(String name) {
        super(name);
    }

    public PlanarJointDefinition(String name, Tuple3DReadOnly offsetFromParent) {
        super(name, offsetFromParent);
    }

    public PlanarJointDefinition(PlanarJointDefinition other) {
        super(other);
        this.initialJointState = other.initialJointState == null ? null : other.initialJointState.copy();
    }

    @Override
    public void setInitialJointState(JointStateReadOnly initialJointState) {
        if (initialJointState instanceof PlanarJointState) {
            this.setInitialJointState((PlanarJointState)initialJointState);
        } else if (this.initialJointState == null) {
            this.initialJointState = new PlanarJointState(initialJointState);
        } else {
            this.initialJointState.set(initialJointState);
        }
    }

    public void setInitialJointState(PlanarJointState initialJointState) {
        this.initialJointState = initialJointState;
    }

    @Override
    public PlanarJointState getInitialJointState() {
        return this.initialJointState;
    }

    public PlanarJointBasics toJoint(RigidBodyBasics predecessor) {
        return new PlanarJoint(this.getName(), predecessor, (RigidBodyTransformReadOnly)this.getTransformToParent());
    }

    @Override
    public PlanarJointDefinition copy() {
        return new PlanarJointDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.initialJointState);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        PlanarJointDefinition other = (PlanarJointDefinition)object;
        return Objects.equals(this.initialJointState, other.initialJointState);
    }
}

