/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.AffineTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.MomentOfInertiaDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;

@XmlType(propOrder={"name", "mass", "momentOfInertia", "inertiaPose", "childrenJoints", "visualDefinitions", "collisionShapeDefinitions"})
public class RigidBodyDefinition
implements Transformable {
    private String name;
    private double mass;
    private MomentOfInertiaDefinition momentOfInertia = new MomentOfInertiaDefinition();
    private YawPitchRollTransformDefinition inertiaPose = new YawPitchRollTransformDefinition();
    private JointDefinition parentJoint;
    private List<JointDefinition> childrenJoints = new ArrayList<JointDefinition>();
    private List<VisualDefinition> visualDefinitions = new ArrayList<VisualDefinition>();
    private List<CollisionShapeDefinition> collisionShapeDefinitions = new ArrayList<CollisionShapeDefinition>();

    public RigidBodyDefinition() {
    }

    public RigidBodyDefinition(String name) {
        this.setName(name);
    }

    public RigidBodyDefinition(RigidBodyDefinition other) {
        this.name = other.name;
        this.mass = other.mass;
        this.momentOfInertia.set((Matrix3DReadOnly)other.momentOfInertia);
        this.inertiaPose.set((RigidBodyTransformReadOnly)other.inertiaPose);
        for (VisualDefinition visualDefinition : other.visualDefinitions) {
            this.visualDefinitions.add(visualDefinition.copy());
        }
        for (CollisionShapeDefinition collisionShapeDefinition : other.collisionShapeDefinitions) {
            this.collisionShapeDefinitions.add(collisionShapeDefinition.copy());
        }
    }

    @XmlAttribute
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @XmlElement
    public void setMass(double mass) {
        this.mass = mass;
    }

    public double getMass() {
        return this.mass;
    }

    @XmlElement
    public void setMomentOfInertia(MomentOfInertiaDefinition momentOfInertia) {
        this.momentOfInertia = momentOfInertia;
    }

    public void setMomentOfInertia(Matrix3DReadOnly momentOfInertia) {
        this.momentOfInertia.set(momentOfInertia);
    }

    public MomentOfInertiaDefinition getMomentOfInertia() {
        return this.momentOfInertia;
    }

    @XmlElement
    public void setInertiaPose(YawPitchRollTransformDefinition inertiaPose) {
        this.inertiaPose = inertiaPose;
    }

    public void setInertiaPose(RigidBodyTransformReadOnly inertiaPose) {
        this.inertiaPose.set(inertiaPose);
    }

    public void setCenterOfMassOffset(double x, double y, double z) {
        this.inertiaPose.getTranslation().set(x, y, z);
    }

    public void setCenterOfMassOffset(Tuple3DReadOnly centerOfMassOffset) {
        this.setCenterOfMassOffset(centerOfMassOffset.getX(), centerOfMassOffset.getY(), centerOfMassOffset.getZ());
    }

    public YawPitchRollTransformDefinition getInertiaPose() {
        return this.inertiaPose;
    }

    public Vector3D getCenterOfMassOffset() {
        return this.inertiaPose.getTranslation();
    }

    @XmlTransient
    public void setParentJoint(JointDefinition parentJoint) {
        this.parentJoint = parentJoint;
    }

    public JointDefinition getParentJoint() {
        return this.parentJoint;
    }

    @XmlElement(name="childJoint")
    public void setChildrenJoints(List<JointDefinition> childrenJoints) {
        if (this.childrenJoints != null) {
            for (JointDefinition childJoint : this.childrenJoints) {
                childJoint.setPredecessor(null);
            }
        }
        this.childrenJoints = childrenJoints;
        if (this.childrenJoints != null) {
            for (JointDefinition childJoint : this.childrenJoints) {
                childJoint.setPredecessor(this);
            }
        }
    }

    public void addChildJoint(JointDefinition childJoint) {
        this.childrenJoints.add(childJoint);
        childJoint.setPredecessor(this);
    }

    public void addChildJoints(Collection<? extends JointDefinition> childJoints) {
        childJoints.forEach(child -> this.addChildJoint((JointDefinition)child));
    }

    public void removeChildJoint(JointDefinition childJoint) {
        if (this.childrenJoints.remove(childJoint)) {
            childJoint.setPredecessor(null);
        }
    }

    public List<JointDefinition> getChildrenJoints() {
        return this.childrenJoints;
    }

    @XmlElement(name="visual")
    public void setVisualDefinitions(List<VisualDefinition> visualDefinitions) {
        this.visualDefinitions = visualDefinitions;
    }

    public void addVisualDefinition(VisualDefinition visualDefinition) {
        if (visualDefinition == null) {
            return;
        }
        this.visualDefinitions.add(visualDefinition);
    }

    public void addVisualDefinitions(Collection<VisualDefinition> visualDefinitions) {
        visualDefinitions.forEach(this::addVisualDefinition);
    }

    public List<VisualDefinition> getVisualDefinitions() {
        return this.visualDefinitions;
    }

    @XmlElement(name="collision")
    public void setCollisionShapeDefinitions(List<CollisionShapeDefinition> collisionShapeDefinitions) {
        this.collisionShapeDefinitions = collisionShapeDefinitions;
    }

    public void addCollisionShapeDefinition(CollisionShapeDefinition collisionShapeDefinition) {
        this.collisionShapeDefinitions.add(collisionShapeDefinition);
    }

    public List<CollisionShapeDefinition> getCollisionShapeDefinitions() {
        return this.collisionShapeDefinitions;
    }

    public RigidBodyBasics toRootBody(ReferenceFrame parentStationaryFrame) {
        return new RigidBody(this.getName(), parentStationaryFrame);
    }

    public RigidBodyBasics toRigidBody(JointBasics parentJoint) {
        return new RigidBody(this.getName(), parentJoint, (Matrix3DReadOnly)this.getMomentOfInertia(), this.getMass(), (RigidBodyTransformReadOnly)this.getInertiaPose());
    }

    public void applyTransform(Transform transform) {
        transform.transform((RigidBodyTransformBasics)this.inertiaPose);
        transform.transform((Matrix3DBasics)this.momentOfInertia);
        this.visualDefinitions.forEach(visual -> transform.transform((AffineTransformBasics)visual.getOriginPose()));
    }

    public void applyInverseTransform(Transform transform) {
        transform.inverseTransform((RigidBodyTransformBasics)this.inertiaPose);
        transform.inverseTransform((Matrix3DBasics)this.momentOfInertia);
        this.visualDefinitions.forEach(visual -> transform.inverseTransform((AffineTransformBasics)visual.getOriginPose()));
    }

    public RigidBodyDefinition copy() {
        return new RigidBodyDefinition(this);
    }

    public RigidBodyDefinition copyRecursive() {
        RigidBodyDefinition copy = this.copy();
        for (JointDefinition childJoint : this.childrenJoints) {
            JointDefinition childJointCopy = childJoint.copyRecursive();
            copy.addChildJoint(childJointCopy);
        }
        return copy;
    }

    public String toString() {
        String childrenString = this.childrenJoints == null ? "[]" : EuclidCoreIOTools.getCollectionString((String)"[", (String)"]", (String)", ", this.childrenJoints, JointDefinition::getName);
        return this.name + ": inertia pose: " + this.inertiaPose + ", children: " + childrenString;
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.name);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.mass);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.momentOfInertia);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.inertiaPose);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.childrenJoints);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.visualDefinitions);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.collisionShapeDefinitions);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RigidBodyDefinition other = (RigidBodyDefinition)object;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (Double.doubleToLongBits(this.mass) != Double.doubleToLongBits(other.mass)) {
            return false;
        }
        if (!Objects.equals(this.momentOfInertia, other.momentOfInertia)) {
            return false;
        }
        if (!Objects.equals(this.inertiaPose, other.inertiaPose)) {
            return false;
        }
        if (!Objects.equals(this.childrenJoints, other.childrenJoints)) {
            return false;
        }
        if (!Objects.equals(this.visualDefinitions, other.visualDefinitions)) {
            return false;
        }
        return Objects.equals(this.collisionShapeDefinitions, other.collisionShapeDefinitions);
    }
}

