/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2.example;

import java.io.IOException;
import org.apache.commons.lang3.SystemUtils;
import std_msgs.msg.dds.Int64;
import std_msgs.msg.dds.Int64PubSubType;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.ros2.RealtimeROS2Publisher;
import us.ihmc.ros2.RealtimeROS2Subscription;
import us.ihmc.util.PeriodicNonRealtimeThreadSchedulerFactory;
import us.ihmc.util.PeriodicRealtimeThreadSchedulerFactory;
import us.ihmc.util.PeriodicThreadSchedulerFactory;

public class RealtimeROS2PublishSubscribeExample {
    public static void main(String[] args) throws IOException, InterruptedException {
        PeriodicRealtimeThreadSchedulerFactory threadFactory = SystemUtils.IS_OS_LINUX ? new PeriodicRealtimeThreadSchedulerFactory(20) : new PeriodicNonRealtimeThreadSchedulerFactory();
        RealtimeROS2Node node = new RealtimeROS2Node(DomainFactory.PubSubImplementation.FAST_RTPS, (PeriodicThreadSchedulerFactory)threadFactory, "NonRealtimeROS2PublishSubscribeExample", "/us/ihmc");
        RealtimeROS2Publisher publisher = node.createPublisher((TopicDataType)new Int64PubSubType(), "/example", ROS2QosProfile.KEEP_HISTORY((int)3), 10);
        RealtimeROS2Subscription subscription = node.createQueuedSubscription((TopicDataType)new Int64PubSubType(), "/example", ROS2QosProfile.KEEP_HISTORY((int)3), 10);
        node.spin();
        Int64 message = new Int64();
        for (int i = 0; i < 10; ++i) {
            message.setData((long)i);
            publisher.publish((Object)message);
            System.out.println("Sending: " + message);
        }
        Int64 incomingMessage = new Int64();
        while (!subscription.poll((Object)incomingMessage)) {
        }
        System.out.println("Receiving: " + incomingMessage);
        int i = 1;
        while (i < 10) {
            if (!subscription.poll((Object)incomingMessage)) continue;
            System.out.println("Receiving: " + incomingMessage);
            ++i;
        }
        System.out.println("Received all messages!");
        node.destroy();
    }
}

