/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.lidar;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Spatial;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.ui.Picture;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.jMonkeyEngineToolkit.GPULidarListener;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarSceneViewPort;

public class LidarDistortionProcessor
implements SceneProcessor {
    private final ArrayList<GPULidarListener> listeners = new ArrayList();
    private final int scansPerSweep;
    private final int scanHeight;
    private final FloatBuffer lidarOutFloatBuffer;
    private final float[] scan;
    private RenderManager renderManager;
    private final RigidBodyTransform lidarTransform = new RigidBodyTransform();
    private double time = Double.NaN;

    public LidarDistortionProcessor(JMERenderer jmeRenderer, int scansPerSweep, int scanHeight, int numberOfCameras, float startAngle, float fieldOfView, LidarSceneViewPort[] lidarSceneProcessors) {
        ViewPort viewport = jmeRenderer.getRenderManager().createPostView("LidarDistortionViewport", new Camera(scansPerSweep, scanHeight));
        this.scansPerSweep = scansPerSweep;
        this.scanHeight = scanHeight;
        this.scan = new float[scanHeight * scansPerSweep];
        this.lidarOutFloatBuffer = BufferUtils.createFloatBuffer((int)(scansPerSweep * scanHeight));
        FrameBuffer distortionFrameBuffer = new FrameBuffer(scansPerSweep, scanHeight, 1);
        distortionFrameBuffer.setColorBuffer(Image.Format.RGBA32F);
        Material distortionMaterial = LidarDistortionProcessor.createDistortionMaterial(jmeRenderer.getAssetManager(), scansPerSweep, numberOfCameras, startAngle, fieldOfView, lidarSceneProcessors);
        Picture distortionPicture = new Picture("Distortion");
        distortionPicture.setMaterial(distortionMaterial);
        distortionPicture.setHeight((float)scanHeight);
        distortionPicture.setWidth((float)scansPerSweep);
        distortionPicture.setQueueBucket(RenderQueue.Bucket.Gui);
        distortionPicture.setCullHint(Spatial.CullHint.Never);
        viewport.attachScene((Spatial)distortionPicture);
        viewport.setClearFlags(true, true, true);
        viewport.setOutputFrameBuffer(distortionFrameBuffer);
        viewport.addProcessor((SceneProcessor)this);
        distortionPicture.updateGeometricState();
    }

    public void addGPULidarListener(GPULidarListener listener) {
        this.listeners.add(listener);
    }

    private static Material createDistortionMaterial(AssetManager assetManager, int scansPerSweep, int numberOfCameras, float startAngle, float fieldOfView, LidarSceneViewPort[] lidarSceneProcessors) {
        Material distortionMaterial = new Material(assetManager, "lidar/Distortion.j3md");
        for (int i = 0; i < numberOfCameras; ++i) {
            distortionMaterial.setTexture("tex" + i, lidarSceneProcessors[i].getTexture2D());
        }
        distortionMaterial.setFloat("startAngle", startAngle);
        distortionMaterial.setFloat("step", fieldOfView);
        distortionMaterial.setFloat("resolution", 1.0f / (float)scansPerSweep);
        float camModulo = fieldOfView / (float)numberOfCameras + 1.0E-7f;
        distortionMaterial.setFloat("camModulo", camModulo);
        float camModuloPreOffset = -startAngle % (fieldOfView / (float)numberOfCameras);
        float camModuloPostOffset = -fieldOfView / (2.0f * (float)numberOfCameras);
        distortionMaterial.setFloat("camModuloPreOffset", camModuloPreOffset);
        distortionMaterial.setFloat("camModuloPostOffset", camModuloPostOffset);
        distortionMaterial.setFloat("oneOverCameras", 1.0f / (float)numberOfCameras);
        float cameraAngleToTextureAngle = (float)(1.0 / Math.tan((double)fieldOfView / (2.0 * (double)numberOfCameras)));
        distortionMaterial.setFloat("cameraAngleToTextureAngle", cameraAngleToTextureAngle);
        return distortionMaterial;
    }

    public void initialize(RenderManager renderManager, ViewPort vp) {
        this.renderManager = renderManager;
    }

    public void reshape(ViewPort vp, int w, int h) {
        throw new RuntimeException("Cannot resize LIDAR!");
    }

    public boolean isInitialized() {
        return this.renderManager != null;
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
    }

    public void postFrame(FrameBuffer out) {
        this.lidarOutFloatBuffer.clear();
        GL11.glReadPixels((int)0, (int)0, (int)this.scansPerSweep, (int)this.scanHeight, (int)6403, (int)5126, (FloatBuffer)this.lidarOutFloatBuffer);
        this.lidarOutFloatBuffer.rewind();
        for (int i = 0; i < this.scanHeight; ++i) {
            this.lidarOutFloatBuffer.get(this.scan, i * this.scansPerSweep, this.scansPerSweep);
        }
        for (GPULidarListener listener : this.listeners) {
            listener.scan(this.scan, this.lidarTransform, this.time);
        }
    }

    public void setTransform(RigidBodyTransform transform, double time) {
        this.lidarTransform.set(transform);
        this.time = time;
    }

    public void cleanup() {
    }

    public void setProfiler(AppProfiler profiler) {
    }
}

