/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.examples;

import com.jme3.app.SimpleApplication;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;

public class TestParallelProjection
extends SimpleApplication
implements AnalogListener {
    private float frustumSize = 1.0f;

    public static void main(String[] args) {
        TestParallelProjection app = new TestParallelProjection();
        app.start();
    }

    public void simpleInitApp() {
        Geometry teaGeom = (Geometry)this.assetManager.loadModel("Models/Teapot/Teapot.obj");
        DirectionalLight dl = new DirectionalLight();
        dl.setColor(ColorRGBA.White);
        dl.setDirection(Vector3f.UNIT_XYZ.negate());
        this.rootNode.setCullHint(Spatial.CullHint.Never);
        this.rootNode.addLight((Light)dl);
        this.rootNode.attachChild((Spatial)teaGeom);
        this.flyCam.setDragToRotate(true);
        this.cam.setParallelProjection(true);
        float aspect = (float)this.cam.getWidth() / (float)this.cam.getHeight();
        this.cam.setFrustum(-30.0f, 30.0f, -aspect * this.frustumSize, aspect * this.frustumSize, this.frustumSize, -this.frustumSize);
        this.inputManager.addListener((InputListener)this, new String[]{"Size+", "Size-"});
        this.inputManager.addMapping("Size+", new Trigger[]{new KeyTrigger(17)});
        this.inputManager.addMapping("Size-", new Trigger[]{new KeyTrigger(31)});
    }

    public void onAnalog(String name, float value, float tpf) {
        this.frustumSize = name.equals("Size-") ? (this.frustumSize += 0.3f * tpf) : (this.frustumSize -= 0.3f * tpf);
        float aspect = (float)this.cam.getWidth() / (float)this.cam.getHeight();
        this.cam.setFrustum(-1000.0f, 1000.0f, -aspect * this.frustumSize, aspect * this.frustumSize, this.frustumSize, -this.frustumSize);
    }
}

