/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.contextManager;

import com.jme3.system.JmeContext;
import com.jme3.system.awt.AwtPanel;
import com.jme3.system.awt.AwtPanelsContext;
import java.awt.Canvas;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedHashMap;
import java.util.Map;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEContextManager;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEViewportAdapter;
import us.ihmc.jMonkeyEngineToolkit.jme.context.PBOAwtPanel;
import us.ihmc.jMonkeyEngineToolkit.jme.context.PBOAwtPanelsContext;

public class AWTPanelsContextManager
extends JMEContextManager
implements MouseListener {
    private JMERenderer jmeRenderer;
    private Map<Canvas, JMEViewportAdapter> panelViewports = new LinkedHashMap<Canvas, JMEViewportAdapter>();

    public AWTPanelsContextManager(JMERenderer jmeRenderer) {
        super(jmeRenderer);
        this.jmeRenderer = jmeRenderer;
    }

    @Override
    public void addJMEViewportAdapterToContext(JMEViewportAdapter jmeViewportAdapter) {
        this.panelViewports.put(jmeViewportAdapter.getCanvas(), jmeViewportAdapter);
        jmeViewportAdapter.getCanvas().addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Canvas selectedAwtPanel;
        if (this.isSwitchingEnabled() && this.jmeRenderer != null && (selectedAwtPanel = e != null ? (Canvas)e.getComponent() : this.getCurrentViewport().getCanvas()) != null) {
            JmeContext context = this.jmeRenderer.getContext();
            if (context instanceof AwtPanelsContext) {
                ((AwtPanelsContext)context).setInputSource((AwtPanel)selectedAwtPanel);
            } else if (context instanceof PBOAwtPanelsContext) {
                ((PBOAwtPanelsContext)context).setInputSource((PBOAwtPanel)selectedAwtPanel);
            }
            this.setCurrentViewport(this.panelViewports.get(selectedAwtPanel));
            selectedAwtPanel.requestFocus();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.isSwitchingEnabled()) {
            Canvas exitedPanel = (Canvas)e.getComponent();
            JMEViewportAdapter exitedAdapter = this.panelViewports.get(exitedPanel);
            this.resetViewport(exitedAdapter);
        }
    }

    @Override
    public void focusOnCurrentWindow() {
        this.getCurrentViewport().getCanvas().requestFocus();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void closeAndDispose() {
        super.closeAndDispose();
        this.jmeRenderer = null;
        if (this.panelViewports != null) {
            this.panelViewports.clear();
            this.panelViewports = null;
        }
    }
}

