/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.shapes;

import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.stage.Stage;
import us.ihmc.commons.Conversions;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.SegmentedLine3DMeshDataGenerator;
import us.ihmc.javaFXToolkit.graphics.JavaFXMeshDataInterpreter;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.javaFXToolkit.starter.ApplicationRunner;

public class SegmentedLine3DMeshDataGeneratorVisualizer {
    public SegmentedLine3DMeshDataGeneratorVisualizer(Stage primaryStage) {
        primaryStage.setTitle(this.getClass().getSimpleName());
        View3DFactory view3dFactory = new View3DFactory(600.0, 400.0);
        view3dFactory.addCameraController();
        view3dFactory.addWorldCoordinateSystem(0.4);
        long startTime = System.nanoTime();
        MeshDataHolder[] meshDataHolders = this.createSpringMesh();
        long endTime = System.nanoTime();
        System.out.println("Took: " + Conversions.nanosecondsToSeconds((long)(endTime - startTime)) + " sec");
        this.addMeshDataHolderToView3D(view3dFactory, meshDataHolders);
        this.addMeshDataHolderToView3D(view3dFactory, this.createLineMesh());
        primaryStage.setMaximized(true);
        primaryStage.setScene(view3dFactory.getScene());
        primaryStage.show();
    }

    private void addMeshDataHolderToView3D(View3DFactory view3dFactory, MeshDataHolder[] meshDataHolders) {
        for (int i = 0; i < meshDataHolders.length; ++i) {
            double hue = (double)i / ((double)meshDataHolders.length - 1.0) * 360.0;
            MeshDataHolder meshDataHolder = meshDataHolders[i];
            PhongMaterial defaultMaterial = new PhongMaterial(Color.hsb((double)hue, (double)0.9, (double)0.9));
            MeshView meshView = new MeshView();
            meshView.setMesh((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)meshDataHolder));
            meshView.setMaterial((Material)defaultMaterial);
            view3dFactory.addNodeToView((Node)meshView);
        }
    }

    private MeshDataHolder[] createSpringMesh() {
        int numberOfSections = 1000;
        SegmentedLine3DMeshDataGenerator deformablePipeMeshCalculator = new SegmentedLine3DMeshDataGenerator(numberOfSections, 64, 0.02);
        Point3D[] centers = new Point3D[numberOfSections];
        double lx = 1.0;
        double phase = 1.5707963267948966;
        for (int i = 0; i < numberOfSections; ++i) {
            double x = (double)i * lx / ((double)numberOfSections - 1.0);
            double y = 0.3 * Math.cos(Math.PI * 8 * x + phase);
            double z = 0.1 * Math.sin(Math.PI * 8 * x + phase);
            centers[i] = new Point3D(x, y, z);
        }
        deformablePipeMeshCalculator.compute((Point3DReadOnly[])centers);
        return deformablePipeMeshCalculator.getMeshDataHolders();
    }

    private MeshDataHolder[] createLineMesh() {
        int numberOfSections = 100;
        SegmentedLine3DMeshDataGenerator deformablePipeMeshCalculator = new SegmentedLine3DMeshDataGenerator(numberOfSections, 64, 0.02);
        Point3D[] centers = new Point3D[numberOfSections];
        double lx = 1.0;
        for (int i = 0; i < numberOfSections; ++i) {
            double x = (double)i * lx / ((double)numberOfSections - 1.0);
            double y = 0.3;
            double z = 0.3;
            centers[i] = new Point3D(x, y, z);
        }
        deformablePipeMeshCalculator.compute((Point3DReadOnly[])centers);
        return deformablePipeMeshCalculator.getMeshDataHolders();
    }

    public static void main(String[] args) {
        ApplicationRunner.runApplication(SegmentedLine3DMeshDataGeneratorVisualizer::new);
    }
}

