/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.shapes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.shape.MeshView;
import javafx.stage.Stage;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.javaFXToolkit.shapes.JavaFXMultiColorMeshBuilder;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette2D;
import us.ihmc.javaFXToolkit.starter.ApplicationRunner;

public class MultiColorMeshBuilderVisualizer {
    private static final MeshToDisplay MESH_TO_DISPLAY = MeshToDisplay.BOX;
    private Random random = new Random(23423L);

    public MultiColorMeshBuilderVisualizer(Stage primaryStage) {
        primaryStage.setTitle(this.getClass().getSimpleName());
        View3DFactory view3dFactory = new View3DFactory(600.0, 400.0);
        view3dFactory.addCameraController();
        view3dFactory.addWorldCoordinateSystem(0.3);
        Color[] colors = new Color[]{Color.RED, Color.YELLOW, Color.BEIGE, Color.CHOCOLATE, Color.ANTIQUEWHITE, Color.CYAN};
        JavaFXMultiColorMeshBuilder meshBuilder = new JavaFXMultiColorMeshBuilder((TextureColorPalette)new TextureColorPalette2D());
        switch (MESH_TO_DISPLAY) {
            case BOX: {
                view3dFactory.addNodesToView(this.addRandomBoxes(colors, meshBuilder));
                break;
            }
            case LINE: {
                this.addLine(meshBuilder);
            }
            case MULTI_LINE: {
                this.addMultiLine(meshBuilder);
            }
        }
        MeshView meshView = new MeshView(meshBuilder.generateMesh());
        meshView.setMaterial(meshBuilder.generateMaterial());
        view3dFactory.addNodeToView((Node)meshView);
        primaryStage.setScene(view3dFactory.getScene());
        primaryStage.show();
    }

    private void addMultiLine(JavaFXMultiColorMeshBuilder meshBuilder) {
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        double radius = 0.4;
        Random random = new Random();
        for (double angle = 0.0; angle < Math.PI * 2; angle += 0.12566370614359174) {
            double x = radius * random.nextDouble() * Math.cos(angle);
            double y = radius * Math.sin(angle);
            double z = 0.1 * random.nextDouble();
            points.add(new Point3D(x, y, z));
        }
        meshBuilder.addMultiLine(points, 0.01, Color.YELLOWGREEN, true);
    }

    private void addLine(JavaFXMultiColorMeshBuilder meshBuilder) {
        Point3D start = new Point3D(0.3, 0.0, -0.0);
        Point3D end = new Point3D(0.0, 0.3, 0.0);
        double lineWidth = 0.01;
        Color color = Color.RED;
        meshBuilder.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
    }

    public List<Box> addRandomBoxes(Color[] colors, JavaFXMultiColorMeshBuilder meshBuilder) {
        int count = 0;
        Random random = new Random();
        ArrayList<Box> boxes = new ArrayList<Box>();
        for (float x = -1.0f; x <= 1.0f; x += 0.055f) {
            for (float y = -1.0f; y <= 1.0f; y += 0.055f) {
                for (float z = -0.0f; z <= 0.01f; z += 0.055f) {
                    Color color = colors[count % colors.length];
                    Vector3D32 pointsOffset = new Vector3D32(x, y, 0.0f * RandomNumbers.nextFloat((Random)random, (float)-5.0f, (float)5.0f));
                    meshBuilder.addCube(0.05f, (Tuple3DReadOnly)pointsOffset, color);
                    Box box = new Box((double)0.025f, (double)0.025f, (double)0.025f);
                    box.setTranslateX(pointsOffset.getX());
                    box.setTranslateY(pointsOffset.getY());
                    box.setTranslateZ((double)0.05f + pointsOffset.getZ());
                    box.setMaterial((Material)new PhongMaterial(color));
                    boxes.add(box);
                    ++count;
                }
            }
        }
        System.out.println("Number of boxes: " + count);
        return boxes;
    }

    private Color randomColor() {
        return Color.hsb((double)(360.0 * this.random.nextDouble()), (double)this.random.nextDouble(), (double)this.random.nextDouble());
    }

    public static void main(String[] args) {
        ApplicationRunner.runApplication(MultiColorMeshBuilderVisualizer::new);
    }

    private static enum MeshToDisplay {
        BOX,
        LINE,
        MULTI_LINE;

    }
}

