/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.shapes;

import java.util.Random;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.stage.Stage;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.javaFXToolkit.graphics.JavaFXMeshDataInterpreter;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.javaFXToolkit.starter.ApplicationRunner;

public class MeshDataGeneratorVisualizer {
    public MeshDataGeneratorVisualizer(Stage primaryStage) {
        primaryStage.setTitle(this.getClass().getSimpleName());
        View3DFactory view3dFactory = new View3DFactory(600.0, 400.0);
        view3dFactory.addCameraController();
        view3dFactory.addWorldCoordinateSystem(0.4);
        PhongMaterial defaultMaterial = new PhongMaterial(Color.CYAN);
        MeshView torus = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.ArcTorus((double)0.0, (double)Math.PI, (double)0.3, (double)0.1, (int)64)));
        torus.setMaterial((Material)defaultMaterial);
        torus.setTranslateY(1.5);
        view3dFactory.addNodeToView((Node)torus);
        MeshView cylinder = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.Cylinder((double)0.1, (double)0.3, (int)64)));
        cylinder.setMaterial((Material)defaultMaterial);
        cylinder.setTranslateY(0.5);
        view3dFactory.addNodeToView((Node)cylinder);
        MeshView cone = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.Cone((double)0.3, (double)0.1, (int)64)));
        cone.setMaterial((Material)defaultMaterial);
        cone.setTranslateY(-0.3);
        view3dFactory.addNodeToView((Node)cone);
        MeshView sphere = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.Ellipsoid((double)0.3, (double)0.1, (double)0.4, (int)64, (int)64)));
        sphere.setMaterial((Material)defaultMaterial);
        sphere.setTranslateX(0.5);
        view3dFactory.addNodeToView((Node)sphere);
        Point2DReadOnly[] polygonVertices = this.createPolygon();
        MeshView extrudedPolygon = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.ExtrudedPolygon((Point2DReadOnly[])polygonVertices, (double)0.1)));
        extrudedPolygon.setMaterial((Material)defaultMaterial);
        extrudedPolygon.setTranslateX(2.0);
        extrudedPolygon.setTranslateY(0.5);
        view3dFactory.addNodeToView((Node)extrudedPolygon);
        MeshView pyramidCube = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.PyramidCube((double)0.1, (double)0.2, (double)0.1, (double)0.4)));
        pyramidCube.setMaterial((Material)defaultMaterial);
        pyramidCube.setTranslateX(-1.0);
        pyramidCube.setTranslateY(0.0);
        view3dFactory.addNodeToView((Node)pyramidCube);
        MeshView genTruncatedCone = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.GenTruncatedCone((double)0.3, (double)0.2, (double)0.07, (double)0.05, (double)0.1, (int)64)));
        genTruncatedCone.setMaterial((Material)defaultMaterial);
        genTruncatedCone.setTranslateX(-0.5);
        genTruncatedCone.setTranslateY(0.0);
        view3dFactory.addNodeToView((Node)genTruncatedCone);
        MeshView hemiEllipsoid = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.HemiEllipsoid((double)0.3, (double)0.1, (double)0.4, (int)16, (int)16)));
        hemiEllipsoid.setMaterial((Material)defaultMaterial);
        hemiEllipsoid.setTranslateX(-0.5);
        hemiEllipsoid.setTranslateY(0.5);
        view3dFactory.addNodeToView((Node)hemiEllipsoid);
        MeshView polygon = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.Polygon((Point2DReadOnly[])polygonVertices)));
        polygon.setMaterial((Material)defaultMaterial);
        polygon.setTranslateX(-0.5);
        polygon.setTranslateY(3.5);
        view3dFactory.addNodeToView((Node)polygon);
        MeshView cube = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.Cube((double)0.01, (double)0.01, (double)1.0, (boolean)false)));
        cube.setMaterial((Material)defaultMaterial);
        cube.setTranslateX(-0.5);
        cube.setTranslateY(-1.0);
        view3dFactory.addNodeToView((Node)cube);
        MeshView flatRectangle = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.FlatRectangle((double)-0.1, (double)0.1, (double)0.25, (double)0.01, (double)0.2)));
        flatRectangle.setMaterial((Material)defaultMaterial);
        flatRectangle.setTranslateX(0.5);
        flatRectangle.setTranslateY(-1.0);
        view3dFactory.addNodeToView((Node)flatRectangle);
        MeshView wedge = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.Wedge((double)0.4, (double)0.2, (double)0.5)));
        wedge.setMaterial((Material)defaultMaterial);
        wedge.setTranslateX(0.5);
        wedge.setTranslateY(1.0);
        view3dFactory.addNodeToView((Node)wedge);
        MeshView line = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.Line((double)0.0, (double)0.0, (double)0.2, (double)0.0, (double)0.5, (double)0.0, (double)0.01)));
        line.setMaterial((Material)defaultMaterial);
        line.setTranslateX(-0.5);
        line.setTranslateY(1.0);
        view3dFactory.addNodeToView((Node)line);
        MeshView capsule = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.Capsule((double)0.3, (double)0.1, (double)0.05, (double)0.15, (int)16, (int)16)));
        capsule.setMaterial((Material)defaultMaterial);
        capsule.setTranslateX(0.0);
        capsule.setTranslateY(0.0);
        view3dFactory.addNodeToView((Node)capsule);
        MeshView tetrahedron = new MeshView((Mesh)JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)MeshDataGenerator.Tetrahedron((double)0.3)));
        tetrahedron.setMaterial((Material)defaultMaterial);
        tetrahedron.setTranslateX(-1.0);
        tetrahedron.setTranslateY(1.0);
        view3dFactory.addNodeToView((Node)tetrahedron);
        primaryStage.setMaximized(true);
        primaryStage.setScene(view3dFactory.getScene());
        primaryStage.show();
    }

    private Point2DReadOnly[] createPolygon() {
        int numberOfPoints = 20;
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        Point2D randomVertex = new Point2D();
        Random random = new Random(234523L);
        while (polygon.getNumberOfVertices() < numberOfPoints) {
            randomVertex.add((Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.03));
            polygon.addVertex((Point2DReadOnly)randomVertex);
            polygon.update();
        }
        Point2D[] vertices = new Point2D[numberOfPoints];
        int reverseIndex = numberOfPoints;
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            vertices[i] = polygon.getVertex(--reverseIndex);
        }
        return vertices;
    }

    public static void main(String[] args) {
        ApplicationRunner.runApplication(MeshDataGeneratorVisualizer::new);
    }
}

