/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.function.Consumer;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.HybridFile;
import us.ihmc.tools.io.HybridResourceDirectory;
import us.ihmc.tools.io.HybridResourceMode;
import us.ihmc.tools.io.WorkspaceResourceFile;

public class HybridResourceFile
extends HybridFile {
    private final WorkspaceResourceFile workspaceResourceFile;

    public HybridResourceFile(HybridResourceDirectory hybridResourceDirectory, String subsequentPathToResource) {
        this.externalFile = hybridResourceDirectory.getExternalDirectory().resolve(subsequentPathToResource);
        this.workspaceResourceFile = new WorkspaceResourceFile(hybridResourceDirectory.getWorkspaceResourceDirectoryInternal(), subsequentPathToResource);
        this.workspaceFile = this.workspaceResourceFile;
    }

    public boolean getInputStream(Consumer<InputStream> inputStreamGetter) {
        boolean success = false;
        try (InputStream inputStream = this.getInputStreamUnsafe();){
            if (inputStream != null) {
                inputStreamGetter.accept(inputStream);
                success = true;
            } else {
                LogTools.debug((int)1, (Object)"Input stream is null");
            }
        }
        catch (IOException ioException) {
            DefaultExceptionHandler.MESSAGE_AND_STACKTRACE.handleException((Throwable)ioException);
        }
        return success;
    }

    private InputStream getInputStreamUnsafe() {
        return this.mode == HybridResourceMode.WORKSPACE ? this.getClasspathResourceAsStream() : (InputStream)ExceptionTools.handle(() -> new FileInputStream(this.externalFile.toFile()), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }

    public boolean isInputStreamAvailable() {
        boolean isInputStreamAvailable = this.mode == HybridResourceMode.WORKSPACE ? this.workspaceResourceFile.getClasspathResource() != null : Files.exists(this.externalFile, new LinkOption[0]);
        return isInputStreamAvailable;
    }

    public String getLocationOfResourceForReading() {
        if (this.mode == HybridResourceMode.WORKSPACE) {
            return "Resource: " + this.getPathForResourceLoadingPathFiltered();
        }
        return "File: " + this.externalFile.toString();
    }

    public InputStream getClasspathResourceAsStream() {
        return this.workspaceResourceFile.getClasspathResourceAsStream();
    }

    public URL getClasspathResource() {
        return this.workspaceResourceFile.getClasspathResource();
    }

    public String getPathForResourceLoadingPathFiltered() {
        return this.workspaceResourceFile.getPathForResourceLoadingPathFiltered();
    }
}

