/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools;

import us.ihmc.commons.time.Stopwatch;

public class KitchenTimer {
    private final Stopwatch stopwatch = new Stopwatch();
    private double maximumTime;
    private boolean isOff = true;

    public KitchenTimer(double maximumTime) {
        this.maximumTime = maximumTime;
    }

    public void setAndStart(double maximumTime) {
        this.maximumTime = maximumTime;
        this.restart();
    }

    public void restart() {
        this.isOff = false;
        this.stopwatch.start();
    }

    public void turnOff() {
        this.isOff = true;
    }

    public boolean timerIsOff() {
        return this.isOff;
    }

    public boolean isRinging() {
        return !this.timerIsOff() && this.getElapsedTime() > this.maximumTime;
    }

    public boolean isTickingDown() {
        return !this.timerIsOff() && this.getElapsedTime() < this.maximumTime;
    }

    public double getElapsedTime() {
        return this.stopwatch.totalElapsed();
    }
}

