/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io.printing;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class SystemStreamGobbler {
    private final GobbleType[] gobbleTypes;
    private PrintStream originalSysout;
    private PrintStream originalSyserr;

    public static void gobbleOutput(Runnable runnable, GobbleType ... gobbleTypes) {
        SystemStreamGobbler gobbler = new SystemStreamGobbler(gobbleTypes);
        runnable.run();
        gobbler.stopGobbling();
    }

    public SystemStreamGobbler(GobbleType ... gobbleTypes) {
        this.gobbleTypes = gobbleTypes;
        this.startGobbling();
    }

    private void startGobbling() {
        PrintStream gobbleStream = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        });
        for (GobbleType gobbleType : this.gobbleTypes) {
            if (gobbleType == GobbleType.SYSTEM_OUT) {
                this.originalSysout = System.out;
                System.setOut(gobbleStream);
                continue;
            }
            if (gobbleType != GobbleType.SYSTEM_ERROR) continue;
            this.originalSyserr = System.err;
            System.setErr(gobbleStream);
        }
    }

    public void stopGobbling() {
        for (GobbleType gobbleType : this.gobbleTypes) {
            if (gobbleType == GobbleType.SYSTEM_OUT) {
                System.setOut(this.originalSysout);
                continue;
            }
            if (gobbleType != GobbleType.SYSTEM_ERROR) continue;
            System.setErr(this.originalSyserr);
        }
    }

    public static enum GobbleType {
        SYSTEM_ERROR,
        SYSTEM_OUT;

    }
}

