/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.FloatArrayCollector;

public class FloatArrayCollectorTest {
    @Test
    public void testCollectZeroItemsToAZeroLengthArray() {
        float[] collectedArrayOfFloats = (float[])Collections.emptyList().stream().collect(FloatArrayCollector.create());
        Assert.assertEquals((long)0L, (long)collectedArrayOfFloats.length);
    }

    @Test
    public void testCollectOneItem() {
        float[] collectedArrayOfFloats = (float[])Collections.singletonList(1.0).stream().collect(FloatArrayCollector.create());
        Assert.assertEquals((long)1L, (long)collectedArrayOfFloats.length);
        Assert.assertEquals((double)1.0, (double)collectedArrayOfFloats[0], (double)1.0E-5);
    }

    @Test
    public void testCollectManyItems() {
        float[] collectedArrayOfFloats = (float[])Arrays.stream(new double[8192]).mapToObj(Double::new).collect(FloatArrayCollector.create());
        Assert.assertEquals((long)collectedArrayOfFloats.length, (long)8192L);
        float sum = 0.0f;
        for (float floatValue : collectedArrayOfFloats) {
            sum += floatValue;
        }
        Assert.assertEquals((double)0.0, (double)sum, (double)1.0E-5);
    }

    @Test
    public void testCollectParallel() {
        int n = 8192;
        float[] collectedArrayOfFloats = (float[])((Stream)IntStream.range(1, 8193).mapToObj(Double::new).parallel()).collect(FloatArrayCollector.create());
        Assert.assertEquals((long)collectedArrayOfFloats.length, (long)8192L);
        double sum = 0.0;
        for (float floatValue : collectedArrayOfFloats) {
            sum += (double)floatValue;
        }
        Assert.assertEquals((double)3.3558528E7, (double)sum, (double)1.0E-5);
    }
}

