/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.string;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.string.StringAndRegularExpressionMatcher;

public class StringAndRegularExpressionMatcherTest {
    @Test
    public void testSimpleExactMatch() {
        StringAndRegularExpressionMatcher matcher = new StringAndRegularExpressionMatcher();
        matcher.addExactStringToMatch("HelloWorld");
        Assert.assertTrue((boolean)matcher.matches("HelloWorld"));
        Assert.assertFalse((boolean)matcher.matches("helloworld"));
        Assert.assertFalse((boolean)matcher.matches("banana"));
    }

    @Test
    public void testCaseInsensitiveExactMatch() {
        StringAndRegularExpressionMatcher matcher = new StringAndRegularExpressionMatcher(false);
        matcher.addExactStringToMatch("HelloWorld");
        Assert.assertTrue((boolean)matcher.matches("HelloWorld"));
        Assert.assertTrue((boolean)matcher.matches("helloworld"));
        Assert.assertFalse((boolean)matcher.matches("banana"));
    }

    @Test
    public void testRegularExpression() {
        StringAndRegularExpressionMatcher matcher = new StringAndRegularExpressionMatcher();
        matcher.addRegularExpression("HelloWorld");
        matcher.addRegularExpression("GoodbyeWorld");
        Assert.assertTrue((boolean)matcher.matches("HelloWorld"));
        Assert.assertFalse((boolean)matcher.matches("helloworld"));
        Assert.assertFalse((boolean)matcher.matches("banana"));
        matcher.addRegularExpression("b.*a");
        Assert.assertTrue((boolean)matcher.matches("banana"));
        Assert.assertFalse((boolean)matcher.matches("helloworld"));
        matcher.addRegularExpression("h.*w.*");
        Assert.assertTrue((boolean)matcher.matches("helloworld"));
    }

    @Test
    public void testRegularExpressionsAndStrings() {
        StringAndRegularExpressionMatcher matcher = new StringAndRegularExpressionMatcher();
        matcher.addExactStringToMatch("HelloWorld");
        matcher.addExactStringToMatch("GoodbyeWorld");
        Assert.assertTrue((boolean)matcher.matches("HelloWorld"));
        Assert.assertFalse((boolean)matcher.matches("helloworld"));
        Assert.assertFalse((boolean)matcher.matches("banana"));
        matcher.addRegularExpression("b.*a");
        Assert.assertTrue((boolean)matcher.matches("banana"));
        Assert.assertFalse((boolean)matcher.matches("helloworld"));
        matcher.addRegularExpression("h.*w.*");
        Assert.assertTrue((boolean)matcher.matches("helloworld"));
    }
}

