/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.reflect;

import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.reflect.RecursiveObjectComparer;
import us.ihmc.tools.reflect.StringFieldMatcher;

public class RecursiveObjectComparerTest {
    @Test
    public void testStringEqual() throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        String string1 = "abcd";
        String string2 = new String(string1);
        Field hashField = String.class.getDeclaredField("hash");
        ArrayList<Field> fieldsToIgnore = new ArrayList<Field>();
        fieldsToIgnore.add(hashField);
        this.compareAndAssert((Object)string1, (Object)string2, true, fieldsToIgnore);
    }

    @Test
    public void testStringNotEqual() throws IllegalArgumentException, IllegalAccessException {
        String string1 = "abcd";
        String string2 = "efgh";
        this.compareAndAssert(string1, string2, false);
    }

    @Test
    public void testDifferentTypesNotEqual() throws IllegalArgumentException, IllegalAccessException {
        boolean b = true;
        char c = 'a';
        double d = 1.5;
        String s = "hello";
        ArrayList listOfDoubles = new ArrayList();
        ArrayList listOfIntegers = new ArrayList();
        this.compareAndAssert(b, Character.valueOf(c), false);
        this.compareAndAssert(b, d, false);
        this.compareAndAssert(b, s, false);
        this.compareAndAssert(b, listOfDoubles, false);
        this.compareAndAssert(b, listOfIntegers, false);
        this.compareAndAssert(Character.valueOf(c), b, false);
        this.compareAndAssert(Character.valueOf(c), d, false);
        this.compareAndAssert(Character.valueOf(c), s, false);
        this.compareAndAssert(Character.valueOf(c), listOfDoubles, false);
        this.compareAndAssert(Character.valueOf(c), listOfIntegers, false);
        this.compareAndAssert(d, b, false);
        this.compareAndAssert(d, Character.valueOf(c), false);
        this.compareAndAssert(d, s, false);
        this.compareAndAssert(d, listOfDoubles, false);
        this.compareAndAssert(d, listOfIntegers, false);
        this.compareAndAssert(s, b, false);
        this.compareAndAssert(s, Character.valueOf(c), false);
        this.compareAndAssert(s, d, false);
        this.compareAndAssert(s, listOfDoubles, false);
        this.compareAndAssert(s, listOfIntegers, false);
        this.compareAndAssert(listOfDoubles, b, false);
        this.compareAndAssert(listOfDoubles, Character.valueOf(c), false);
        this.compareAndAssert(listOfDoubles, d, false);
        this.compareAndAssert(listOfDoubles, s, false);
    }

    @Test
    public void testDoubleArraysDifferentInObject() throws IllegalArgumentException, IllegalAccessException {
        ObjectWithADoubleArray objectOne = new ObjectWithADoubleArray(new double[]{1.0, 2.0, 3.0});
        ObjectWithADoubleArray objectTwo = new ObjectWithADoubleArray(new double[]{4.0, 5.0, 6.0});
        ObjectWithADoubleArray objectThree = new ObjectWithADoubleArray(new double[]{1.0, 2.0, 3.0});
        this.compareAndAssert(objectTwo, objectOne, false);
        this.compareAndAssert(objectOne, objectThree, true);
        this.compareAndAssert(objectThree, objectOne, true);
    }

    @Test
    public void testBuriedDoubleArraysDifferentInObject() throws IllegalArgumentException, IllegalAccessException {
        ObjectWithADoubleArrayBuried objectOne = new ObjectWithADoubleArrayBuried(new double[]{1.0, 2.0, 3.0});
        ObjectWithADoubleArrayBuried objectTwo = new ObjectWithADoubleArrayBuried(new double[]{4.0, 5.0, 6.0});
        ObjectWithADoubleArrayBuried objectThree = new ObjectWithADoubleArrayBuried(new double[]{1.0, 2.0, 3.0});
        this.compareAndAssert(objectTwo, objectOne, false);
        this.compareAndAssert(objectOne, objectThree, true);
        this.compareAndAssert(objectThree, objectOne, true);
    }

    @Test
    public void testMapEqual() throws IllegalArgumentException, IllegalAccessException {
        HashMap<String, Double> map1 = new HashMap<String, Double>();
        map1.put("abcd", 12.0);
        map1.put("efgh", 23.5);
        HashMap map2 = new HashMap(map1);
        this.compareAndAssert(map1, map2, true);
    }

    @Test
    public void testMapEqualDifferentOrder() throws IllegalArgumentException, IllegalAccessException {
        HashMap<String, Double> map1 = new HashMap<String, Double>();
        map1.put("abcd", 12.0);
        map1.put("efgh", 23.5);
        HashMap<String, Double> map2 = new HashMap<String, Double>();
        map2.put("efgh", 23.5);
        map2.put("abcd", 12.0);
        this.compareAndAssert(map1, map2, true);
    }

    @Test
    public void testMapKeysNotEqual() throws IllegalArgumentException, IllegalAccessException {
        HashMap<String, Double> map1 = new HashMap<String, Double>();
        map1.put("abcd", 12.0);
        map1.put("efgh", 23.5);
        HashMap<String, Double> map2 = new HashMap<String, Double>();
        map2.put("BLA", 12.0);
        map2.put("efgh", 23.5);
        this.compareAndAssert(map1, map2, false);
    }

    @Test
    public void testMapValuesNotEqual() throws IllegalArgumentException, IllegalAccessException {
        HashMap<String, Double> map1 = new HashMap<String, Double>();
        map1.put("abcd", 12.0);
        map1.put("efgh", 23.5);
        HashMap<String, Double> map2 = new HashMap<String, Double>();
        map2.put("BLA", 12.0);
        map2.put("efgh", 2.144342312345E11);
        this.compareAndAssert(map1, map2, false);
    }

    @Test
    public void testClearEqualInitially() throws IllegalArgumentException, IllegalAccessException {
        double[] array1 = new double[]{1.0};
        double[] array2 = new double[]{array1[0]};
        int maxDepth = Integer.MAX_VALUE;
        int maxSize = Integer.MAX_VALUE;
        RecursiveObjectComparer comparer = new RecursiveObjectComparer(maxDepth, maxSize);
        Assert.assertEquals((Object)true, (Object)comparer.compare((Object)array1, (Object)array2));
        comparer.clear();
        array2[0] = 2.0;
        Assert.assertEquals((Object)false, (Object)comparer.compare((Object)array1, (Object)array2));
    }

    @Test
    public void testClearNotEqualInitially() throws IllegalArgumentException, IllegalAccessException {
        double[] array1 = new double[]{1.0};
        double[] array2 = new double[]{2.0};
        int maxDepth = Integer.MAX_VALUE;
        int maxSize = Integer.MAX_VALUE;
        RecursiveObjectComparer comparer = new RecursiveObjectComparer(maxDepth, maxSize);
        Assert.assertEquals((Object)false, (Object)comparer.compare((Object)array1, (Object)array2));
        comparer.clear();
        array2[0] = array1[0];
        Assert.assertEquals((Object)true, (Object)comparer.compare((Object)array1, (Object)array2));
    }

    @Test
    public void testLoopsEqual() throws IllegalArgumentException, IllegalAccessException {
        LoopCloser loopCloser1 = this.createLoop();
        LoopCloser loopCloser2 = this.createLoop();
        this.compareAndAssert(loopCloser1, loopCloser2, true);
    }

    @Test
    public void testLoopsNotEqual() throws IllegalArgumentException, IllegalAccessException {
        LoopCloser loopCloser1 = this.createLoop();
        LoopCloser loopCloser2 = this.createLoop();
        loopCloser2.getLoopClosers().add(null);
        this.compareAndAssert(loopCloser1, loopCloser2, false);
    }

    @Test
    public void testLoopsNotEqual2() throws IllegalArgumentException, IllegalAccessException {
        LoopCloser loopCloser1 = this.createLoop();
        LoopCloser loopCloser2 = this.createLoop();
        loopCloser2.getLoopClosers().add(loopCloser2);
        this.compareAndAssert(loopCloser1, loopCloser2, false);
    }

    @Test
    public void testLoopsNotEqual3() throws IllegalArgumentException, IllegalAccessException {
        LoopCloser loopCloser1 = this.createLoop();
        LoopCloser loopCloser2 = this.createLoop();
        loopCloser2.getLoopClosers().add(loopCloser1);
        this.compareAndAssert(loopCloser1, loopCloser2, false);
    }

    @Test
    public void testArrayOfPrimitives() throws IllegalArgumentException, IllegalAccessException {
        double[] array1 = new double[]{2.0, 3.0};
        double[] array2 = new double[]{2.0, 3.0};
        double[] array3 = new double[]{4.0, 5.0};
        this.compareAndAssert(array1, array2, true);
        this.compareAndAssert(array1, array3, false);
    }

    @Test
    public void testArrayOfStrings() throws IllegalArgumentException, IllegalAccessException {
        String string1 = "abcd";
        String string2 = "efgh";
        String string3 = "ijkl";
        String[] array1 = new String[]{string1, string2};
        String[] array2 = new String[]{string1, string2};
        String[] array3 = new String[]{string1, string3};
        this.compareAndAssert(array1, array2, true);
        this.compareAndAssert(array1, array3, false);
    }

    @Test
    public void testSomePrimitives() throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        SomePrimitives somePrimitives1 = new SomePrimitives();
        SomePrimitives somePrimitives2 = somePrimitives1.copy();
        Field hashField = String.class.getDeclaredField("hash");
        ArrayList<Field> fieldsToIgnore = new ArrayList<Field>();
        fieldsToIgnore.add(hashField);
        this.compareAndAssert((Object)somePrimitives1, (Object)somePrimitives2, true, fieldsToIgnore);
    }

    @Test
    public void testTree() throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        Tree tree1 = new Tree(1, 1);
        Tree tree2 = tree1.inneficientCopy();
        ArrayList<Field> fieldsToIgnore = new ArrayList<Field>();
        fieldsToIgnore.add(AbstractList.class.getDeclaredField("modCount"));
        this.compareAndAssert((Object)tree1, (Object)tree2, true, fieldsToIgnore);
    }

    @Test
    public void testNaN() throws IllegalArgumentException, IllegalAccessException {
        Double d1 = Double.NaN;
        Double d2 = Double.NaN;
        this.compareAndAssert(d1, d2, true);
    }

    @Test
    public void testNaNVector() throws IllegalArgumentException, IllegalAccessException {
        Vector3D object1 = new Vector3D(Double.NaN, Double.NaN, Double.NaN);
        Vector3D object2 = new Vector3D(Double.NaN, Double.NaN, Double.NaN);
        this.compareAndAssert(object1, object2, true);
    }

    @Test
    public void testOneNull() throws IllegalArgumentException, IllegalAccessException {
        Object object1 = null;
        Object object2 = null;
        this.compareAndAssert(object1, object2, true);
        object2 = new Object();
        this.compareAndAssert(object1, object2, false);
        object1 = new Object();
        object2 = null;
        String compareString = this.compareAndAssert(object1, object2, false);
        System.err.println("testOneNull: " + compareString);
    }

    @Test
    public void testOneNullTwo() throws IllegalArgumentException, IllegalAccessException {
        ImmutablePair pair1 = new ImmutablePair(null, new Object());
        ImmutablePair pair2 = new ImmutablePair(null, new Object());
        this.compareAndAssert(pair1, pair2, true);
        pair1 = new ImmutablePair(new Object(), new Object());
        pair2 = new ImmutablePair(null, new Object());
        this.compareAndAssert(pair1, pair2, false);
    }

    @Test
    public void testIgnoreSomeFields() throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        Vector3D firstObject = new Vector3D(0.1, 0.2, 0.3);
        Vector3D secondObject = new Vector3D(0.1, 0.5, 0.3);
        Field yField = Vector3D.class.getDeclaredField("y");
        ArrayList<Field> fieldsToIgnore = new ArrayList<Field>();
        fieldsToIgnore.add(yField);
        this.compareAndAssert(firstObject, secondObject, false);
        this.compareAndAssert((Object)firstObject, (Object)secondObject, true, fieldsToIgnore);
    }

    @Test
    public void testIgnoreSomeNamedFields() throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        ObjectWithAName objectOne = new ObjectWithAName("MyName", 1.1);
        ObjectWithAName objectTwo = new ObjectWithAName("MyName", 1.1);
        this.compareAndAssert(objectOne, objectTwo, true);
        objectTwo = new ObjectWithAName("MyName", 1.9);
        this.compareAndAssert(objectOne, objectTwo, false);
        Field valueField = ObjectWithAName.class.getDeclaredField("value");
        ArrayList<Field> fieldsToIgnore = new ArrayList<Field>();
        fieldsToIgnore.add(valueField);
        this.compareAndAssert((Object)objectOne, (Object)objectTwo, true, fieldsToIgnore);
        Field nameField = ObjectWithAName.class.getDeclaredField("name");
        StringFieldMatcher matcher = new StringFieldMatcher();
        matcher.addStringFieldToMatchExactly(ObjectWithAName.class, nameField, "MyName");
        this.compareAndAssert((Object)objectOne, (Object)objectTwo, true, matcher);
    }

    private LoopCloser createLoop() {
        ArrayList<LoopCloser> loopClosers = new ArrayList<LoopCloser>();
        LoopCloser loopCloser = new LoopCloser(loopClosers);
        loopClosers.add(loopCloser);
        return loopCloser;
    }

    private String compareAndAssert(Object object1, Object object2, boolean expected) throws IllegalArgumentException, IllegalAccessException {
        return this.compareAndAssert(object1, object2, expected, new ArrayList<Field>(), null);
    }

    private String compareAndAssert(Object objectOne, Object objectTwo, boolean expected, StringFieldMatcher matcherToIgnore) throws IllegalArgumentException, IllegalAccessException {
        return this.compareAndAssert(objectOne, objectTwo, expected, new ArrayList<Field>(), matcherToIgnore);
    }

    private String compareAndAssert(Object objectOne, Object objectTwo, boolean expected, ArrayList<Field> fieldsToIgnore) throws IllegalArgumentException, IllegalAccessException {
        return this.compareAndAssert(objectOne, objectTwo, expected, fieldsToIgnore, null);
    }

    private String compareAndAssert(Object object1, Object object2, boolean expected, ArrayList<Field> fieldsToIgnore, StringFieldMatcher stringFieldMatcherToIgnore) throws IllegalArgumentException, IllegalAccessException {
        boolean result;
        int maxDepth = Integer.MAX_VALUE;
        int maxSize = Integer.MAX_VALUE;
        RecursiveObjectComparer comparer = new RecursiveObjectComparer(maxDepth, maxSize);
        if (fieldsToIgnore != null) {
            comparer.addFieldsToIgnore(fieldsToIgnore);
        }
        if (stringFieldMatcherToIgnore != null) {
            comparer.addStringFieldsToIgnore(stringFieldMatcherToIgnore);
        }
        if (expected != (result = comparer.compare(object1, object2))) {
            System.out.println("Differences:");
            System.out.println(comparer.toString());
        }
        Assert.assertEquals((Object)expected, (Object)result);
        return comparer.toString();
    }

    private class ObjectWithADoubleArray {
        private double[] x;

        public ObjectWithADoubleArray(double[] xToSet) {
            this.x = Arrays.copyOf(xToSet, xToSet.length);
        }
    }

    private class ObjectWithADoubleArrayBuried {
        private ObjectWithADoubleArray grave;

        public ObjectWithADoubleArrayBuried(double[] xToSet) {
            this.grave = new ObjectWithADoubleArray(xToSet);
        }
    }

    private static class Tree {
        private ArrayList<Tree> children = new ArrayList();
        private double value = Math.random();
        private final int breadth;
        private final int depth;

        public Tree(int breadth, int depth) {
            this.breadth = breadth;
            this.depth = depth;
            if (depth == 0) {
                return;
            }
            for (int i = 0; i < breadth; ++i) {
                this.children.add(new Tree(breadth, depth - 1));
            }
        }

        public Tree inneficientCopy() {
            Tree ret = new Tree(this.breadth, this.depth);
            ret.value = this.value;
            ret.children.clear();
            if (this.depth > 0) {
                for (int i = 0; i < this.breadth; ++i) {
                    Tree childToCopy = this.children.get(i);
                    Tree copy = childToCopy.inneficientCopy();
                    ret.children.add(copy);
                }
            }
            return ret;
        }
    }

    private static class SomePrimitives {
        private double d;
        private int i;
        private boolean b;
        private String s;

        public SomePrimitives() {
            Random random = new Random(1776L);
            this.d = random.nextDouble();
            this.i = random.nextInt(1000);
            this.b = random.nextBoolean();
            this.s = "" + random.nextDouble();
        }

        public SomePrimitives copy() {
            SomePrimitives ret = new SomePrimitives();
            ret.d = this.d;
            ret.i = this.i;
            ret.b = this.b;
            ret.s = new String(this.s);
            return ret;
        }
    }

    private static class LoopCloser {
        private ArrayList<LoopCloser> loopClosers;

        public ArrayList<LoopCloser> getLoopClosers() {
            return this.loopClosers;
        }

        public LoopCloser(ArrayList<LoopCloser> loopClosers) {
            this.loopClosers = loopClosers;
        }
    }

    private class ObjectWithAName {
        private final String name;
        private final double value;

        public ObjectWithAName(String name, double value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return "name = " + this.name + ", value = " + this.value;
        }
    }
}

