/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.property;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.tools.property.BooleanStoredPropertyKey;
import us.ihmc.tools.property.DoubleStoredPropertyKey;
import us.ihmc.tools.property.IntegerStoredPropertyKey;
import us.ihmc.tools.property.StoredPropertyKeyList;
import us.ihmc.tools.property.StoredPropertySet;

public class StoredPropertySetTest {
    @Test
    public void testLoading() {
        StoredPropertyKeyList keyList = new StoredPropertyKeyList();
        BooleanStoredPropertyKey keyOne = keyList.addBooleanKey("KeyOne");
        DoubleStoredPropertyKey keyTwo = keyList.addDoubleKey("KeyTwo");
        IntegerStoredPropertyKey keyThree = keyList.addIntegerKey("KeyThree");
        StoredPropertySet storedPropertySet = new StoredPropertySet(keyList, StoredPropertySetTest.class, "ihmc-java-toolkit", "src/test/resources");
        storedPropertySet.load();
        Assertions.assertEquals((Object)false, (Object)storedPropertySet.get(keyOne));
        Assertions.assertEquals((double)0.1, (double)storedPropertySet.get(keyTwo));
        Assertions.assertEquals((int)5, (int)storedPropertySet.get(keyThree));
    }

    @Test
    public void testLoadingDifferentVersion() {
        StoredPropertyKeyList keyList = new StoredPropertyKeyList();
        BooleanStoredPropertyKey keyOne = keyList.addBooleanKey("KeyOne");
        DoubleStoredPropertyKey keyTwo = keyList.addDoubleKey("KeyTwo");
        IntegerStoredPropertyKey keyThree = keyList.addIntegerKey("KeyThree");
        StoredPropertySet storedPropertySet = new StoredPropertySet(keyList, StoredPropertySetTest.class, "ihmc-java-toolkit", "src/test/resources");
        storedPropertySet.load();
        Assertions.assertEquals((Object)false, (Object)storedPropertySet.get(keyOne));
        Assertions.assertEquals((double)0.1, (double)storedPropertySet.get(keyTwo));
        Assertions.assertEquals((int)5, (int)storedPropertySet.get(keyThree));
        storedPropertySet.updateBackingSaveFile("Version2");
        storedPropertySet.load();
        Assertions.assertEquals((Object)true, (Object)storedPropertySet.get(keyOne));
        Assertions.assertEquals((double)4.3, (double)storedPropertySet.get(keyTwo));
        Assertions.assertEquals((int)1, (int)storedPropertySet.get(keyThree));
        storedPropertySet.set(keyOne, false);
        storedPropertySet.set(keyTwo, 0.4);
        storedPropertySet.set(keyThree, 27);
        storedPropertySet.updateBackingSaveFile("Version3");
        storedPropertySet.save();
        storedPropertySet.load();
        Assertions.assertEquals((Object)false, (Object)storedPropertySet.get(keyOne));
        Assertions.assertEquals((double)0.4, (double)storedPropertySet.get(keyTwo));
        Assertions.assertEquals((int)27, (int)storedPropertySet.get(keyThree));
    }

    @Test
    public void testDefaults() {
        StoredPropertyKeyList keyList = new StoredPropertyKeyList();
        BooleanStoredPropertyKey keyOne = keyList.addBooleanKey("KeyOne", true);
        DoubleStoredPropertyKey keyTwo = keyList.addDoubleKey("KeyTwo", 0.4);
        IntegerStoredPropertyKey keyThree = keyList.addIntegerKey("KeyThree", 8);
        StoredPropertySet storedPropertySet = new StoredPropertySet(keyList, StoredPropertySetTest.class, "ihmc-java-toolkit", "src/test/resources");
        Assertions.assertEquals((Object)true, (Object)storedPropertySet.get(keyOne));
        Assertions.assertEquals((double)0.4, (double)storedPropertySet.get(keyTwo));
        Assertions.assertEquals((int)8, (int)storedPropertySet.get(keyThree));
        storedPropertySet.load();
        Assertions.assertEquals((Object)false, (Object)storedPropertySet.get(keyOne));
        Assertions.assertEquals((double)0.1, (double)storedPropertySet.get(keyTwo));
        Assertions.assertEquals((int)5, (int)storedPropertySet.get(keyThree));
    }

    @Test
    public void testEquals() {
        StoredPropertyKeyList keyList = new StoredPropertyKeyList();
        BooleanStoredPropertyKey keyOne = keyList.addBooleanKey("KeyOne", true);
        DoubleStoredPropertyKey keyTwo = keyList.addDoubleKey("KeyTwo", 0.4);
        IntegerStoredPropertyKey keyThree = keyList.addIntegerKey("KeyThree", 8);
        StoredPropertySet storedPropertySet = new StoredPropertySet(keyList, StoredPropertySetTest.class, "ihmc-java-toolkit", "src/test/resources");
        Assertions.assertEquals((Object)true, (Object)storedPropertySet.get(keyOne));
        Assertions.assertEquals((double)0.4, (double)storedPropertySet.get(keyTwo));
        Assertions.assertEquals((int)8, (int)storedPropertySet.get(keyThree));
        StoredPropertySet storedPropertySet2 = new StoredPropertySet(keyList, StoredPropertySetTest.class, "ihmc-java-toolkit", "src/test/resources");
        Assertions.assertEquals((Object)true, (Object)storedPropertySet2.get(keyOne));
        Assertions.assertEquals((double)0.4, (double)storedPropertySet2.get(keyTwo));
        Assertions.assertEquals((int)8, (int)storedPropertySet2.get(keyThree));
        Assertions.assertTrue((boolean)storedPropertySet.equals((Object)storedPropertySet2));
        storedPropertySet2.load();
        Assertions.assertFalse((boolean)storedPropertySet.equals((Object)storedPropertySet2));
    }
}

