/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.containers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.containers.ContainerTools;

public class ContainerToolsTest {
    @Test
    public void testCreateEnumMap() {
        EnumMap enumMap = ContainerTools.createEnumMap(TestEnum.class);
        Assert.assertNotNull((Object)enumMap);
    }

    @Test
    public void testFindLargestElements() {
        ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(this.generateIntegerArray()));
        int maxValueInList = Collections.max(list);
        int largestValue = maxValueInList + 3;
        int secondLargestValue = maxValueInList + 2;
        int thirdLargestValue = maxValueInList + 1;
        list.add(largestValue);
        list.add(secondLargestValue);
        list.add(thirdLargestValue);
        Comparator<Integer> comparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (o1 > o2) {
                    return 1;
                }
                if (o1 < o2) {
                    return -1;
                }
                return 0;
            }
        };
        TreeSet setOfThreeLargestInts = ContainerTools.findLargestElements(list, (Comparator)comparator, (int)3);
        Assert.assertTrue((boolean)setOfThreeLargestInts.contains(largestValue));
        Assert.assertTrue((boolean)setOfThreeLargestInts.contains(secondLargestValue));
        Assert.assertTrue((boolean)setOfThreeLargestInts.contains(thirdLargestValue));
        Assert.assertEquals((long)3L, (long)setOfThreeLargestInts.size());
    }

    @Test
    public void testFlatten() {
        EnumMap map1 = ContainerTools.createEnumMap(TestEnum.class);
        EnumMap map2 = ContainerTools.createEnumMap(TestEnum.class);
        EnumMap map3 = ContainerTools.createEnumMap(TestEnum.class);
        EnumMap mapOfMaps = ContainerTools.createEnumMap(AnotherTestEnum.class);
        for (TestEnum e : TestEnum.values()) {
            map1.put(e, e.ordinal() + 1);
        }
        map2.put(TestEnum.ONE, 3);
        map2.put(TestEnum.TWO, 2);
        map2.put(TestEnum.THREE, 1);
        map3.put(TestEnum.ONE, 2);
        map3.put(TestEnum.TWO, 3);
        map3.put(TestEnum.THREE, 1);
        mapOfMaps.put(AnotherTestEnum.ONE, map1);
        mapOfMaps.put(AnotherTestEnum.TWO, map2);
        mapOfMaps.put(AnotherTestEnum.THREE, map3);
        ArrayList listOfFlattenedValues = ContainerTools.flatten((EnumMap)mapOfMaps);
        Assert.assertEquals((long)9L, (long)listOfFlattenedValues.size());
        int numberOfThrees = 0;
        int numberOfTwos = 0;
        int numberOfOnes = 0;
        for (Integer i : listOfFlattenedValues) {
            if (i == 1) {
                ++numberOfOnes;
            }
            if (i == 2) {
                ++numberOfTwos;
            }
            if (i != 3) continue;
            ++numberOfThrees;
        }
        Assert.assertEquals((long)3L, (long)numberOfOnes);
        Assert.assertEquals((long)3L, (long)numberOfTwos);
        Assert.assertEquals((long)3L, (long)numberOfThrees);
    }

    @Test
    public void testToArrayOfArrays() {
        EnumMap map1 = ContainerTools.createEnumMap(TestEnum.class);
        EnumMap map2 = ContainerTools.createEnumMap(TestEnum.class);
        EnumMap map3 = ContainerTools.createEnumMap(TestEnum.class);
        EnumMap mapOfMaps = ContainerTools.createEnumMap(AnotherTestEnum.class);
        for (TestEnum e : TestEnum.values()) {
            map1.put(e, (double)e.ordinal() + 1.0);
        }
        map2.put(TestEnum.ONE, 3.0);
        map2.put(TestEnum.TWO, 2.0);
        map2.put(TestEnum.THREE, 1.0);
        map3.put(TestEnum.ONE, 2.0);
        map3.put(TestEnum.TWO, 3.0);
        map3.put(TestEnum.THREE, 1.0);
        mapOfMaps.put(AnotherTestEnum.ONE, map1);
        mapOfMaps.put(AnotherTestEnum.TWO, map2);
        mapOfMaps.put(AnotherTestEnum.THREE, map3);
        double[][] arrayOfArrays = ContainerTools.toArrayOfArrays((EnumMap)mapOfMaps);
        Assert.assertEquals((long)3L, (long)arrayOfArrays.length);
        Assert.assertEquals((long)3L, (long)arrayOfArrays[0].length);
        Assert.assertEquals((long)3L, (long)arrayOfArrays[1].length);
        Assert.assertEquals((long)3L, (long)arrayOfArrays[2].length);
        int numberOfThrees = 0;
        int numberOfTwos = 0;
        int numberOfOnes = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (arrayOfArrays[i][j] < 2.0) {
                    ++numberOfOnes;
                    continue;
                }
                if (arrayOfArrays[i][j] > 2.0) {
                    ++numberOfThrees;
                    continue;
                }
                ++numberOfTwos;
            }
        }
        Assert.assertEquals((long)3L, (long)numberOfOnes);
        Assert.assertEquals((long)3L, (long)numberOfTwos);
        Assert.assertEquals((long)3L, (long)numberOfThrees);
    }

    @Test
    public void testAsSortedList() {
        Object[] baseArray = this.generateIntegerArray();
        Vector<Integer> collection = new Vector<Integer>(Arrays.asList(baseArray));
        Arrays.sort(baseArray);
        ArrayList<Object> sortedArrayList = new ArrayList<Object>(Arrays.asList(baseArray));
        List sortedListUsingContainerTools = ContainerTools.asSortedList(collection);
        for (Integer n : sortedArrayList) {
            Assert.assertTrue((boolean)sortedListUsingContainerTools.contains(n));
            Assert.assertEquals((long)sortedArrayList.indexOf(n), (long)sortedListUsingContainerTools.indexOf(n));
        }
    }

    @Test
    public void testRemoveByReference() {
        TreeSet<Integer> set = new TreeSet<Integer>(Arrays.asList(this.generateIntegerArray()));
        ArrayList<Integer> setAsList = new ArrayList<Integer>(set);
        Integer intToRemove = (Integer)setAsList.get(0);
        ContainerTools.removeByReference(setAsList, (Object)intToRemove);
        Assert.assertFalse((boolean)setAsList.contains(intToRemove));
    }

    private Integer[] generateIntegerArray() {
        Random random = new Random();
        int arraySize = random.nextInt(500) + 1;
        Integer[] array = new Integer[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            array[i] = random.nextInt();
        }
        return array;
    }

    private static enum AnotherTestEnum {
        ONE,
        TWO,
        THREE;

    }

    private static enum TestEnum {
        ONE,
        TWO,
        THREE;

    }
}

