/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import org.threeten.bp.temporal.TemporalAccessor;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.Routine;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import schemacrawler.tools.text.utility.html.Alignment;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import sf.util.Utility;

final class SchemaListFormatter
extends BaseFormatter<SchemaTextOptions>
implements SchemaTraversalHandler {
    private final boolean isVerbose;

    SchemaListFormatter(SchemaTextDetailType schemaTextDetailType, SchemaTextOptions options, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, schemaTextDetailType == SchemaTextDetailType.details, outputOptions);
        this.isVerbose = schemaTextDetailType == SchemaTextDetailType.details;
    }

    @Override
    public void begin() {
        if (!((SchemaTextOptions)this.options).isNoHeader()) {
            this.formattingHelper.writeDocumentStart();
        }
    }

    @Override
    public void end() throws SchemaCrawlerException {
        if (!((SchemaTextOptions)this.options).isNoFooter()) {
            this.formattingHelper.writeDocumentEnd();
        }
        super.end();
    }

    @Override
    public void handle(ColumnDataType columnDataType) throws SchemaCrawlerException {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            String databaseSpecificTypeName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? columnDataType.getName() : columnDataType.getFullName();
            this.formattingHelper.writeNameRow(databaseSpecificTypeName, "[data type]");
        }
    }

    @Override
    public void handle(CrawlInfo crawlInfo) {
        if (crawlInfo == null) {
            return;
        }
        String title = crawlInfo.getTitle();
        if (!Utility.isBlank((CharSequence)title)) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.title, title);
        }
        if (((SchemaTextOptions)this.options).isNoInfo()) {
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "System Information");
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeNameValueRow("generated by", crawlInfo.getSchemaCrawlerInfo(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("generated on", this.formatTimestamp((TemporalAccessor)crawlInfo.getCrawlTimestamp()), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("database version", crawlInfo.getDatabaseInfo(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("driver version", crawlInfo.getJdbcDriverInfo(), Alignment.inherit);
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public final void handle(DatabaseInfo dbInfo) {
    }

    @Override
    public void handle(JdbcDriverInfo driverInfo) {
    }

    @Override
    public void handle(Routine routine) {
        String routineTypeDetail = String.format("%s, %s", routine.getRoutineType(), routine.getReturnType());
        String routineName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? routine.getName() : routine.getFullName();
        String routineType = "[" + routineTypeDetail + "]";
        this.formattingHelper.writeNameRow(routineName, routineType);
        this.printRemarks((DatabaseObject)routine);
    }

    @Override
    public void handle(SchemaCrawlerInfo schemaCrawlerInfo) {
    }

    @Override
    public void handle(Sequence sequence) {
        String sequenceName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? sequence.getName() : sequence.getFullName();
        String sequenceType = "[sequence]";
        this.formattingHelper.writeNameRow(sequenceName, "[sequence]");
        this.printRemarks((DatabaseObject)sequence);
    }

    @Override
    public void handle(Synonym synonym) {
        String synonymName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? synonym.getName() : synonym.getFullName();
        String synonymType = "[synonym]";
        this.formattingHelper.writeNameRow(synonymName, "[synonym]");
        this.printRemarks((DatabaseObject)synonym);
    }

    @Override
    public void handle(Table table) {
        String tableName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? table.getName() : table.getFullName();
        String tableType = "[" + table.getTableType() + "]";
        this.formattingHelper.writeNameRow(tableName, tableType);
        this.printRemarks((DatabaseObject)table);
    }

    @Override
    public void handleColumnDataTypesEnd() {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            this.formattingHelper.writeObjectEnd();
        }
    }

    @Override
    public void handleColumnDataTypesStart() {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Data Types");
            this.formattingHelper.writeObjectStart();
        }
    }

    @Override
    public final void handleHeaderEnd() throws SchemaCrawlerException {
    }

    @Override
    public final void handleHeaderStart() throws SchemaCrawlerException {
    }

    @Override
    public final void handleInfoEnd() throws SchemaCrawlerException {
    }

    @Override
    public final void handleInfoStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleRoutinesEnd() throws SchemaCrawlerException {
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleRoutinesStart() throws SchemaCrawlerException {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Routines");
        this.formattingHelper.writeObjectStart();
    }

    @Override
    public void handleSequencesEnd() throws SchemaCrawlerException {
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleSequencesStart() throws SchemaCrawlerException {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Sequences");
        this.formattingHelper.writeObjectStart();
    }

    @Override
    public void handleSynonymsEnd() throws SchemaCrawlerException {
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleSynonymsStart() throws SchemaCrawlerException {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Synonyms");
        this.formattingHelper.writeObjectStart();
    }

    @Override
    public void handleTablesEnd() throws SchemaCrawlerException {
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleTablesStart() throws SchemaCrawlerException {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Tables");
        this.formattingHelper.writeObjectStart();
    }

    private void printRemarks(DatabaseObject object) {
        if (object == null || !object.hasRemarks() || ((SchemaTextOptions)this.options).isHideRemarks()) {
            return;
        }
        this.formattingHelper.writeDescriptionRow(object.getRemarks());
    }
}

