/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import com.annimon.stream.function.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import schemacrawler.schema.BaseForeignKey;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.DefinedObject;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.Grant;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineColumn;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schema.Trigger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.associations.WeakAssociationForeignKey;
import schemacrawler.tools.analysis.associations.WeakAssociationsUtility;
import schemacrawler.tools.analysis.counts.CountsUtility;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseJsonFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.text.utility.org.json.JSONArray;
import schemacrawler.tools.text.utility.org.json.JSONException;
import schemacrawler.tools.text.utility.org.json.JSONObject;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.utility.NamedObjectSort;
import sf.util.StringFormat;

final class SchemaJsonFormatter
extends BaseJsonFormatter<SchemaTextOptions>
implements SchemaTraversalHandler {
    private final boolean isVerbose;
    private final boolean isBrief;

    SchemaJsonFormatter(SchemaTextDetailType schemaTextDetailType, SchemaTextOptions options, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, schemaTextDetailType == SchemaTextDetailType.details, outputOptions);
        this.isVerbose = schemaTextDetailType == SchemaTextDetailType.details;
        this.isBrief = schemaTextDetailType == SchemaTextDetailType.brief;
    }

    @Override
    public void handle(ColumnDataType columnDataType) throws SchemaCrawlerException {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            try {
                JSONObject jsonColumnDataType = new JSONObject();
                this.jsonRoot.accumulate("columnDataypes", jsonColumnDataType);
                String databaseSpecificTypeName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? columnDataType.getName() : columnDataType.getFullName();
                jsonColumnDataType.put("databaseSpecificTypeName", databaseSpecificTypeName);
                jsonColumnDataType.put("basedOn", columnDataType.getBaseType() == null ? "" : columnDataType.getBaseType().getName());
                jsonColumnDataType.put("userDefined", columnDataType.isUserDefined());
                jsonColumnDataType.put("createParameters", columnDataType.getCreateParameters());
                jsonColumnDataType.put("nullable", columnDataType.isNullable());
                jsonColumnDataType.put("autoIncrementable", columnDataType.isAutoIncrementable());
                jsonColumnDataType.put("searchable", columnDataType.getSearchable().toString());
            }
            catch (JSONException e) {
                LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting ColumnDataType: %s", new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
    }

    @Override
    public void handle(Routine routine) {
        try {
            JSONObject jsonRoutine = new JSONObject();
            this.jsonRoot.accumulate("routines", jsonRoutine);
            jsonRoutine.put("name", routine.getName());
            if (!((SchemaTextOptions)this.options).isShowUnqualifiedNames()) {
                jsonRoutine.put("fullName", routine.getFullName());
            }
            jsonRoutine.put("type", routine.getRoutineType());
            jsonRoutine.put("returnType", routine.getReturnType());
            this.printRemarks((DatabaseObject)routine, jsonRoutine);
            if (!this.isBrief) {
                JSONArray jsonParameters = new JSONArray();
                jsonRoutine.put("parameters", jsonParameters);
                List columns = routine.getColumns();
                Collections.sort(columns, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForRoutineColumns()));
                for (RoutineColumn column : columns) {
                    jsonParameters.put(this.handleRoutineColumn(column));
                }
                this.printDefinition((DefinedObject)routine, jsonRoutine);
                if (this.isVerbose && !((SchemaTextOptions)this.options).isHideRoutineSpecificNames()) {
                    jsonRoutine.put("specificName", routine.getSpecificName());
                }
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting Routine: %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public void handle(Sequence sequence) {
        try {
            JSONObject jsonSequence = new JSONObject();
            this.jsonRoot.accumulate("sequences", jsonSequence);
            jsonSequence.put("name", sequence.getName());
            if (!((SchemaTextOptions)this.options).isShowUnqualifiedNames()) {
                jsonSequence.put("fullName", sequence.getFullName());
            }
            this.printRemarks((DatabaseObject)sequence, jsonSequence);
            if (!this.isBrief) {
                jsonSequence.put("increment", sequence.getIncrement());
                jsonSequence.put("minimumValue", sequence.getMinimumValue());
                jsonSequence.put("maximumValue", sequence.getMaximumValue());
                jsonSequence.put("cycle", sequence.isCycle());
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting sequence: %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public void handle(Synonym synonym) {
        try {
            JSONObject jsonSynonym = new JSONObject();
            this.jsonRoot.accumulate("synonyms", jsonSynonym);
            jsonSynonym.put("name", synonym.getName());
            if (!((SchemaTextOptions)this.options).isShowUnqualifiedNames()) {
                jsonSynonym.put("fullName", synonym.getFullName());
            }
            this.printRemarks((DatabaseObject)synonym, jsonSynonym);
            if (!this.isBrief) {
                String referencedObjectName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? synonym.getReferencedObject().getName() : synonym.getReferencedObject().getFullName();
                jsonSynonym.put("referencedObject", referencedObjectName);
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting synonym: %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public void handle(Table table) {
        JSONObject jsonTable = new JSONObject();
        try {
            this.jsonRoot.accumulate("tables", jsonTable);
            jsonTable.put("name", table.getName());
            if (!((SchemaTextOptions)this.options).isShowUnqualifiedNames()) {
                jsonTable.put("fullName", table.getFullName());
            }
            jsonTable.put("type", table.getTableType());
            this.printRemarks((DatabaseObject)table, jsonTable);
            JSONArray jsonColumns = new JSONArray();
            jsonTable.put("columns", jsonColumns);
            List columns = table.getColumns();
            Collections.sort(columns, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForTableColumns()));
            for (Column column : columns) {
                if (column.isHidden() || this.isBrief && !this.isColumnSignificant(column)) continue;
                jsonColumns.put(this.handleTableColumn(column));
            }
            jsonTable.put("primaryKey", this.handleIndex((Index)table.getPrimaryKey()));
            jsonTable.put("foreignKeys", this.handleForeignKeys(table.getForeignKeys()));
            if (!this.isBrief) {
                if (this.isVerbose) {
                    Collection<WeakAssociationForeignKey> weakAssociationsCollection = WeakAssociationsUtility.getWeakAssociations(table);
                    ArrayList<WeakAssociationForeignKey> weakAssociations = new ArrayList<WeakAssociationForeignKey>(weakAssociationsCollection);
                    Collections.sort(weakAssociations);
                    if (((SchemaTextOptions)this.options).isShowWeakAssociations()) {
                        jsonTable.put("weakAssociations", this.handleWeakAssociations(weakAssociations));
                    }
                }
                JSONArray jsonIndexes = new JSONArray();
                jsonTable.put("indexes", jsonIndexes);
                Collection indexesCollection = table.getIndexes();
                ArrayList indexes = new ArrayList(indexesCollection);
                Collections.sort(indexes, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForIndexes()));
                for (Index index : indexes) {
                    jsonIndexes.put(this.handleIndex(index));
                }
                this.printDefinition((DefinedObject)table, jsonTable);
                jsonTable.put("triggers", this.handleTriggers(table.getTriggers()));
                JSONArray jsonTableConstraints = new JSONArray();
                jsonTable.put("tableConstraints", jsonTableConstraints);
                Collection constraintsCollection = table.getTableConstraints();
                ArrayList constraints = new ArrayList(constraintsCollection);
                Collections.sort(constraints, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForIndexes()));
                for (TableConstraint constraint : constraints) {
                    jsonTableConstraints.put(this.handleTableConstraint(constraint));
                }
                if (this.isVerbose) {
                    for (Privilege privilege : table.getPrivileges()) {
                        if (privilege == null) continue;
                        JSONObject jsonPrivilege = new JSONObject();
                        jsonTable.accumulate("privileges", jsonPrivilege);
                        jsonPrivilege.put("name", privilege.getName());
                        for (Grant grant : privilege.getGrants()) {
                            JSONObject jsonGrant = new JSONObject();
                            jsonPrivilege.accumulate("grants", jsonGrant);
                            jsonGrant.put("grantor", grant.getGrantor());
                            jsonGrant.put("grantee", grant.getGrantee());
                            jsonGrant.put("grantable", grant.isGrantable());
                        }
                    }
                }
                JSONObject jsonAdditionalInformation = new JSONObject();
                this.printTableRowCount(table, jsonAdditionalInformation);
                if (jsonAdditionalInformation.length() > 0) {
                    jsonTable.put("additionalInformation", jsonAdditionalInformation);
                }
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting table: %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public void handleColumnDataTypesEnd() {
    }

    @Override
    public void handleColumnDataTypesStart() {
    }

    @Override
    public void handleRoutinesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleRoutinesStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleSequencesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleSequencesStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleSynonymsEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleSynonymsStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesStart() throws SchemaCrawlerException {
    }

    private JSONArray handleColumnReferences(BaseForeignKey<? extends ColumnReference> foreignKey) {
        JSONArray jsonColumnReferences = new JSONArray();
        for (ColumnReference columnReference : foreignKey) {
            try {
                JSONObject jsonColumnReference = new JSONObject();
                String pkColumnName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? columnReference.getPrimaryKeyColumn().getShortName() : columnReference.getPrimaryKeyColumn().getFullName();
                jsonColumnReference.put("pkColumn", pkColumnName);
                String fkColumnName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? columnReference.getForeignKeyColumn().getShortName() : columnReference.getForeignKeyColumn().getFullName();
                jsonColumnReference.put("fkColumn", fkColumnName);
                if (columnReference instanceof ForeignKeyColumnReference && ((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                    int keySequence = ((ForeignKeyColumnReference)columnReference).getKeySequence();
                    jsonColumnReference.put("keySequence", keySequence);
                }
                jsonColumnReferences.put(jsonColumnReference);
            }
            catch (JSONException e) {
                LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting column reference: %s", new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        return jsonColumnReferences;
    }

    private JSONArray handleForeignKeys(Collection<ForeignKey> foreignKeysCollection) {
        JSONArray jsonFks = new JSONArray();
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>(foreignKeysCollection);
        Collections.sort(foreignKeys, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForForeignKeys()));
        for (ForeignKey foreignKey : foreignKeys) {
            if (foreignKey == null) continue;
            try {
                ForeignKeyUpdateRule deleteRule;
                ForeignKeyUpdateRule updateRule;
                JSONObject jsonFk = new JSONObject();
                jsonFks.put(jsonFk);
                if (!((SchemaTextOptions)this.options).isHideForeignKeyNames()) {
                    jsonFk.put("name", foreignKey.getName());
                }
                if ((updateRule = foreignKey.getUpdateRule()) != null && updateRule != ForeignKeyUpdateRule.unknown) {
                    jsonFk.put("updateRule", updateRule.toString());
                }
                if ((deleteRule = foreignKey.getDeleteRule()) != null && deleteRule != ForeignKeyUpdateRule.unknown) {
                    jsonFk.put("deleteRule", deleteRule.toString());
                }
                jsonFk.put("columnReferences", this.handleColumnReferences((BaseForeignKey<? extends ColumnReference>)foreignKey));
                this.printDefinition((DefinedObject)foreignKey, jsonFk);
            }
            catch (JSONException e) {
                LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting foreign key: %s", new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        return jsonFks;
    }

    private JSONObject handleIndex(Index index) {
        JSONObject jsonIndex = new JSONObject();
        if (index == null) {
            return jsonIndex;
        }
        try {
            if (index instanceof PrimaryKey && !((SchemaTextOptions)this.options).isHidePrimaryKeyNames()) {
                jsonIndex.put("name", index.getName());
            } else if (!((SchemaTextOptions)this.options).isHideIndexNames()) {
                jsonIndex.put("name", index.getName());
            }
            this.printRemarks((DatabaseObject)index, jsonIndex);
            IndexType indexType = index.getIndexType();
            if (indexType != IndexType.unknown && indexType != IndexType.other) {
                jsonIndex.put("type", indexType.toString());
            }
            jsonIndex.put("unique", index.isUnique());
            for (IndexColumn indexColumn : index) {
                jsonIndex.accumulate("columns", this.handleTableColumn((Column)indexColumn));
            }
            this.printDefinition((DefinedObject)index, jsonIndex);
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting index: %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
        return jsonIndex;
    }

    private JSONObject handleRoutineColumn(RoutineColumn<?> column) {
        JSONObject jsonColumn = new JSONObject();
        try {
            jsonColumn.put("name", column.getName());
            jsonColumn.put("dataType", column.getColumnDataType().getJavaSqlType().getJavaSqlTypeName());
            jsonColumn.put("databaseSpecificType", column.getColumnDataType().getDatabaseSpecificTypeName());
            jsonColumn.put("width", column.getWidth());
            jsonColumn.put("type", column.getColumnType().toString());
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                jsonColumn.put("ordinal", column.getOrdinalPosition() + 1);
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting routine column: %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
        return jsonColumn;
    }

    private JSONObject handleTableColumn(Column column) {
        JSONObject jsonColumn = new JSONObject();
        try {
            jsonColumn.put("name", column.getName());
            this.printRemarks((DatabaseObject)column, jsonColumn);
            if (column instanceof IndexColumn) {
                jsonColumn.put("sortSequence", ((IndexColumn)column).getSortSequence().name());
            } else {
                jsonColumn.put("dataType", column.getColumnDataType().getJavaSqlType().getJavaSqlTypeName());
                jsonColumn.put("databaseSpecificType", column.getColumnDataType().getDatabaseSpecificTypeName());
                jsonColumn.put("width", column.getWidth());
                jsonColumn.put("size", column.getSize());
                jsonColumn.put("decimalDigits", column.getDecimalDigits());
                jsonColumn.put("nullable", column.isNullable());
                jsonColumn.put("autoIncremented", column.isAutoIncremented());
            }
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                jsonColumn.put("ordinal", column.getOrdinalPosition());
            }
            if (column instanceof DefinedObject) {
                this.printDefinition((DefinedObject)column, jsonColumn);
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting column: %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
        return jsonColumn;
    }

    private JSONObject handleTableConstraint(TableConstraint constraint) {
        JSONObject jsonConstraint = new JSONObject();
        if (constraint == null) {
            return jsonConstraint;
        }
        try {
            TableConstraintType tableConstraintType;
            if (!((SchemaTextOptions)this.options).isHideTableConstraintNames()) {
                jsonConstraint.put("name", constraint.getName());
            }
            if ((tableConstraintType = constraint.getConstraintType()) != TableConstraintType.unknown) {
                jsonConstraint.put("type", tableConstraintType.toString());
            }
            for (TableConstraintColumn tableConstraintColumn : constraint.getColumns()) {
                jsonConstraint.accumulate("columns", this.handleTableColumn((Column)tableConstraintColumn));
            }
            this.printDefinition((DefinedObject)constraint, jsonConstraint);
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting table constraint: %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
        return jsonConstraint;
    }

    private JSONArray handleTriggers(Collection<Trigger> triggers) {
        JSONArray jsonTriggers = new JSONArray();
        for (Trigger trigger : triggers) {
            if (trigger == null) continue;
            try {
                JSONObject jsonTrigger = new JSONObject();
                jsonTriggers.put(jsonTrigger);
                if (!((SchemaTextOptions)this.options).isHideTriggerNames()) {
                    jsonTrigger.put("name", trigger.getName());
                }
                ConditionTimingType conditionTiming = trigger.getConditionTiming();
                EventManipulationType eventManipulationType = trigger.getEventManipulationType();
                if (conditionTiming != null && conditionTiming != ConditionTimingType.unknown && eventManipulationType != null && eventManipulationType != EventManipulationType.unknown) {
                    jsonTrigger.put("conditionTiming", conditionTiming);
                    jsonTrigger.put("eventManipulationType", eventManipulationType);
                }
                jsonTrigger.put("actionOrientation", trigger.getActionOrientation());
                jsonTrigger.put("actionCondition", trigger.getActionCondition());
                jsonTrigger.put("actionStatement", trigger.getActionStatement());
            }
            catch (JSONException e) {
                LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting trigger: %s", new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        return jsonTriggers;
    }

    private JSONArray handleWeakAssociations(Collection<WeakAssociationForeignKey> weakAssociationsCollection) throws JSONException {
        JSONArray jsonFks = new JSONArray();
        ArrayList<WeakAssociationForeignKey> weakAssociations = new ArrayList<WeakAssociationForeignKey>(weakAssociationsCollection);
        Collections.sort(weakAssociations);
        for (WeakAssociationForeignKey weakFk : weakAssociations) {
            if (weakFk == null) continue;
            try {
                JSONObject jsonFk = new JSONObject();
                jsonFks.put(jsonFk);
                jsonFk.put("columnReferences", this.handleColumnReferences(weakFk));
            }
            catch (JSONException e) {
                LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting weak association: ", new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        return jsonFks;
    }

    private void printDefinition(DefinedObject definedObject, JSONObject jsonObject) throws JSONException {
        if (!this.isVerbose) {
            return;
        }
        jsonObject.put("definition", definedObject.getDefinition());
    }

    private void printRemarks(DatabaseObject object, JSONObject jsonObject) throws JSONException {
        if (object == null || ((SchemaTextOptions)this.options).isHideRemarks()) {
            return;
        }
        jsonObject.put("remarks", object.getRemarks());
    }

    private void printTableRowCount(Table table, JSONObject jsonObject) throws JSONException {
        if (!((SchemaTextOptions)this.options).isShowRowCounts() || table == null || !CountsUtility.hasRowCount(table)) {
            return;
        }
        jsonObject.put("rowCount", CountsUtility.getRowCountMessage(table));
    }
}

