/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import com.annimon.stream.function.Supplier;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.operation.DataJsonFormatter;
import schemacrawler.tools.text.operation.DataTextFormatter;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.operation.OperationOptionsBuilder;
import schemacrawler.tools.traversal.DataTraversalHandler;
import schemacrawler.utility.NamedObjectSort;
import schemacrawler.utility.Query;
import schemacrawler.utility.QueryUtility;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class OperationExecutable
extends BaseStagedExecutable {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)OperationExecutable.class.getName());
    private OperationOptions operationOptions;

    public OperationExecutable(String command) {
        super(command);
    }

    @Override
    public void executeOn(Catalog catalog, Connection connection) throws Exception {
        this.loadOperationOptions();
        if (!this.isOutputFormatSupported()) {
            LOGGER.log(Level.INFO, (Supplier)new StringFormat("Output format <%s> not supported for command <%s>", new Object[]{this.outputOptions.getOutputFormatValue(), this.getCommand()}));
            return;
        }
        DataTraversalHandler handler = this.getDataTraversalHandler();
        Query query = this.getQuery();
        try (Statement statement = DatabaseUtility.createStatement((Connection)connection);){
            handler.begin();
            handler.handleInfoStart();
            handler.handle(catalog.getSchemaCrawlerInfo());
            handler.handle(catalog.getDatabaseInfo());
            handler.handle(catalog.getJdbcDriverInfo());
            handler.handleInfoEnd();
            if (query.isQueryOver()) {
                for (Table table : this.getSortedTables(catalog)) {
                    boolean isAlphabeticalSortForTableColumns = this.operationOptions.isAlphabeticalSortForTableColumns();
                    ResultSet results = QueryUtility.executeAgainstTable((Query)query, (Statement)statement, (Table)table, (boolean)isAlphabeticalSortForTableColumns);
                    Throwable throwable = null;
                    try {
                        handler.handleData(table, results);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (results == null) continue;
                        if (throwable != null) {
                            try {
                                results.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        results.close();
                    }
                }
            } else {
                String sql = query.getQuery();
                try (ResultSet resultSet = DatabaseUtility.executeSql((Statement)statement, (String)sql, (boolean)true);){
                    handler.handleData(query, resultSet);
                }
            }
            handler.end();
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException(String.format("Unknown command <%s>", this.getCommand()), (Throwable)e);
        }
    }

    public final OperationOptions getOperationOptions() {
        this.loadOperationOptions();
        return this.operationOptions;
    }

    public boolean isOutputFormatSupported() {
        String outputFormatValue = this.outputOptions.getOutputFormatValue();
        boolean isOutputFormatSupported = TextOutputFormat.isTextOutputFormat(outputFormatValue);
        return isOutputFormatSupported;
    }

    public final void setOperationOptions(OperationOptions operationOptions) {
        this.operationOptions = operationOptions;
    }

    private DataTraversalHandler getDataTraversalHandler() throws SchemaCrawlerException {
        Operation operation = this.getOperation();
        OperationOptions operationOptions = this.getOperationOptions();
        TextOutputFormat outputFormat = TextOutputFormat.valueOfFromString(this.outputOptions.getOutputFormatValue());
        BaseFormatter formatter = outputFormat == TextOutputFormat.json ? new DataJsonFormatter(operation, operationOptions, this.outputOptions) : new DataTextFormatter(operation, operationOptions, this.outputOptions);
        return formatter;
    }

    private Operation getOperation() {
        Operation operation = null;
        try {
            operation = Operation.valueOf(this.command);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            operation = null;
        }
        return operation;
    }

    private Query getQuery() {
        Query query;
        Operation operation = this.getOperation();
        if (operation == null) {
            String queryName = this.command;
            String queryString = this.additionalConfiguration != null ? this.additionalConfiguration.get((Object)queryName) : null;
            query = new Query(queryName, queryString);
        } else {
            query = operation.getQuery();
        }
        return query;
    }

    private List<? extends Table> getSortedTables(Catalog catalog) {
        ArrayList tables = new ArrayList(catalog.getTables());
        Collections.sort(tables, NamedObjectSort.getNamedObjectSort((boolean)this.getOperationOptions().isAlphabeticalSortForTables()));
        return tables;
    }

    private void loadOperationOptions() {
        if (this.operationOptions == null) {
            this.operationOptions = (OperationOptions)new OperationOptionsBuilder().fromConfig(this.additionalConfiguration).toOptions();
        }
    }
}

