/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.iosource;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Objects;
import java.util.logging.Level;
import sf.util.SchemaCrawlerLogger;

public class InputReader
extends Reader {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)InputReader.class.getName());
    private final String description;
    private final Reader reader;
    private final boolean shouldCloseReader;
    private boolean isClosed;

    public InputReader(String description, Reader reader, boolean shouldCloseReader) {
        this.description = Objects.requireNonNull(description, "No description provided");
        this.reader = Objects.requireNonNull(reader, "No reader provided");
        this.shouldCloseReader = shouldCloseReader;
    }

    @Override
    public void close() throws IOException {
        if (this.shouldCloseReader) {
            LOGGER.log(Level.INFO, "Closing input reader");
            this.reader.close();
        } else {
            LOGGER.log(Level.INFO, "Not closing input reader, since output is to an externally provided reader");
        }
        this.isClosed = true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.ensureOpen();
        this.reader.mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return this.reader.markSupported();
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.reader.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        this.ensureOpen();
        return this.reader.read(cbuf);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        return this.reader.read(cbuf, off, len);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        this.ensureOpen();
        return this.reader.read(target);
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.reader.ready();
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        this.reader.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        return this.reader.skip(n);
    }

    public String toString() {
        return this.description;
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed) {
            throw new IllegalStateException(String.format("Could not close input reader <%s>", this.description));
        }
        super.finalize();
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException(String.format("Input reader <%s> is not open", this.description));
        }
    }
}

